/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor.check;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Objects;
import java.util.function.Function;

public abstract class PermissionSecurityCheck<T>
implements SecurityCheck {
    private static final Uni<Object> SUCCESSFUL_CHECK = Uni.createFrom().nullItem();
    private final T permissions;
    private final Function<Object[], T> computedPermissions;
    private final boolean useComputedPermissions;

    private PermissionSecurityCheck(T permissions, Function<Object[], T> computedPermissions) {
        if (permissions == null) {
            Objects.requireNonNull(computedPermissions);
            this.useComputedPermissions = true;
        } else if (computedPermissions == null) {
            this.useComputedPermissions = false;
        } else {
            throw new IllegalStateException("PermissionSecurityCheck must be created either for computed permissionsor plain permissions, but received both");
        }
        this.permissions = permissions;
        this.computedPermissions = computedPermissions;
    }

    private T getPermissions(Object[] parameters) {
        if (this.useComputedPermissions) {
            return this.computedPermissions.apply(parameters);
        }
        return this.permissions;
    }

    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        this.checkPermissions(identity, this.getPermissions(parameters));
    }

    public void apply(SecurityIdentity identity, MethodDescription methodDescription, Object[] parameters) {
        this.checkPermissions(identity, this.getPermissions(parameters));
    }

    public Uni<?> nonBlockingApply(SecurityIdentity identity, Method method, Object[] parameters) {
        return this.checkPermissions(identity, this.getPermissions(parameters), 0);
    }

    public Uni<?> nonBlockingApply(SecurityIdentity identity, MethodDescription methodDescription, Object[] parameters) {
        return this.checkPermissions(identity, this.getPermissions(parameters), 0);
    }

    private static void throwException(SecurityIdentity identity) {
        if (identity.isAnonymous()) {
            throw new UnauthorizedException();
        }
        throw new ForbiddenException();
    }

    protected abstract Uni<?> checkPermissions(SecurityIdentity var1, T var2, int var3);

    protected abstract void checkPermissions(SecurityIdentity var1, T var2);

    public static SecurityCheck of(Permission permission, Function<Object[], Permission> computedPermission) {
        return new PermissionSecurityCheck<Permission>(permission, computedPermission){

            @Override
            protected Uni<?> checkPermissions(final SecurityIdentity identity, Permission permission, int i) {
                return identity.checkPermission(permission).onItem().transformToUni((Function)new Function<Boolean, Uni<? extends Object>>(){

                    @Override
                    public Uni<?> apply(Boolean hasPermission) {
                        if (Boolean.FALSE.equals(hasPermission)) {
                            PermissionSecurityCheck.throwException(identity);
                        }
                        return SUCCESSFUL_CHECK;
                    }
                });
            }

            @Override
            protected void checkPermissions(SecurityIdentity identity, Permission permission) {
                if (!identity.checkPermissionBlocking(permission)) {
                    PermissionSecurityCheck.throwException(identity);
                }
            }
        };
    }

    public static SecurityCheck of(Permission[] permissions, Function<Object[], Permission[]> computedPermissions) {
        return new PermissionSecurityCheck<Permission[]>(permissions, computedPermissions){

            @Override
            protected Uni<?> checkPermissions(SecurityIdentity identity, Permission[] permissions, int i) {
                return PermissionSecurityCheck.checkPermissions(identity, permissions, i);
            }

            @Override
            protected void checkPermissions(SecurityIdentity identity, Permission[] permissions) {
                for (Permission permission : permissions) {
                    if (!identity.checkPermissionBlocking(permission)) continue;
                    return;
                }
                PermissionSecurityCheck.throwException(identity);
            }
        };
    }

    public static SecurityCheck of(Permission[][] permissions, Function<Object[], Permission[][]> computedPermissions) {
        return new PermissionSecurityCheck<Permission[][]>(permissions, computedPermissions){

            @Override
            protected Uni<?> checkPermissions(final SecurityIdentity identity, final Permission[][] permissionGroups, final int i) {
                return PermissionSecurityCheck.checkPermissions(identity, permissionGroups[i], 0).onItem().transformToUni(new Function<Object, Uni<?>>(){

                    @Override
                    public Uni<?> apply(Object o) {
                        if (i + 1 < permissionGroups.length) {
                            return this.checkPermissions(identity, permissionGroups, i + 1);
                        }
                        return SUCCESSFUL_CHECK;
                    }
                });
            }

            @Override
            protected void checkPermissions(SecurityIdentity identity, Permission[][] permissionGroups) {
                Permission[][] permissionArray = permissionGroups;
                int n = permissionArray.length;
                block0: for (int i = 0; i < n; ++i) {
                    Permission[] permissionGroup;
                    for (Permission permission : permissionGroup = permissionArray[i]) {
                        if (identity.checkPermissionBlocking(permission)) continue block0;
                    }
                    PermissionSecurityCheck.throwException(identity);
                }
            }
        };
    }

    private static Uni<?> checkPermissions(final SecurityIdentity identity, final Permission[] permissions, final int i) {
        return identity.checkPermission(permissions[i]).onItem().transformToUni((Function)new Function<Boolean, Uni<? extends Object>>(){

            @Override
            public Uni<?> apply(Boolean hasPermission) {
                boolean hasAnotherPermission;
                if (Boolean.TRUE.equals(hasPermission)) {
                    return SUCCESSFUL_CHECK;
                }
                boolean bl = hasAnotherPermission = i + 1 < permissions.length;
                if (!hasAnotherPermission) {
                    PermissionSecurityCheck.throwException(identity);
                }
                return PermissionSecurityCheck.checkPermissions(identity, permissions, i + 1);
            }
        });
    }
}

