/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.context.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.InjectionPointTransformerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.context.deployment.DotNames;
import io.quarkus.smallrye.context.deployment.spi.ThreadContextProviderBuildItem;
import io.quarkus.smallrye.context.runtime.SmallRyeContextPropagationProvider;
import io.quarkus.smallrye.context.runtime.SmallRyeContextPropagationRecorder;
import io.smallrye.context.SmallRyeManagedExecutor;
import io.smallrye.context.api.ManagedExecutorConfig;
import io.smallrye.context.api.ThreadContextConfig;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class SmallRyeContextPropagationProcessor {
    SmallRyeContextPropagationProcessor() {
    }

    @BuildStep
    void registerBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SmallRyeContextPropagationProvider.class));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildStatic(SmallRyeContextPropagationRecorder recorder, List<ThreadContextProviderBuildItem> threadContextProviders) throws ClassNotFoundException, IOException {
        ArrayList<ThreadContextProvider> discoveredProviders = new ArrayList<ThreadContextProvider>();
        ArrayList<ContextManagerExtension> discoveredExtensions = new ArrayList<ContextManagerExtension>();
        List providers = threadContextProviders.stream().map(ThreadContextProviderBuildItem::getProvider).collect(Collectors.toCollection(ArrayList::new));
        ServiceUtil.classesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + ThreadContextProvider.class.getName())).forEach(providers::add);
        for (Class provider : providers) {
            try {
                discoveredProviders.add((ThreadContextProvider)provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to instantiate declared ThreadContextProvider class: " + provider.getName(), e);
            }
        }
        for (Class extension : ServiceUtil.classesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + ContextManagerExtension.class.getName()))) {
            try {
                discoveredExtensions.add((ContextManagerExtension)extension.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to instantiate declared ThreadContextProvider class: " + extension.getName(), e);
            }
        }
        recorder.configureStaticInit(discoveredProviders, discoveredExtensions);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void build(SmallRyeContextPropagationRecorder recorder, ExecutorBuildItem executorBuildItem, ShutdownContextBuildItem shutdownContextBuildItem, BuildProducer<FeatureBuildItem> feature, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_CONTEXT_PROPAGATION));
        recorder.configureRuntime(executorBuildItem.getExecutorProxy(), (ShutdownContext)shutdownContextBuildItem);
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SmallRyeManagedExecutor.class).scope(ApplicationScoped.class)).addType(ManagedExecutor.class)).defaultBean()).unremovable()).supplier(recorder.initializeManagedExecutor(executorBuildItem.getExecutorProxy())).setRuntimeInit().done());
    }

    @BuildStep
    InjectionPointTransformerBuildItem transformInjectionPoint() {
        return new InjectionPointTransformerBuildItem(new InjectionPointsTransformer(){

            public boolean appliesTo(Type requiredType) {
                DotName typeName = requiredType.name();
                return DotNames.MANAGED_EXECUTOR.equals((Object)typeName) || DotNames.THREAD_CONTEXT.equals((Object)typeName);
            }

            public void transform(InjectionPointsTransformer.TransformationContext transformationContext) {
                String mpConfigIpName;
                if (transformationContext.getQualifiers().stream().anyMatch(ann -> !ann.name().equals((Object)io.quarkus.arc.processor.DotNames.ANY) && !ann.name().equals((Object)io.quarkus.arc.processor.DotNames.DEFAULT))) {
                    return;
                }
                AnnotationTarget target = transformationContext.getTarget();
                String nameDelimiter = "/";
                switch (target.kind()) {
                    case FIELD: {
                        mpConfigIpName = target.asField().declaringClass().name().toString() + "/" + target.asField().name();
                        break;
                    }
                    case METHOD_PARAMETER: {
                        mpConfigIpName = target.asMethodParameter().method().declaringClass().name().toString() + "/" + target.asMethodParameter().method().name() + "/" + (target.asMethodParameter().position() + 1);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                AnnotationInstance meConfigInstance = Annotations.find((Collection)transformationContext.getAllAnnotations(), (DotName)DotNames.MANAGED_EXECUTOR_CONFIG);
                AnnotationInstance tcConfigInstance = Annotations.find((Collection)transformationContext.getAllAnnotations(), (DotName)DotNames.THREAD_CONTEXT_CONFIG);
                if (meConfigInstance != null || tcConfigInstance != null) {
                    ((InjectionPointsTransformer.Transformation)transformationContext.transform().add(DotNames.NAMED_INSTANCE, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)mpConfigIpName)})).done();
                }
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createSynthBeansForConfiguredInjectionPoints(BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, SmallRyeContextPropagationRecorder recorder, BeanDiscoveryFinishedBuildItem bdFinishedBuildItem) {
        HashMap<String, ExecutorConfig> executorMap = new HashMap<String, ExecutorConfig>();
        HashSet<String> unconfiguredExecutorIPs = new HashSet<String>();
        HashMap<String, ThreadConfig> threadContextMap = new HashMap<String, ThreadConfig>();
        HashSet<String> unconfiguredContextIPs = new HashSet<String>();
        for (InjectionPointInfo injectionPointInfo : bdFinishedBuildItem.getInjectionPoints()) {
            AnnotationInstance namedAnnotation = injectionPointInfo.getRequiredQualifier(DotNames.NAMED_INSTANCE);
            if (namedAnnotation == null || injectionPointInfo.getRequiredQualifiers().stream().anyMatch(ann -> !ann.name().equals((Object)DotNames.NAMED_INSTANCE) && !ann.name().equals((Object)io.quarkus.arc.processor.DotNames.ANY) && !ann.name().equals((Object)io.quarkus.arc.processor.DotNames.DEFAULT))) continue;
            AnnotationInstance meConfigInstance = Annotations.find(this.extractAnnotations(injectionPointInfo.getTarget()), (DotName)DotNames.MANAGED_EXECUTOR_CONFIG);
            AnnotationInstance tcConfigInstance = Annotations.find(this.extractAnnotations(injectionPointInfo.getTarget()), (DotName)DotNames.THREAD_CONTEXT_CONFIG);
            String nameValue = namedAnnotation.value().asString();
            if (meConfigInstance == null && tcConfigInstance == null) {
                if (injectionPointInfo.getType().name().equals((Object)DotNames.MANAGED_EXECUTOR)) {
                    unconfiguredExecutorIPs.add(nameValue);
                    continue;
                }
                unconfiguredContextIPs.add(nameValue);
                continue;
            }
            if (meConfigInstance == null && tcConfigInstance == null) continue;
            if (meConfigInstance != null) {
                executorMap.putIfAbsent(nameValue, new ExecutorConfig(meConfigInstance.value("cleared"), meConfigInstance.value("propagated"), meConfigInstance.value("maxAsync"), meConfigInstance.value("maxQueued")));
                continue;
            }
            if (tcConfigInstance == null) continue;
            threadContextMap.putIfAbsent(nameValue, new ThreadConfig(tcConfigInstance.value("cleared"), tcConfigInstance.value("propagated"), tcConfigInstance.value("unchanged")));
        }
        unconfiguredExecutorIPs.removeAll(unconfiguredExecutorIPs.stream().filter(name -> executorMap.containsKey(name)).collect(Collectors.toSet()));
        unconfiguredContextIPs.removeAll(unconfiguredContextIPs.stream().filter(name -> threadContextMap.containsKey(name)).collect(Collectors.toSet()));
        for (Map.Entry entry : executorMap.entrySet()) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ManagedExecutor.class).defaultBean()).unremovable()).setRuntimeInit().scope(ApplicationScoped.class)).addQualifier().annotation(DotNames.NAMED_INSTANCE).addValue("value", entry.getKey()).done()).supplier(recorder.initializeConfiguredManagedExecutor(((ExecutorConfig)entry.getValue()).cleared, ((ExecutorConfig)entry.getValue()).propagated, ((ExecutorConfig)entry.getValue()).maxAsync, ((ExecutorConfig)entry.getValue()).maxQueued)).done());
        }
        for (String string : unconfiguredExecutorIPs) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ManagedExecutor.class).defaultBean()).unremovable()).setRuntimeInit().scope(ApplicationScoped.class)).addQualifier().annotation(DotNames.NAMED_INSTANCE).addValue("value", (Object)string).done()).supplier(recorder.initializeConfiguredManagedExecutor(ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.cleared(), ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.propagated(), ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxAsync(), ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxQueued())).done());
        }
        for (Map.Entry entry : threadContextMap.entrySet()) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ThreadContext.class).defaultBean()).unremovable()).setRuntimeInit().scope(ApplicationScoped.class)).addQualifier().annotation(DotNames.NAMED_INSTANCE).addValue("value", entry.getKey()).done()).supplier(recorder.initializeConfiguredThreadContext(((ThreadConfig)entry.getValue()).cleared, ((ThreadConfig)entry.getValue()).propagated, ((ThreadConfig)entry.getValue()).unchanged)).done());
        }
        for (String string : unconfiguredContextIPs) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ThreadContext.class).defaultBean()).unremovable()).setRuntimeInit().scope(ApplicationScoped.class)).addQualifier().annotation(DotNames.NAMED_INSTANCE).addValue("value", (Object)string).done()).supplier(recorder.initializeConfiguredThreadContext(ThreadContextConfig.Literal.DEFAULT_INSTANCE.cleared(), ThreadContextConfig.Literal.DEFAULT_INSTANCE.propagated(), ThreadContextConfig.Literal.DEFAULT_INSTANCE.unchanged())).done());
        }
    }

    private Collection<AnnotationInstance> extractAnnotations(AnnotationTarget target) {
        switch (target.kind()) {
            case FIELD: {
                return target.asField().annotations();
            }
            case METHOD_PARAMETER: {
                return target.asMethodParameter().method().annotations();
            }
        }
        return Collections.EMPTY_SET;
    }

    class ThreadConfig {
        String[] cleared;
        String[] propagated;
        String[] unchanged;

        ThreadConfig(AnnotationValue cleared, AnnotationValue propagated, AnnotationValue unchanged) {
            this.cleared = cleared == null ? ThreadContextConfig.Literal.DEFAULT_INSTANCE.cleared() : cleared.asStringArray();
            this.propagated = propagated == null ? ThreadContextConfig.Literal.DEFAULT_INSTANCE.propagated() : propagated.asStringArray();
            this.unchanged = unchanged == null ? ThreadContextConfig.Literal.DEFAULT_INSTANCE.unchanged() : unchanged.asStringArray();
        }
    }

    class ExecutorConfig {
        String[] cleared;
        String[] propagated;
        int maxAsync;
        int maxQueued;

        ExecutorConfig(AnnotationValue cleared, AnnotationValue propagated, AnnotationValue maxAsync, AnnotationValue maxQueued) {
            this.cleared = cleared == null ? ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.cleared() : cleared.asStringArray();
            this.propagated = propagated == null ? ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.propagated() : propagated.asStringArray();
            this.maxAsync = maxAsync == null ? ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxAsync() : maxAsync.asInt();
            this.maxQueued = maxQueued == null ? ManagedExecutorConfig.Literal.DEFAULT_INSTANCE.maxQueued() : maxQueued.asInt();
        }
    }
}

