/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.context.runtime;

import io.quarkus.arc.DefaultBean;
import io.smallrye.context.SmallRyeManagedExecutor;
import io.smallrye.context.SmallRyeThreadContext;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.inject.Singleton;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;

@ApplicationScoped
public class SmallRyeContextPropagationProvider {
    private volatile SmallRyeManagedExecutor managedExecutor;

    void initialize(ExecutorService executorService) {
        this.managedExecutor = new SmallRyeManagedExecutor(-1, -1, (SmallRyeThreadContext)this.getAllThreadContext(), executorService, "no-ip"){

            public void shutdown() {
                throw new IllegalStateException("This executor is managed by the container and cannot be shut down.");
            }

            public List<Runnable> shutdownNow() {
                throw new IllegalStateException("This executor is managed by the container and cannot be shut down.");
            }
        };
    }

    @Produces
    @Singleton
    @DefaultBean
    public ThreadContext getAllThreadContext() {
        return ThreadContext.builder().propagated(new String[]{"Remaining"}).cleared(new String[0]).unchanged(new String[0]).build();
    }

    @Typed(value={ManagedExecutor.class})
    @Produces
    @Singleton
    @DefaultBean
    public ManagedExecutor getAllManagedExecutor() {
        return this.managedExecutor;
    }
}

