/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.deployment;

import com.netflix.hystrix.HystrixCircuitBreaker;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.QuarkusConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFallbackHandlerProvider;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFaultToleranceOperationProvider;
import io.quarkus.smallrye.faulttolerance.runtime.SmallryeFaultToleranceRecorder;
import io.smallrye.faulttolerance.DefaultCommandListenersProvider;
import io.smallrye.faulttolerance.DefaultHystrixConcurrencyStrategy;
import io.smallrye.faulttolerance.HystrixCommandBinding;
import io.smallrye.faulttolerance.HystrixCommandInterceptor;
import io.smallrye.faulttolerance.HystrixInitializer;
import io.smallrye.faulttolerance.metrics.MetricsCollectorFactory;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class SmallRyeFaultToleranceProcessor {
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    BuildProducer<NativeImageSystemPropertyBuildItem> nativeImageSystemProperty;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    NativeImageSystemPropertyBuildItem disableJmx() {
        return new NativeImageSystemPropertyBuildItem("archaius.dynamicPropertyFactory.registerConfigWithJMX", "false");
    }

    @BuildStep
    public void build(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<BeanDefiningAnnotationBuildItem> additionalBda) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("smallrye-fault-tolerance"));
        final HashSet<DotName> ftAnnotations = new HashSet<DotName>();
        ftAnnotations.add(DotName.createSimple((String)Asynchronous.class.getName()));
        ftAnnotations.add(DotName.createSimple((String)Bulkhead.class.getName()));
        ftAnnotations.add(DotName.createSimple((String)CircuitBreaker.class.getName()));
        ftAnnotations.add(DotName.createSimple((String)Fallback.class.getName()));
        ftAnnotations.add(DotName.createSimple((String)Retry.class.getName()));
        ftAnnotations.add(DotName.createSimple((String)Timeout.class.getName()));
        IndexView index = this.combinedIndexBuildItem.getIndex();
        this.nativeImageSystemProperty.produce((BuildItem)new NativeImageSystemPropertyBuildItem("rx.unsafe-disable", "true"));
        HashSet<String> fallbackHandlers = new HashSet<String>();
        for (Object implementor : index.getAllKnownImplementors(DotName.createSimple((String)FallbackHandler.class.getName()))) {
            fallbackHandlers.add(implementor.name().toString());
        }
        if (!fallbackHandlers.isEmpty()) {
            AdditionalBeanBuildItem.Builder fallbackHandlersBeans = AdditionalBeanBuildItem.builder().setDefaultScope(BuiltinScope.DEPENDENT.getName());
            for (String fallbackHandler : fallbackHandlers) {
                this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{fallbackHandler}));
                fallbackHandlersBeans.addBeanClass(fallbackHandler);
            }
            additionalBean.produce((BuildItem)fallbackHandlersBeans.build());
        }
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new String[]{HystrixCircuitBreaker.Factory.class.getName()}));
        for (DotName annotation : ftAnnotations) {
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{annotation.toString()}));
            additionalBda.produce((BuildItem)new BeanDefiningAnnotationBuildItem(annotation));
        }
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (ftAnnotations.contains(context.getTarget().asClass().name())) {
                    context.transform().add(HystrixCommandBinding.class, new AnnotationValue[0]).done();
                }
            }
        }));
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        for (DotName ftAnnotation : ftAnnotations) {
            builder.addBeanClass(ftAnnotation.toString());
        }
        builder.addBeanClasses(new Class[]{HystrixCommandInterceptor.class, HystrixInitializer.class, DefaultHystrixConcurrencyStrategy.class, QuarkusFaultToleranceOperationProvider.class, QuarkusFallbackHandlerProvider.class, DefaultCommandListenersProvider.class, MetricsCollectorFactory.class});
        additionalBean.produce((BuildItem)builder.build());
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformInterceptorPriority(BeanArchiveIndexBuildItem index) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (ctx.isClass()) {
                    if (!ctx.getTarget().asClass().name().toString().equals("io.smallrye.faulttolerance.HystrixCommandInterceptor")) {
                        return;
                    }
                    Integer priority = QuarkusConfig.getBoxedInt((String)"mp.fault.tolerance.interceptor.priority", null, (boolean)true);
                    if (priority != null) {
                        ctx.transform().remove(ann -> ann.name().toString().equals(Priority.class.getName())).add(Priority.class, new AnnotationValue[]{AnnotationValue.createIntegerValue((String)"value", (int)priority)}).done();
                    }
                }
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void validateFaultToleranceAnnotations(ValidationPhaseBuildItem validationPhase, SmallryeFaultToleranceRecorder recorder) {
        ArrayList<String> beanNames = new ArrayList<String>();
        for (BeanInfo bean : (List)validationPhase.getContext().get(BuildExtension.Key.BEANS)) {
            if (!bean.isClassBean()) continue;
            beanNames.add(bean.getBeanClass().toString());
        }
        recorder.validate(beanNames);
    }

    @BuildStep
    public ConfigurationTypeBuildItem registerTypes() {
        return new ConfigurationTypeBuildItem(ChronoUnit.class);
    }

    @BuildStep
    public void logCleanup(BuildProducer<LogCleanupFilterBuildItem> logCleanupFilter) {
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("io.smallrye.faulttolerance.HystrixInitializer", new String[]{"### Init Hystrix ###", "### Reset Hystrix ###", "Hystrix concurrency strategy used: DefaultHystrixConcurrencyStrategy"}));
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("io.smallrye.faulttolerance.DefaultHystrixConcurrencyStrategy", new String[]{"### Privilleged Thread Factory used ###"}));
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("com.netflix.config.sources.URLConfigurationSource", new String[]{"No URLs will be polled as dynamic configuration sources.", "To enable URLs as dynamic configuration sources"}));
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("com.netflix.config.DynamicPropertyFactory", new String[]{"DynamicPropertyFactory is initialized with configuration sources"}));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public void clearStatic(SmallryeFaultToleranceRecorder recorder, ShutdownContextBuildItem context, BeanContainerBuildItem beanContainer) {
        recorder.resetCommandContextOnUndeploy((ShutdownContext)context);
    }
}

