/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.smallrye.faulttolerance.runtime.NoopMetricRegistry;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFallbackHandlerProvider;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFaultToleranceOperationProvider;
import io.quarkus.smallrye.faulttolerance.runtime.SmallRyeFaultToleranceRecorder;
import io.smallrye.faulttolerance.ExecutorFactory;
import io.smallrye.faulttolerance.ExecutorProvider;
import io.smallrye.faulttolerance.FaultToleranceBinding;
import io.smallrye.faulttolerance.FaultToleranceInterceptor;
import io.smallrye.faulttolerance.internal.RequestContextControllerProvider;
import io.smallrye.faulttolerance.internal.StrategyCache;
import io.smallrye.faulttolerance.metrics.MetricsCollectorFactory;
import io.smallrye.faulttolerance.propagation.ContextPropagationExecutorFactory;
import io.smallrye.faulttolerance.propagation.ContextPropagationRequestContextControllerProvider;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class SmallRyeFaultToleranceProcessor {
    private static final Set<DotName> FT_ANNOTATIONS = new HashSet<DotName>();

    @BuildStep
    public void build(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<BeanDefiningAnnotationBuildItem> additionalBda, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperty, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageSystemPropertyBuildItem> nativeImageSystemProperty) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_FAULT_TOLERANCE));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(ExecutorFactory.class.getName(), new String[]{ContextPropagationExecutorFactory.class.getName()}));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(RequestContextControllerProvider.class.getName(), new String[]{ContextPropagationRequestContextControllerProvider.class.getName()}));
        IndexView index = combinedIndexBuildItem.getIndex();
        nativeImageSystemProperty.produce((BuildItem)new NativeImageSystemPropertyBuildItem("rx.unsafe-disable", "true"));
        HashSet<String> fallbackHandlers = new HashSet<String>();
        for (Object implementor : index.getAllKnownImplementors(DotName.createSimple((String)FallbackHandler.class.getName()))) {
            fallbackHandlers.add(implementor.name().toString());
        }
        if (!fallbackHandlers.isEmpty()) {
            AdditionalBeanBuildItem.Builder fallbackHandlersBeans = AdditionalBeanBuildItem.builder().setDefaultScope(BuiltinScope.DEPENDENT.getName());
            for (String fallbackHandler : fallbackHandlers) {
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{fallbackHandler}));
                fallbackHandlersBeans.addBeanClass(fallbackHandler);
            }
            additionalBean.produce((BuildItem)fallbackHandlersBeans.build());
        }
        for (DotName annotation : FT_ANNOTATIONS) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{annotation.toString()}));
            additionalBda.produce((BuildItem)new BeanDefiningAnnotationBuildItem(annotation));
        }
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (FT_ANNOTATIONS.contains(context.getTarget().asClass().name())) {
                    ((Transformation)context.transform().add(FaultToleranceBinding.class, new AnnotationValue[0])).done();
                }
            }
        }));
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        for (DotName ftAnnotation : FT_ANNOTATIONS) {
            builder.addBeanClass(ftAnnotation.toString());
        }
        builder.addBeanClasses(new Class[]{FaultToleranceInterceptor.class, ExecutorProvider.class, StrategyCache.class, QuarkusFaultToleranceOperationProvider.class, QuarkusFallbackHandlerProvider.class, MetricsCollectorFactory.class});
        additionalBean.produce((BuildItem)builder.build());
        if (!capabilities.isPresent(Capability.METRICS)) {
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(NoopMetricRegistry.class).setRemovable().setDefaultScope(DotName.createSimple((String)Singleton.class.getName())).build());
            systemProperty.produce((BuildItem)new SystemPropertyBuildItem("MP_Fault_Tolerance_Metrics_Enabled", "false"));
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformInterceptorPriority(BeanArchiveIndexBuildItem index) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (ctx.isClass()) {
                    if (!ctx.getTarget().asClass().name().toString().equals("io.smallrye.faulttolerance.FaultToleranceInterceptor")) {
                        return;
                    }
                    Config config = ConfigProvider.getConfig();
                    OptionalInt priority = (OptionalInt)config.getValue("mp.fault.tolerance.interceptor.priority", OptionalInt.class);
                    if (priority.isPresent()) {
                        ((Transformation)((Transformation)ctx.transform().remove(ann -> ann.name().toString().equals(Priority.class.getName()))).add(Priority.class, new AnnotationValue[]{AnnotationValue.createIntegerValue((String)"value", (int)priority.getAsInt())})).done();
                    }
                }
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void validateFaultToleranceAnnotations(SmallRyeFaultToleranceRecorder recorder, ValidationPhaseBuildItem validationPhase, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        HashSet<String> beanNames = new HashSet<String>();
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        for (BeanInfo info : validationPhase.getContext().beans()) {
            if (!this.hasFTAnnotations(index, annotationStore, info.getImplClazz())) continue;
            beanNames.add(info.getBeanClass().toString());
        }
        recorder.createFaultToleranceOperation(beanNames);
    }

    private boolean hasFTAnnotations(IndexView index, AnnotationStore annotationStore, ClassInfo info) {
        if (info == null) {
            return false;
        }
        if (annotationStore.hasAnyAnnotation((AnnotationTarget)info, FT_ANNOTATIONS)) {
            return true;
        }
        for (MethodInfo method : info.methods()) {
            if (!annotationStore.hasAnyAnnotation((AnnotationTarget)method, FT_ANNOTATIONS)) continue;
            return true;
        }
        DotName parentClassName = info.superName();
        if (parentClassName == null || parentClassName.equals((Object)DotNames.OBJECT)) {
            return false;
        }
        ClassInfo parentClassInfo = index.getClassByName(parentClassName);
        if (parentClassInfo == null) {
            return false;
        }
        return this.hasFTAnnotations(index, annotationStore, parentClassInfo);
    }

    @BuildStep
    public ConfigurationTypeBuildItem registerTypes() {
        return new ConfigurationTypeBuildItem(ChronoUnit.class);
    }

    static {
        FT_ANNOTATIONS.add(DotName.createSimple((String)Asynchronous.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)Bulkhead.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)CircuitBreaker.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)Fallback.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)Retry.class.getName()));
        FT_ANNOTATIONS.add(DotName.createSimple((String)Timeout.class.getName()));
    }
}

