/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.deployment;

import io.quarkus.arc.processor.AssignabilityCheck;
import io.quarkus.arc.processor.KotlinDotNames;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.VoidType;
import org.jboss.jandex.WildcardType;

final class FaultToleranceMethodSearch {
    private final IndexView index;
    private final AssignabilityCheck assignability;

    FaultToleranceMethodSearch(IndexView index) {
        this.index = index;
        this.assignability = new AssignabilityCheck(index, null);
    }

    MethodInfo findFallbackMethod(ClassInfo beanClass, ClassInfo declaringClass, String name, Type[] parameterTypes, Type returnType) {
        Set<MethodInfo> result = this.findMethod(beanClass, declaringClass, name, parameterTypes, returnType, false);
        return result.isEmpty() ? null : result.iterator().next();
    }

    Set<MethodInfo> findFallbackMethodsWithExceptionParameter(ClassInfo beanClass, ClassInfo declaringClass, String name, Type[] parameterTypes, Type returnType) {
        return this.findMethod(beanClass, declaringClass, name, parameterTypes, returnType, true);
    }

    MethodInfo findBeforeRetryMethod(ClassInfo beanClass, ClassInfo declaringClass, String name) {
        Set<MethodInfo> result = this.findMethod(beanClass, declaringClass, name, new Type[0], (Type)VoidType.VOID, false);
        return result.isEmpty() ? null : result.iterator().next();
    }

    private Set<MethodInfo> findMethod(ClassInfo beanClass, ClassInfo declaringClass, String name, Type[] expectedParameterTypes, Type expectedReturnType, boolean expectedExceptionParameter) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        TypeMapping expectedMapping = TypeMapping.createFor(beanClass, declaringClass, this.index);
        Set<String> declaredMethodNames = this.findDeclaredMethodNames(declaringClass);
        ArrayDeque<ClassWithTypeMapping> worklist = new ArrayDeque<ClassWithTypeMapping>();
        ClassInfo clazz = beanClass;
        TypeMapping typeMapping = new TypeMapping();
        worklist.add(new ClassWithTypeMapping(clazz, typeMapping));
        while (clazz.superName() != null) {
            ClassInfo superclass = this.index.getClassByName(clazz.superName());
            if (superclass == null) {
                throw new IllegalArgumentException("Class not in index: " + clazz.superName());
            }
            Type genericSuperclass = clazz.superClassType();
            typeMapping = typeMapping.getDirectSupertypeMapping(superclass, genericSuperclass);
            worklist.add(new ClassWithTypeMapping(superclass, typeMapping));
            clazz = superclass;
        }
        while (!worklist.isEmpty()) {
            ClassWithTypeMapping classWithTypeMapping = (ClassWithTypeMapping)worklist.removeFirst();
            ClassInfo clazz2 = classWithTypeMapping.clazz;
            TypeMapping actualMapping = classWithTypeMapping.typeMapping;
            Set<MethodInfo> methods = this.getMethodsFromClass(clazz2, name, expectedParameterTypes, expectedReturnType, expectedExceptionParameter, declaringClass, actualMapping, expectedMapping);
            for (MethodInfo method : methods) {
                if (!declaredMethodNames.contains(method.name())) continue;
                result.add(method);
                if (expectedExceptionParameter) continue;
                return result;
            }
            List interfaces = clazz2.interfaceNames();
            for (int i = 0; i < interfaces.size(); ++i) {
                ClassInfo iface = this.index.getClassByName((DotName)interfaces.get(i));
                if (iface == null) {
                    throw new IllegalArgumentException("Class not in index: " + interfaces.get(i));
                }
                Type genericIface = (Type)clazz2.interfaceTypes().get(i);
                worklist.add(new ClassWithTypeMapping(iface, actualMapping.getDirectSupertypeMapping(iface, genericIface)));
            }
        }
        return result;
    }

    private Set<String> findDeclaredMethodNames(ClassInfo declaringClass) {
        HashSet<String> result = new HashSet<String>();
        ArrayDeque<ClassInfo> worklist = new ArrayDeque<ClassInfo>();
        worklist.add(declaringClass);
        while (!worklist.isEmpty()) {
            ClassInfo superClass;
            ClassInfo clazz = (ClassInfo)worklist.removeFirst();
            for (MethodInfo m : clazz.methods()) {
                result.add(m.name());
            }
            if (clazz.superName() != null && (superClass = this.index.getClassByName(clazz.superName())) != null) {
                worklist.add(superClass);
            }
            for (DotName interfaceName : clazz.interfaceNames()) {
                ClassInfo iface = this.index.getClassByName(interfaceName);
                if (iface == null) continue;
                worklist.add(iface);
            }
        }
        return result;
    }

    private Set<MethodInfo> getMethodsFromClass(ClassInfo classToSearch, String name, Type[] parameterTypes, Type returnType, boolean exceptionParameter, ClassInfo guardedMethodDeclaringClass, TypeMapping actualMapping, TypeMapping expectedMapping) {
        HashSet<MethodInfo> set = new HashSet<MethodInfo>();
        for (MethodInfo method : classToSearch.methods()) {
            if (!method.name().equals(name) || !this.isAccessibleFrom(method, guardedMethodDeclaringClass) || !this.signaturesMatch(method, parameterTypes, returnType, exceptionParameter, actualMapping, expectedMapping)) continue;
            set.add(method);
        }
        return set;
    }

    private boolean isAccessibleFrom(MethodInfo method, ClassInfo guardedMethodDeclaringClass) {
        if (Modifier.isPublic(method.flags()) || Modifier.isProtected(method.flags())) {
            return true;
        }
        if (Modifier.isPrivate(method.flags())) {
            return method.declaringClass() == guardedMethodDeclaringClass;
        }
        return method.declaringClass().name().packagePrefixName().equals((Object)guardedMethodDeclaringClass.name().packagePrefixName());
    }

    private boolean signaturesMatch(MethodInfo method, Type[] expectedParameterTypes, Type expectedReturnType, boolean expectedExceptionParameter, TypeMapping actualMapping, TypeMapping expectedMapping) {
        List methodParams;
        int expectedParameters = expectedParameterTypes.length;
        if (expectedExceptionParameter) {
            boolean kotlinSuspendingFunction = FaultToleranceMethodSearch.isKotlinSuspendingFunction(expectedParameterTypes);
            expectedParameterTypes = Arrays.copyOfRange(expectedParameterTypes, 0, expectedParameters + 1);
            if (kotlinSuspendingFunction) {
                expectedParameterTypes[expectedParameters] = expectedParameterTypes[expectedParameters - 1];
                expectedParameterTypes[expectedParameters - 1] = null;
            }
            ++expectedParameters;
        }
        if (expectedParameters != (methodParams = method.parameterTypes()).size()) {
            return false;
        }
        for (int i = 0; i < expectedParameters; ++i) {
            boolean isThrowable;
            Type methodParam = (Type)methodParams.get(i);
            Type expectedParamType = expectedParameterTypes[i];
            if (expectedParamType != null) {
                if (this.typeMatches(methodParam, expectedParamType, actualMapping, expectedMapping)) continue;
                return false;
            }
            boolean bl = isThrowable = methodParam.kind() == Type.Kind.CLASS && this.assignability.isAssignableFrom((Type)ClassType.create(Throwable.class), methodParam);
            if (isThrowable) continue;
            return false;
        }
        return this.typeMatches(method.returnType(), expectedReturnType, actualMapping, expectedMapping);
    }

    private static boolean isKotlinSuspendingFunction(Type[] parameterTypes) {
        int params = parameterTypes.length;
        if (params > 0) {
            return parameterTypes[params - 1].name().equals((Object)KotlinDotNames.CONTINUATION);
        }
        return false;
    }

    private boolean typeMatches(Type actualType, Type expectedType, TypeMapping actualMapping, TypeMapping expectedMapping) {
        actualType = actualMapping.map(actualType);
        expectedType = expectedMapping.map(expectedType);
        if (actualType.kind() == Type.Kind.CLASS || actualType.kind() == Type.Kind.PRIMITIVE || actualType.kind() == Type.Kind.VOID) {
            return expectedType.equals((Object)actualType);
        }
        if (actualType.kind() == Type.Kind.ARRAY && expectedType.kind() == Type.Kind.ARRAY) {
            return this.typeMatches(actualType.asArrayType().componentType(), expectedType.asArrayType().componentType(), actualMapping, expectedMapping);
        }
        if (actualType.kind() == Type.Kind.PARAMETERIZED_TYPE && expectedType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return this.parameterizedTypeMatches(actualType.asParameterizedType(), expectedType.asParameterizedType(), actualMapping, expectedMapping);
        }
        if (actualType.kind() == Type.Kind.WILDCARD_TYPE && expectedType.kind() == Type.Kind.WILDCARD_TYPE) {
            return this.wildcardTypeMatches(actualType.asWildcardType(), expectedType.asWildcardType(), actualMapping, expectedMapping);
        }
        return false;
    }

    private boolean wildcardTypeMatches(WildcardType actualType, WildcardType expectedType, TypeMapping actualMapping, TypeMapping expectedMapping) {
        Type actualLowerBound = actualType.superBound();
        Type expectedLowerBound = expectedType.superBound();
        boolean lowerBoundsMatch = actualLowerBound == null && expectedLowerBound == null || actualLowerBound != null && expectedLowerBound != null && this.typeMatches(actualLowerBound, expectedLowerBound, actualMapping, expectedMapping);
        boolean upperBoundsMatch = this.typeMatches(actualType.extendsBound(), expectedType.extendsBound(), actualMapping, expectedMapping);
        return lowerBoundsMatch && upperBoundsMatch;
    }

    private boolean parameterizedTypeMatches(ParameterizedType actualType, ParameterizedType expectedType, TypeMapping actualMapping, TypeMapping expectedMapping) {
        boolean genericClassMatch = this.typeMatches((Type)ClassType.create((DotName)actualType.name()), (Type)ClassType.create((DotName)expectedType.name()), actualMapping, expectedMapping);
        boolean typeArgumentsMatch = this.typeListMatches(actualType.arguments(), expectedType.arguments(), actualMapping, expectedMapping);
        return genericClassMatch && typeArgumentsMatch;
    }

    private boolean typeListMatches(List<Type> actualTypes, List<Type> expectedTypes, TypeMapping actualMapping, TypeMapping expectedMapping) {
        if (actualTypes.size() != expectedTypes.size()) {
            return false;
        }
        for (int i = 0; i < actualTypes.size(); ++i) {
            if (this.typeMatches(actualTypes.get(i), expectedTypes.get(i), actualMapping, expectedMapping)) continue;
            return false;
        }
        return true;
    }

    private record TypeMapping(Map<Type, Type> map) {
        private TypeMapping() {
            this(Collections.emptyMap());
        }

        private static TypeMapping createFor(ClassInfo beanClass, ClassInfo declaringClass, IndexView index) {
            TypeMapping result = new TypeMapping();
            if (beanClass == declaringClass) {
                return result;
            }
            ClassInfo current = beanClass;
            while (current != declaringClass && current != null && current.superName() != null) {
                ClassInfo superClass = index.getClassByName(current.superName());
                if (superClass == null) {
                    throw new IllegalArgumentException("Class not in index: " + current.superName());
                }
                result = result.getDirectSupertypeMapping(superClass, current.superClassType());
                current = superClass;
            }
            return result;
        }

        private Type map(Type type) {
            Type result = this.map.get(type);
            return result != null ? result : type;
        }

        private TypeMapping getDirectSupertypeMapping(ClassInfo supertype, Type genericSupertype) {
            List typeParameters = supertype.typeParameters();
            List typeArguments = genericSupertype.kind() == Type.Kind.PARAMETERIZED_TYPE ? genericSupertype.asParameterizedType().arguments() : Collections.emptyList();
            HashMap<Type, Type> result = new HashMap<Type, Type>();
            for (int i = 0; i < typeArguments.size(); ++i) {
                Type typeArgument = (Type)typeArguments.get(i);
                if (typeArgument.kind() == Type.Kind.CLASS) {
                    result.put((Type)typeParameters.get(i), typeArgument);
                    continue;
                }
                Type type = this.map.get(typeArgument);
                result.put((Type)typeParameters.get(i), type != null ? type : typeArgument);
            }
            return new TypeMapping(result);
        }
    }

    private record ClassWithTypeMapping(ClassInfo clazz, TypeMapping typeMapping) {
    }
}

