/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.OpenTelemetrySdkBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.smallrye.faulttolerance.deployment.DotNames;
import io.quarkus.smallrye.faulttolerance.deployment.FaultToleranceScanner;
import io.quarkus.smallrye.faulttolerance.deployment.devui.FaultToleranceInfoBuildItem;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusAsyncExecutorProvider;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusBeforeRetryHandlerProvider;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusExistingCircuitBreakerNames;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFallbackHandlerProvider;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFaultToleranceOperationProvider;
import io.quarkus.smallrye.faulttolerance.runtime.SmallRyeFaultToleranceRecorder;
import io.quarkus.smallrye.faulttolerance.runtime.config.SmallRyeFaultToleranceConfigRelocate;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.faulttolerance.CdiSpi;
import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.Enablement;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.FaultToleranceBinding;
import io.smallrye.faulttolerance.FaultToleranceInterceptor;
import io.smallrye.faulttolerance.RequestContextIntegration;
import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.core.util.RunnableWrapper;
import io.smallrye.faulttolerance.internal.RequestContextControllerProvider;
import io.smallrye.faulttolerance.internal.StrategyCache;
import io.smallrye.faulttolerance.propagation.ContextPropagationRequestContextControllerProvider;
import io.smallrye.faulttolerance.propagation.ContextPropagationRunnableWrapper;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class SmallRyeFaultToleranceProcessor {
    /*
     * WARNING - void declaration
     */
    @BuildStep
    public void build(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<BeanDefiningAnnotationBuildItem> additionalBda, Optional<MetricsCapabilityBuildItem> metricsCapability, Optional<OpenTelemetrySdkBuildItem> openTelemetrySdk, BuildProducer<SystemPropertyBuildItem> systemProperty, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RunTimeConfigurationDefaultBuildItem> config, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems) {
        void var16_32;
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_FAULT_TOLERANCE));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(RequestContextControllerProvider.class.getName(), new String[]{ContextPropagationRequestContextControllerProvider.class.getName()}));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(RunnableWrapper.class.getName(), new String[]{ContextPropagationRunnableWrapper.class.getName()}));
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(ConfigSourceInterceptor.class.getName(), new String[]{SmallRyeFaultToleranceConfigRelocate.class.getName()}));
        runtimeInitializedClassBuildItems.produce((BuildItem)new RuntimeInitializedClassBuildItem(RunnableWrapper.class.getName()));
        IndexView index = combinedIndexBuildItem.getIndex();
        HashSet<String> handlers = new HashSet<String>();
        for (ClassInfo classInfo : index.getAllKnownImplementors(DotNames.FALLBACK_HANDLER)) {
            handlers.add(classInfo.name().toString());
        }
        for (ClassInfo classInfo : index.getAllKnownImplementors(DotNames.BEFORE_RETRY_HANDLER)) {
            handlers.add(classInfo.name().toString());
        }
        if (!handlers.isEmpty()) {
            AdditionalBeanBuildItem.Builder handlerBeans = AdditionalBeanBuildItem.builder().setDefaultScope(BuiltinScope.DEPENDENT.getName());
            for (String string : handlers) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{string}).methods().build());
                handlerBeans.addBeanClass(string);
            }
            beans.produce((BuildItem)handlerBeans.build());
        }
        for (ClassInfo classInfo : index.getAllKnownImplementors(DotNames.CUSTOM_BACKOFF_STRATEGY)) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{classInfo.name().toString()}).methods().build());
        }
        for (AnnotationInstance annotationInstance : index.getAnnotations(DotNames.RETRY_WHEN)) {
            for (String memberName : List.of("result", "exception")) {
                AnnotationValue member = annotationInstance.value(memberName);
                if (member == null) continue;
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{member.asClass().name().toString()}).build());
            }
        }
        for (DotName dotName : DotNames.FT_ANNOTATIONS) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{dotName.toString()}).methods().build());
            additionalBda.produce((BuildItem)new BeanDefiningAnnotationBuildItem(dotName));
        }
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (DotNames.FT_ANNOTATIONS.contains(context.getTarget().asClass().name())) {
                    context.transform().add(FaultToleranceBinding.class, new AnnotationValue[0]).done();
                }
            }
        }));
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        for (DotName dotName : DotNames.FT_ANNOTATIONS) {
            builder.addBeanClass(dotName.toString());
        }
        builder.addBeanClasses(new Class[]{ExecutorHolder.class, StrategyCache.class, QuarkusFallbackHandlerProvider.class, QuarkusBeforeRetryHandlerProvider.class, QuarkusAsyncExecutorProvider.class, CircuitBreakerMaintenanceImpl.class, RequestContextIntegration.class, SpecCompatibility.class, Enablement.class});
        boolean bl = false;
        if (metricsCapability.isPresent() && metricsCapability.get().metricsSupported("smallrye-metrics")) {
            void var16_29;
            builder.addBeanClass("io.smallrye.faulttolerance.metrics.MicroProfileMetricsProvider");
            ++var16_29;
        } else if (metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer")) {
            void var16_30;
            builder.addBeanClass("io.smallrye.faulttolerance.metrics.MicrometerProvider");
            ++var16_30;
        }
        if (openTelemetrySdk.map(OpenTelemetrySdkBuildItem::isMetricsBuildTimeEnabled).orElse(false).booleanValue()) {
            builder.addBeanClass("io.smallrye.faulttolerance.metrics.OpenTelemetryProvider");
            ++var16_32;
        }
        if (var16_32 == false) {
            builder.addBeanClass("io.smallrye.faulttolerance.metrics.NoopProvider");
        } else if (var16_32 > true) {
            builder.addBeanClass("io.smallrye.faulttolerance.metrics.CompoundMetricsProvider");
        }
        beans.produce((BuildItem)builder.build());
        beans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{FaultToleranceInterceptor.class, QuarkusFaultToleranceOperationProvider.class, QuarkusExistingCircuitBreakerNames.class, CdiSpi.EagerDependencies.class, CdiSpi.LazyDependencies.class}).build());
        config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("smallrye.faulttolerance.mp-compatibility", "false"));
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformInterceptorPriority(BeanArchiveIndexBuildItem index) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (ctx.isClass()) {
                    if (!ctx.getTarget().asClass().name().equals((Object)DotNames.FAULT_TOLERANCE_INTERCEPTOR)) {
                        return;
                    }
                    Config config = ConfigProvider.getConfig();
                    OptionalInt priority = (OptionalInt)config.getValue("mp.fault.tolerance.interceptor.priority", OptionalInt.class);
                    if (priority.isPresent()) {
                        ctx.transform().remove(ann -> ann.name().toString().equals(Priority.class.getName())).add(Priority.class, new AnnotationValue[]{AnnotationValue.createIntegerValue((String)"value", (int)priority.getAsInt())}).done();
                    }
                }
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void processFaultToleranceAnnotations(SmallRyeFaultToleranceRecorder recorder, RecorderContext recorderContext, ValidationPhaseBuildItem validationPhase, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, AnnotationProxyBuildItem annotationProxy, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethod, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors, BuildProducer<FaultToleranceInfoBuildItem> faultToleranceInfo) {
        Config config = ConfigProvider.getConfig();
        Set<String> exceptionConfigs = Set.of("CircuitBreaker/failOn", "CircuitBreaker/skipOn", "Fallback/applyOn", "Fallback/skipOn", "Retry/retryOn", "Retry/abortOn");
        for (String exceptionConfig : exceptionConfigs) {
            Optional exceptionNames = config.getOptionalValue(exceptionConfig, String[].class);
            if (!exceptionNames.isPresent()) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])exceptionNames.get())).reason(this.getClass().getName()).build());
        }
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, false);
        FaultToleranceScanner scanner = new FaultToleranceScanner(index, annotationStore, annotationProxy, (ClassOutput)classOutput, recorderContext, reflectiveMethod);
        ArrayList ftMethods = new ArrayList();
        ArrayList<DefinitionException> exceptions = new ArrayList<DefinitionException>();
        HashMap existingCircuitBreakerNames = new HashMap();
        HashMap existingGuards = new HashMap();
        HashSet<String> expectedGuards = new HashSet<String>();
        for (BeanInfo info : validationPhase.getContext().beans()) {
            ClassInfo beanClass;
            if (info.hasType(DotNames.GUARD) || info.hasType(DotNames.TYPED_GUARD)) {
                info.getQualifier(DotNames.IDENTIFIER).ifPresent(idAnn -> {
                    String id = idAnn.value().asString();
                    existingGuards.computeIfAbsent(id, ignored -> new HashSet()).add(info.toString());
                    if ("global".equals(id)) {
                        exceptions.add(new DefinitionException("Guard/TypedGuard with identifier 'global' is not allowed: " + String.valueOf(info)));
                    }
                });
            }
            if ((beanClass = info.getImplClazz()) == null || !scanner.hasFTAnnotations(beanClass)) continue;
            for (String exceptionConfig : exceptionConfigs) {
                Optional exceptionNames = config.getOptionalValue(beanClass.name().toString() + "/" + exceptionConfig, String[].class);
                if (!exceptionNames.isPresent()) continue;
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])exceptionNames.get())).reason(this.getClass().getName()).build());
            }
            scanner.forEachMethod(beanClass, method -> {
                FaultToleranceMethod ftMethod = scanner.createFaultToleranceMethod(beanClass, (MethodInfo)method);
                if (ftMethod.isLegitimate()) {
                    ftMethods.add(ftMethod);
                    reflectiveMethod.produce((BuildItem)new ReflectiveMethodBuildItem("fault tolerance method", method));
                    if (annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.ASYNCHRONOUS) && annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.ASYNCHRONOUS_NON_BLOCKING)) {
                        exceptions.add(new DefinitionException("Both @Asynchronous and @AsynchronousNonBlocking present on '" + String.valueOf(method) + "'"));
                    }
                    if (annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.BLOCKING) && annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.NON_BLOCKING)) {
                        exceptions.add(new DefinitionException("Both @Blocking and @NonBlocking present on '" + String.valueOf(method) + "'"));
                    }
                    for (String exceptionConfig : exceptionConfigs) {
                        Optional exceptionNames = config.getOptionalValue(beanClass.name().toString() + "/" + method.name() + "/" + exceptionConfig, String[].class);
                        if (!exceptionNames.isPresent()) continue;
                        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])exceptionNames.get())).reason(this.getClass().getName()).build());
                    }
                    if (annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.CIRCUIT_BREAKER_NAME)) {
                        AnnotationInstance ann = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.CIRCUIT_BREAKER_NAME);
                        existingCircuitBreakerNames.computeIfAbsent(ann.value().asString(), ignored -> new HashSet()).add(String.valueOf(method) + " @ " + String.valueOf(method.declaringClass()));
                    }
                    if (annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.APPLY_GUARD)) {
                        expectedGuards.add(annotationStore.getAnnotation((AnnotationTarget)method, DotNames.APPLY_GUARD).value().asString());
                    }
                }
            });
            if (annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.ASYNCHRONOUS) && annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.ASYNCHRONOUS_NON_BLOCKING)) {
                exceptions.add(new DefinitionException("Both @Asynchronous and @AsynchronousNonBlocking present on '" + String.valueOf(beanClass) + "'"));
            }
            if (annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.BLOCKING) && annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.NON_BLOCKING)) {
                exceptions.add(new DefinitionException("Both @Blocking and @NonBlocking present on '" + String.valueOf(beanClass) + "'"));
            }
            if (!annotationStore.hasAnnotation((AnnotationTarget)beanClass, DotNames.APPLY_GUARD)) continue;
            expectedGuards.add(annotationStore.getAnnotation((AnnotationTarget)beanClass, DotNames.APPLY_GUARD).value().asString());
        }
        recorder.createFaultToleranceOperation(ftMethods);
        for (Map.Entry entry : existingCircuitBreakerNames.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            exceptions.add(new DefinitionException("Multiple circuit breakers have the same name '" + (String)entry.getKey() + "': " + String.valueOf(entry.getValue())));
        }
        for (DotName backoffAnnotation : DotNames.BACKOFF_ANNOTATIONS) {
            for (AnnotationInstance it : index.getAnnotations(backoffAnnotation)) {
                if (annotationStore.hasAnnotation(it.target(), DotNames.RETRY)) continue;
                exceptions.add(new DefinitionException("Backoff annotation @" + backoffAnnotation.withoutPackagePrefix() + " present on '" + String.valueOf(it.target()) + "', but @Retry is missing"));
            }
        }
        for (AnnotationInstance it : index.getAnnotations(DotNames.RETRY_WHEN)) {
            if (annotationStore.hasAnnotation(it.target(), DotNames.RETRY)) continue;
            exceptions.add(new DefinitionException("@RetryWhen present on '" + String.valueOf(it.target()) + "', but @Retry is missing"));
        }
        for (AnnotationInstance it : index.getAnnotations(DotNames.BEFORE_RETRY)) {
            if (annotationStore.hasAnnotation(it.target(), DotNames.RETRY)) continue;
            exceptions.add(new DefinitionException("@BeforeRetry present on '" + String.valueOf(it.target()) + "', but @Retry is missing"));
        }
        for (Map.Entry entry : existingGuards.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            exceptions.add(new DefinitionException("Multiple Guard/TypedGuard beans have the same identifier '" + (String)entry.getKey() + "': " + String.valueOf(entry.getValue())));
        }
        for (String expectedGuard : expectedGuards) {
            if (existingGuards.containsKey(expectedGuard)) continue;
            exceptions.add(new DefinitionException("Guard/TypedGuard with identifier '" + expectedGuard + "' expected, but does not exist"));
        }
        if (!exceptions.isEmpty()) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(exceptions));
        }
        recorder.initExistingCircuitBreakerNames(existingCircuitBreakerNames.keySet());
        faultToleranceInfo.produce((BuildItem)new FaultToleranceInfoBuildItem(ftMethods.size()));
    }

    @BuildStep
    public ConfigurationTypeBuildItem registerTypes() {
        return new ConfigurationTypeBuildItem(ChronoUnit.class);
    }
}

