/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.deployment;

import com.netflix.hystrix.HystrixCircuitBreaker;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateSystemPropertyBuildItem;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFallbackHandlerProvider;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFaultToleranceOperationProvider;
import io.smallrye.faulttolerance.DefaultCommandListenersProvider;
import io.smallrye.faulttolerance.DefaultHystrixConcurrencyStrategy;
import io.smallrye.faulttolerance.HystrixCommandBinding;
import io.smallrye.faulttolerance.HystrixCommandInterceptor;
import io.smallrye.faulttolerance.HystrixInitializer;
import io.smallrye.faulttolerance.MetricsCollectorFactory;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.jboss.builder.item.BuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class SmallRyeFaultToleranceProcessor {
    private static final DotName[] FT_ANNOTATIONS = new DotName[]{DotName.createSimple((String)Asynchronous.class.getName()), DotName.createSimple((String)Bulkhead.class.getName()), DotName.createSimple((String)CircuitBreaker.class.getName()), DotName.createSimple((String)Fallback.class.getName()), DotName.createSimple((String)Retry.class.getName()), DotName.createSimple((String)Timeout.class.getName())};
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    @Inject
    BuildProducer<SubstrateSystemPropertyBuildItem> nativeImageSystemProperty;
    @Inject
    BuildProducer<AdditionalBeanBuildItem> additionalBean;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;

    SubstrateSystemPropertyBuildItem disableJmx() {
        return new SubstrateSystemPropertyBuildItem("archaius.dynamicPropertyFactory.registerConfigWithJMX", "false");
    }

    @BuildStep
    public void build(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, BuildProducer<FeatureBuildItem> feature) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("smallrye-fault-tolerance"));
        IndexView index = this.combinedIndexBuildItem.getIndex();
        this.nativeImageSystemProperty.produce((BuildItem)new SubstrateSystemPropertyBuildItem("rx.unsafe-disable", "true"));
        Collection fallbackHandlers = index.getAllKnownImplementors(DotName.createSimple((String)FallbackHandler.class.getName()));
        for (ClassInfo fallbackHandler : fallbackHandlers) {
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{fallbackHandler.name().toString()}));
        }
        this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, true, new String[]{HystrixCircuitBreaker.Factory.class.getName()}));
        for (DotName annotation : FT_ANNOTATIONS) {
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{annotation.toString()}));
        }
        final HashSet<String> ftClasses = new HashSet<String>();
        for (DotName annotation : FT_ANNOTATIONS) {
            Collection annotationInstances = index.getAnnotations(annotation);
            for (AnnotationInstance instance : annotationInstances) {
                if (instance.target().kind() == AnnotationTarget.Kind.CLASS) {
                    ftClasses.add(instance.target().asClass().toString());
                    continue;
                }
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                ftClasses.add(instance.target().asMethod().declaringClass().toString());
            }
        }
        if (!ftClasses.isEmpty()) {
            annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return kind == AnnotationTarget.Kind.CLASS;
                }

                public void transform(AnnotationsTransformer.TransformationContext context) {
                    if (ftClasses.contains(context.getTarget().asClass().name().toString())) {
                        context.transform().add(HystrixCommandBinding.class, new AnnotationValue[0]).done();
                    }
                }
            }));
        }
        this.additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{HystrixCommandInterceptor.class, HystrixInitializer.class, DefaultHystrixConcurrencyStrategy.class, QuarkusFaultToleranceOperationProvider.class, QuarkusFallbackHandlerProvider.class, DefaultCommandListenersProvider.class, MetricsCollectorFactory.class}));
    }
}

