/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.runtime;

import io.smallrye.faulttolerance.FallbackHandlerProvider;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.lang.annotation.Annotation;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

@Dependent
@Alternative
@Priority(value=1)
public class QuarkusFallbackHandlerProvider
implements FallbackHandlerProvider {
    @Inject
    @Any
    Instance<Object> instance;

    public <T> FallbackHandler<T> get(final FaultToleranceOperation operation) {
        if (operation.hasFallback()) {
            return new FallbackHandler<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T handle(ExecutionContext context) {
                    Class clazz = (Class)operation.getFallback().get("value");
                    FallbackHandler fallbackHandlerInstance = (FallbackHandler)QuarkusFallbackHandlerProvider.this.instance.select(clazz, new Annotation[0]).get();
                    try {
                        Object object = fallbackHandlerInstance.handle(context);
                        return object;
                    }
                    finally {
                        QuarkusFallbackHandlerProvider.this.instance.destroy((Object)fallbackHandlerInstance);
                    }
                }
            };
        }
        return null;
    }
}

