/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@Recorder
public class SmallryeFaultToleranceRecorder {
    public void validate(List<String> beanNames) {
        ArrayList<FaultToleranceDefinitionException> allExceptions = new ArrayList<FaultToleranceDefinitionException>();
        for (String beanName : beanNames) {
            try {
                Object classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = SmallryeFaultToleranceRecorder.class.getClassLoader();
                }
                Class<?> clazz = Class.forName(beanName, true, (ClassLoader)classLoader);
                for (Method method : this.getMethodsForValidation(clazz)) {
                    FaultToleranceOperation operation = FaultToleranceOperation.of(clazz, (Method)method);
                    if (!operation.isLegitimate()) continue;
                    try {
                        operation.validate();
                    }
                    catch (FaultToleranceDefinitionException e) {
                        allExceptions.add(e);
                    }
                }
            }
            catch (ClassNotFoundException classLoader) {
            }
        }
        if (!allExceptions.isEmpty()) {
            if (allExceptions.size() == 1) {
                Throwable error = (Throwable)allExceptions.get(0);
                if (error instanceof DeploymentException) {
                    throw (DeploymentException)error;
                }
                throw new DeploymentException((Throwable)allExceptions.get(0));
            }
            StringBuilder message = new StringBuilder("Found " + allExceptions.size() + " deployment problems: ");
            int idx = 1;
            for (Throwable throwable : allExceptions) {
                message.append("\n").append("[").append(idx++).append("] ").append(throwable.getMessage());
            }
            DeploymentException deploymentException = new DeploymentException(message.toString());
            for (Throwable throwable : allExceptions) {
                deploymentException.addSuppressed(throwable);
            }
            throw deploymentException;
        }
    }

    private Set<Method> getMethodsForValidation(Class<?> beanClass) {
        HashSet<Method> allMethods = new HashSet<Method>();
        Class<?> currentClass = beanClass;
        while (!currentClass.equals(Object.class)) {
            for (Method m : currentClass.getDeclaredMethods()) {
                allMethods.add(m);
            }
            currentClass = currentClass.getSuperclass();
        }
        return allMethods;
    }
}

