/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFaultToleranceOperationProvider;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@Recorder
public class SmallRyeFaultToleranceRecorder {
    public void createFaultToleranceOperation(Set<String> beanNames) {
        ArrayList<FaultToleranceDefinitionException> allExceptions = new ArrayList<FaultToleranceDefinitionException>();
        HashMap<QuarkusFaultToleranceOperationProvider.CacheKey, FaultToleranceOperation> operationCache = new HashMap<QuarkusFaultToleranceOperationProvider.CacheKey, FaultToleranceOperation>(beanNames.size());
        for (String beanName : beanNames) {
            try {
                Object classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = SmallRyeFaultToleranceRecorder.class.getClassLoader();
                }
                Class<?> clazz = Class.forName(beanName, true, (ClassLoader)classLoader);
                for (Method method : this.getAllMethods(clazz)) {
                    FaultToleranceOperation operation = FaultToleranceOperation.of(clazz, (Method)method);
                    if (!operation.isLegitimate()) continue;
                    try {
                        operation.validate();
                        QuarkusFaultToleranceOperationProvider.CacheKey cacheKey = new QuarkusFaultToleranceOperationProvider.CacheKey(clazz, method);
                        operationCache.put(cacheKey, operation);
                    }
                    catch (FaultToleranceDefinitionException e) {
                        allExceptions.add(e);
                    }
                }
            }
            catch (ClassNotFoundException classLoader) {
            }
        }
        if (!allExceptions.isEmpty()) {
            if (allExceptions.size() == 1) {
                Throwable error = (Throwable)allExceptions.get(0);
                if (error instanceof DeploymentException) {
                    throw (DeploymentException)error;
                }
                throw new DeploymentException((Throwable)allExceptions.get(0));
            }
            StringBuilder message = new StringBuilder("Found " + allExceptions.size() + " deployment problems: ");
            int idx = 1;
            for (Throwable throwable : allExceptions) {
                message.append("\n").append("[").append(idx++).append("] ").append(throwable.getMessage());
            }
            DeploymentException deploymentException = new DeploymentException(message.toString());
            for (Throwable throwable : allExceptions) {
                deploymentException.addSuppressed(throwable);
            }
            throw deploymentException;
        }
        ((QuarkusFaultToleranceOperationProvider)Arc.container().instance(QuarkusFaultToleranceOperationProvider.class, new Annotation[0]).get()).init(operationCache);
    }

    private Set<Method> getAllMethods(Class<?> beanClass) {
        HashSet<Method> allMethods = new HashSet<Method>();
        for (Class<?> currentClass = beanClass; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            for (Method m : currentClass.getDeclaredMethods()) {
                allMethods.add(m);
            }
        }
        return allMethods;
    }
}

