/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientConfigurationMergerBean;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientSupport;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientsConfig;
import io.quarkus.smallrye.graphql.client.runtime.SmallRyeGraphQLClientRecorder;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class SmallRyeGraphQLClientProcessor {
    private static final DotName GRAPHQL_CLIENT_API = DotName.createSimple((String)"io.smallrye.graphql.client.typesafe.api.GraphQLClientApi");
    private static final DotName GRAPHQL_CLIENT = DotName.createSimple((String)"io.smallrye.graphql.client.GraphQLClient");
    private static final String NAMED_DYNAMIC_CLIENTS = "io.smallrye.graphql.client.dynamic.cdi.NamedDynamicClients";

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> featureProducer) {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_GRAPHQL_CLIENT));
    }

    @BuildStep
    void setupServiceProviders(BuildProducer<ServiceProviderBuildItem> services) {
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.typesafe.api.TypesafeGraphQLClientBuilder"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Argument"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Document"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Enum"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Field"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.InputObject"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.InputObjectField"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Operation"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Variable"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.VariableType"));
    }

    @BuildStep
    void dynamicClientInjection(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<AutoInjectAnnotationBuildItem> autoInject) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{NAMED_DYNAMIC_CLIENTS}));
        autoInject.produce((BuildItem)new AutoInjectAnnotationBuildItem(new DotName[]{GRAPHQL_CLIENT}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initializeTypesafeClient(BeanArchiveIndexBuildItem index, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SmallRyeGraphQLClientRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies) throws ClassNotFoundException {
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(GRAPHQL_CLIENT_API)) {
            ClassInfo apiClassInfo = annotation.target().asClass();
            Class<?> apiClass = Class.forName(apiClassInfo.name().toString(), true, Thread.currentThread().getContextClassLoader());
            proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{apiClass.getName()}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{apiClassInfo.name().toString()}));
            for (MethodInfo method : apiClassInfo.methods()) {
                reflectiveHierarchies.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.returnType()).build());
                for (Type parameter : method.parameters()) {
                    reflectiveHierarchies.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(parameter).build());
                }
            }
            SyntheticBeanBuildItem bean = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)apiClassInfo.name()).addType(apiClassInfo.name())).scope(Singleton.class)).supplier(recorder.typesafeClientSupplier(apiClass)).unremovable()).done();
            syntheticBeans.produce((BuildItem)bean);
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"java.net.URI"}).methods(true).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"java.util.List"}).methods(true).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"java.util.Collection"}).methods(true).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setTypesafeApiClasses(BeanArchiveIndexBuildItem index, BeanContainerBuildItem beanContainerBuildItem, SmallRyeGraphQLClientRecorder recorder) {
        ArrayList<String> apiClassNames = new ArrayList<String>();
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(GRAPHQL_CLIENT_API)) {
            ClassInfo apiClassInfo = annotation.target().asClass();
            apiClassNames.add(apiClassInfo.name().toString());
        }
        recorder.setTypesafeApiClasses(apiClassNames);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void shortNamesToQualifiedNames(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SmallRyeGraphQLClientRecorder recorder, GraphQLClientsConfig quarkusConfig, BeanArchiveIndexBuildItem index) {
        HashMap<String, String> shortNamesToQualifiedNames = new HashMap<String, String>();
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(GRAPHQL_CLIENT_API)) {
            ClassInfo clazz = annotation.target().asClass();
            shortNamesToQualifiedNames.put(clazz.name().withoutPackagePrefix(), clazz.name().toString());
        }
        RuntimeValue support = recorder.clientSupport(shortNamesToQualifiedNames);
        DotName supportClassName = DotName.createSimple((String)GraphQLClientSupport.class.getName());
        SyntheticBeanBuildItem bean = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)supportClassName).addType(supportClassName)).scope(Singleton.class)).runtimeValue(support).setRuntimeInit().unremovable()).done();
        syntheticBeans.produce((BuildItem)bean);
    }

    @BuildStep
    AdditionalBeanBuildItem configurationMergerBean() {
        return AdditionalBeanBuildItem.unremovableOf(GraphQLClientConfigurationMergerBean.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void initializeConfigMergerBean(BeanContainerBuildItem containerBuildItem, SmallRyeGraphQLClientRecorder recorder) {
        recorder.initializeConfigurationMergerBean();
    }

    @BuildStep
    ServiceProviderBuildItem overrideErrorMessageProvider() {
        return ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.ErrorMessageProvider");
    }
}

