/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.smallrye.graphql.client.deployment.GraphQLClientConfigInitializedBuildItem;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientBuildConfig;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientSupport;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientsConfig;
import io.quarkus.smallrye.graphql.client.runtime.SmallRyeGraphQLClientRecorder;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.smallrye.graphql.client.model.ClientModelBuilder;
import io.smallrye.graphql.client.model.ClientModels;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.microprofile.graphql.Input;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class SmallRyeGraphQLClientProcessor {
    private static final DotName GRAPHQL_CLIENT_API = DotName.createSimple((String)"io.smallrye.graphql.client.typesafe.api.GraphQLClientApi");
    private static final DotName GRAPHQL_CLIENT = DotName.createSimple((String)"io.smallrye.graphql.client.GraphQLClient");
    private static final String NAMED_DYNAMIC_CLIENTS = "io.smallrye.graphql.client.impl.dynamic.cdi.NamedDynamicClients";

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> featureProducer) {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_GRAPHQL_CLIENT));
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.SMALLRYE_GRAPHQL_CLIENT);
    }

    @BuildStep
    void setupServiceProviders(BuildProducer<ServiceProviderBuildItem> services) {
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.typesafe.api.TypesafeGraphQLClientBuilder"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Argument"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Directive"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.DirectiveArgument"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Document"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Enum"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Field"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Fragment"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.FragmentReference"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.InlineFragment"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.InputObject"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.InputObjectField"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Operation"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.Variable"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.core.VariableType"));
    }

    @BuildStep
    void dynamicClientInjection(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<AutoInjectAnnotationBuildItem> autoInject) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{NAMED_DYNAMIC_CLIENTS}));
        autoInject.produce((BuildItem)new AutoInjectAnnotationBuildItem(new DotName[]{GRAPHQL_CLIENT}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initializeTypesafeClient(BeanArchiveIndexBuildItem index, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SmallRyeGraphQLClientRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies, BuildProducer<NativeImageProxyDefinitionBuildItem> proxies) throws ClassNotFoundException {
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(GRAPHQL_CLIENT_API)) {
            ClassInfo apiClassInfo = annotation.target().asClass();
            Class<?> apiClass = Class.forName(apiClassInfo.name().toString(), true, Thread.currentThread().getContextClassLoader());
            proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{apiClass.getName()}));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{apiClassInfo.name().toString()}).build());
            for (MethodInfo method : apiClassInfo.methods()) {
                reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)method.returnType()).build());
                for (Type parameter : method.parameterTypes()) {
                    reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)parameter).build());
                }
            }
            SyntheticBeanBuildItem bean = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)apiClassInfo.name()).addType(apiClassInfo.name())).scope(ApplicationScoped.class)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(ClientModels.class)), new AnnotationInstance[0])).createWith(recorder.typesafeClientSupplier(apiClass)).unremovable()).done();
            syntheticBeans.produce((BuildItem)bean);
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"java.net.URI"}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"java.util.List"}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"java.util.Collection"}).methods().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setTypesafeApiClasses(BeanArchiveIndexBuildItem index, BeanContainerBuildItem beanContainerBuildItem, SmallRyeGraphQLClientRecorder recorder) {
        ArrayList<String> apiClassNames = new ArrayList<String>();
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(GRAPHQL_CLIENT_API)) {
            ClassInfo apiClassInfo = annotation.target().asClass();
            apiClassNames.add(apiClassInfo.name().toString());
        }
        recorder.setTypesafeApiClasses(apiClassNames);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    GraphQLClientConfigInitializedBuildItem mergeClientConfigurations(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SmallRyeGraphQLClientRecorder recorder, GraphQLClientsConfig quarkusConfig, BeanArchiveIndexBuildItem index) {
        ArrayList<String> knownConfigKeys = new ArrayList<String>();
        HashMap<String, String> shortNamesToQualifiedNames = new HashMap<String, String>();
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(GRAPHQL_CLIENT_API)) {
            ClassInfo clazz = annotation.target().asClass();
            shortNamesToQualifiedNames.put(clazz.name().withoutPackagePrefix(), clazz.name().toString());
            AnnotationValue configKeyValue = annotation.value("configKey");
            String configKey = configKeyValue != null ? configKeyValue.asString() : null;
            String actualConfigKey = configKey != null && !configKey.equals("") ? configKey : clazz.name().toString();
            knownConfigKeys.add(actualConfigKey);
        }
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(GRAPHQL_CLIENT)) {
            String configKey = annotation.value().asString();
            if (configKey == null) {
                configKey = "default";
            }
            knownConfigKeys.add(configKey);
        }
        GraphQLClientSupport support = new GraphQLClientSupport();
        support.setShortNamesToQualifiedNamesMapping(shortNamesToQualifiedNames);
        support.setKnownConfigKeys(knownConfigKeys);
        recorder.mergeClientConfigurations(support, quarkusConfig);
        return new GraphQLClientConfigInitializedBuildItem();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void buildClientModel(CombinedIndexBuildItem index, SmallRyeGraphQLClientRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, GraphQLClientBuildConfig quarkusConfig) {
        if (!index.getIndex().getAnnotations(GRAPHQL_CLIENT_API).isEmpty()) {
            ClientModels clientModels = quarkusConfig.enableBuildTimeScanning ? ClientModelBuilder.build((IndexView)index.getIndex()) : new ClientModels();
            RuntimeValue modelRuntimeClientModel = recorder.getRuntimeClientModel(clientModels);
            DotName supportClassName = DotName.createSimple((String)ClientModels.class.getName());
            SyntheticBeanBuildItem bean = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)supportClassName).addType(supportClassName)).scope(Singleton.class)).runtimeValue(modelRuntimeClientModel).setRuntimeInit().unremovable()).done();
            syntheticBeans.produce((BuildItem)bean);
        }
    }

    @BuildStep
    ServiceProviderBuildItem overrideErrorMessageProvider() {
        return ServiceProviderBuildItem.allProvidersFromClassPath((String)"io.smallrye.graphql.client.impl.ErrorMessageProvider");
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setGlobalVertxInstance(CoreVertxBuildItem vertxBuildItem, SmallRyeGraphQLClientRecorder recorder) {
        recorder.setGlobalVertxInstance(vertxBuildItem.getVertx());
    }

    @BuildStep
    void setAdditionalClassesToIndex(BuildProducer<AdditionalIndexedClassesBuildItem> additionalClassesToIndex, GraphQLClientBuildConfig quarkusConfig) {
        if (quarkusConfig.enableBuildTimeScanning) {
            additionalClassesToIndex.produce((BuildItem)new AdditionalIndexedClassesBuildItem(Closeable.class.getName()));
            additionalClassesToIndex.produce((BuildItem)new AdditionalIndexedClassesBuildItem(AutoCloseable.class.getName()));
            additionalClassesToIndex.produce((BuildItem)new AdditionalIndexedClassesBuildItem(Input.class.getName()));
        }
    }
}

