/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.client.runtime;

import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientConfig;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientSupport;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientsConfig;
import io.smallrye.graphql.client.GraphQLClientConfiguration;
import io.smallrye.graphql.client.GraphQLClientsConfiguration;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GraphQLClientConfigurationMergerBean {
    @Inject
    GraphQLClientsConfiguration upstreamConfiguration;
    @Inject
    GraphQLClientsConfig quarkusConfiguration;
    @Inject
    GraphQLClientSupport support;

    @PostConstruct
    void enhanceGraphQLConfiguration() {
        for (Map.Entry<String, GraphQLClientConfig> client : this.quarkusConfiguration.clients.entrySet()) {
            String rawConfigKey = client.getKey();
            Map<String, String> shortNamesToQualifiedNamesMapping = this.support.getShortNamesToQualifiedNamesMapping();
            String configKey = shortNamesToQualifiedNamesMapping != null && shortNamesToQualifiedNamesMapping.containsKey(rawConfigKey) ? shortNamesToQualifiedNamesMapping.get(rawConfigKey) : rawConfigKey;
            GraphQLClientConfig quarkusConfig = client.getValue();
            if (!this.upstreamConfiguration.getClients().containsKey(configKey)) {
                GraphQLClientConfiguration transformed = new GraphQLClientConfiguration();
                transformed.setHeaders(quarkusConfig.headers);
                quarkusConfig.url.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setUrl(arg_0));
                this.upstreamConfiguration.getClients().put(configKey, transformed);
                continue;
            }
            GraphQLClientConfiguration upstreamConfig = (GraphQLClientConfiguration)this.upstreamConfiguration.getClients().get(configKey);
            quarkusConfig.url.ifPresent(arg_0 -> ((GraphQLClientConfiguration)upstreamConfig).setUrl(arg_0));
            if (quarkusConfig.headers == null) continue;
            upstreamConfig.getHeaders().putAll(quarkusConfig.headers);
        }
    }

    public void nothing() {
    }
}

