/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientConfigurationMergerBean;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientSupport;
import io.smallrye.graphql.client.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.typesafe.api.TypesafeGraphQLClientBuilder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Recorder
public class SmallRyeGraphQLClientRecorder {
    public <T> Supplier<T> typesafeClientSupplier(Class<T> targetClassName) {
        return () -> {
            TypesafeGraphQLClientBuilder builder = TypesafeGraphQLClientBuilder.newBuilder();
            return builder.build(targetClassName);
        };
    }

    public void setTypesafeApiClasses(List<String> apiClassNames) {
        GraphQLClientsConfiguration configBean = (GraphQLClientsConfiguration)Arc.container().instance(GraphQLClientsConfiguration.class, new Annotation[0]).get();
        List classes = apiClassNames.stream().map(className -> {
            try {
                return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        GraphQLClientsConfiguration.apiClasses(classes, (boolean)true);
    }

    public RuntimeValue<GraphQLClientSupport> clientSupport(Map<String, String> shortNamesToQualifiedNames) {
        GraphQLClientSupport support = new GraphQLClientSupport();
        support.setShortNamesToQualifiedNamesMapping(shortNamesToQualifiedNames);
        return new RuntimeValue((Object)support);
    }

    public void initializeConfigurationMergerBean() {
        GraphQLClientConfigurationMergerBean merger = (GraphQLClientConfigurationMergerBean)Arc.container().instance(GraphQLClientConfigurationMergerBean.class, new Annotation[0]).get();
        merger.nothing();
    }
}

