/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.client.runtime;

import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientConfig;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientSupport;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientsConfig;
import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GraphQLClientConfigurationMergerBean {
    GraphQLClientsConfiguration upstreamConfiguration;
    @Inject
    GraphQLClientsConfig quarkusConfiguration;
    @Inject
    GraphQLClientSupport support;

    @PostConstruct
    void enhanceGraphQLConfiguration() {
        this.upstreamConfiguration = GraphQLClientsConfiguration.getInstance();
        for (Map.Entry<String, GraphQLClientConfig> client : this.quarkusConfiguration.clients.entrySet()) {
            String rawConfigKey = client.getKey();
            Map<String, String> shortNamesToQualifiedNamesMapping = this.support.getShortNamesToQualifiedNamesMapping();
            String configKey = shortNamesToQualifiedNamesMapping != null && shortNamesToQualifiedNamesMapping.containsKey(rawConfigKey) ? shortNamesToQualifiedNamesMapping.get(rawConfigKey) : rawConfigKey;
            GraphQLClientConfig quarkusConfig = client.getValue();
            if (this.upstreamConfiguration.getClient(configKey) == null) {
                GraphQLClientConfiguration transformed = new GraphQLClientConfiguration();
                transformed.setHeaders(quarkusConfig.headers);
                quarkusConfig.url.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setUrl(arg_0));
                this.upstreamConfiguration.addClient(configKey, transformed);
                continue;
            }
            GraphQLClientConfiguration upstreamConfig = this.upstreamConfiguration.getClient(configKey);
            quarkusConfig.url.ifPresent(arg_0 -> ((GraphQLClientConfiguration)upstreamConfig).setUrl(arg_0));
            if (quarkusConfig.headers == null) continue;
            upstreamConfig.getHeaders().putAll(quarkusConfig.headers);
        }
    }

    public void nothing() {
    }
}

