/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.client.runtime;

import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientConfig;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientSupport;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientsConfig;
import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GraphQLClientConfigurationMergerBean {
    GraphQLClientsConfiguration upstreamConfiguration;
    @Inject
    GraphQLClientsConfig quarkusConfiguration;
    @Inject
    GraphQLClientSupport support;

    @PostConstruct
    void enhanceGraphQLConfiguration() {
        this.upstreamConfiguration = GraphQLClientsConfiguration.getInstance();
        for (Map.Entry<String, GraphQLClientConfig> client : this.quarkusConfiguration.clients.entrySet()) {
            String rawConfigKey = client.getKey();
            Map<String, String> shortNamesToQualifiedNamesMapping = this.support.getShortNamesToQualifiedNamesMapping();
            String configKey = shortNamesToQualifiedNamesMapping != null && shortNamesToQualifiedNamesMapping.containsKey(rawConfigKey) ? shortNamesToQualifiedNamesMapping.get(rawConfigKey) : rawConfigKey;
            GraphQLClientConfig quarkusConfig = client.getValue();
            if (this.upstreamConfiguration.getClient(configKey) == null) {
                GraphQLClientConfiguration transformed = new GraphQLClientConfiguration();
                transformed.setHeaders(quarkusConfig.headers);
                quarkusConfig.url.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setUrl(arg_0));
                transformed.setWebsocketSubprotocols((List)quarkusConfig.subprotocols.orElse(new ArrayList()));
                this.upstreamConfiguration.addClient(configKey, transformed);
                continue;
            }
            GraphQLClientConfiguration upstreamConfig = this.upstreamConfiguration.getClient(configKey);
            quarkusConfig.url.ifPresent(arg_0 -> ((GraphQLClientConfiguration)upstreamConfig).setUrl(arg_0));
            if (quarkusConfig.headers != null) {
                upstreamConfig.getHeaders().putAll(quarkusConfig.headers);
            }
            if (!quarkusConfig.subprotocols.isPresent()) continue;
            if (upstreamConfig.getWebsocketSubprotocols() != null) {
                upstreamConfig.getWebsocketSubprotocols().addAll((Collection)quarkusConfig.subprotocols.get());
                continue;
            }
            upstreamConfig.setWebsocketSubprotocols(quarkusConfig.subprotocols.get());
        }
    }

    public void nothing() {
    }
}

