/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.client.runtime;

import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientConfig;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientSupport;
import io.quarkus.smallrye.graphql.client.runtime.GraphQLClientsConfig;
import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.model.ClientModels;
import io.smallrye.graphql.client.typesafe.api.TypesafeGraphQLClientBuilder;
import io.smallrye.graphql.client.vertx.VertxManager;
import io.smallrye.graphql.client.vertx.typesafe.VertxTypesafeGraphQLClientBuilder;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@Recorder
public class SmallRyeGraphQLClientRecorder {
    private final Logger logger = Logger.getLogger(SmallRyeGraphQLClientRecorder.class);

    public <T> Function<SyntheticCreationalContext<T>, T> typesafeClientSupplier(final Class<T> targetClassName) {
        return new Function<SyntheticCreationalContext<T>, T>(){

            @Override
            public T apply(SyntheticCreationalContext<T> context) {
                TypesafeGraphQLClientBuilder builder = TypesafeGraphQLClientBuilder.newBuilder();
                ClientModels clientModels = (ClientModels)context.getInjectedReference(ClientModels.class, new Annotation[0]);
                return ((VertxTypesafeGraphQLClientBuilder)builder).clientModels(clientModels).build(targetClassName);
            }
        };
    }

    public void setTypesafeApiClasses(List<String> apiClassNames) {
        GraphQLClientsConfiguration.setSingleApplication((boolean)true);
        GraphQLClientsConfiguration configBean = GraphQLClientsConfiguration.getInstance();
        List classes = apiClassNames.stream().map(className -> {
            try {
                return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        configBean.addTypesafeClientApis(classes);
    }

    public void mergeClientConfigurations(GraphQLClientSupport support, GraphQLClientsConfig quarkusConfiguration) {
        GraphQLClientsConfiguration upstreamConfigs = GraphQLClientsConfiguration.getInstance();
        for (Map.Entry<String, GraphQLClientConfig> client : quarkusConfiguration.clients.entrySet()) {
            String rawConfigKey = client.getKey();
            Map<String, String> shortNamesToQualifiedNamesMapping = support.getShortNamesToQualifiedNamesMapping();
            String configKey = shortNamesToQualifiedNamesMapping != null && shortNamesToQualifiedNamesMapping.containsKey(rawConfigKey) ? shortNamesToQualifiedNamesMapping.get(rawConfigKey) : rawConfigKey;
            GraphQLClientConfig quarkusConfig = client.getValue();
            GraphQLClientConfiguration upstreamConfig = upstreamConfigs.getClient(configKey);
            if (upstreamConfig == null) {
                GraphQLClientConfiguration transformed = this.toSmallRyeNativeConfiguration(quarkusConfig);
                upstreamConfigs.addClient(configKey, transformed);
                continue;
            }
            upstreamConfig.merge(this.toSmallRyeNativeConfiguration(quarkusConfig));
        }
        if (LaunchMode.current() == LaunchMode.TEST) {
            String testUrl = null;
            for (String configKey : support.getKnownConfigKeys()) {
                GraphQLClientConfiguration config = upstreamConfigs.getClient(configKey);
                if (config.getUrl() != null) continue;
                if (testUrl == null) {
                    testUrl = this.getTestingServerUrl();
                }
                this.logger.info((Object)("Automatically wiring the URL of GraphQL client named " + configKey + " to " + testUrl + ". If this is incorrect, please set it manually using the quarkus.smallrye-graphql-client." + this.maybeWithQuotes(configKey) + ".url property. Also note that this autowiring is only supported during tests."));
                config.setUrl(testUrl);
            }
        }
    }

    public void setGlobalVertxInstance(Supplier<Vertx> vertx) {
        VertxManager.setFromGlobal((Vertx)vertx.get());
    }

    private String maybeWithQuotes(String key) {
        if (key.contains(".")) {
            return "\"" + key + "\"";
        }
        return key;
    }

    private GraphQLClientConfiguration toSmallRyeNativeConfiguration(GraphQLClientConfig quarkusConfig) {
        GraphQLClientConfiguration transformed = new GraphQLClientConfiguration();
        transformed.setHeaders(quarkusConfig.headers);
        transformed.setInitPayload((Map)Optional.ofNullable(quarkusConfig.initPayload).map(m -> new HashMap(m)).orElse(null));
        quarkusConfig.url.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setUrl(arg_0));
        transformed.setWebsocketSubprotocols((List)quarkusConfig.subprotocols.orElse(new ArrayList()));
        quarkusConfig.keyStore.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setKeyStore(arg_0));
        quarkusConfig.keyStoreType.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setKeyStoreType(arg_0));
        quarkusConfig.keyStorePassword.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setKeyStorePassword(arg_0));
        quarkusConfig.trustStore.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setTrustStore(arg_0));
        quarkusConfig.trustStoreType.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setTrustStoreType(arg_0));
        quarkusConfig.trustStorePassword.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setTrustStorePassword(arg_0));
        quarkusConfig.proxyHost.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setProxyHost(arg_0));
        quarkusConfig.proxyPort.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setProxyPort(arg_0));
        quarkusConfig.proxyUsername.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setProxyUsername(arg_0));
        quarkusConfig.proxyPassword.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setProxyPassword(arg_0));
        quarkusConfig.maxRedirects.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setMaxRedirects(arg_0));
        quarkusConfig.executeSingleResultOperationsOverWebsocket.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setExecuteSingleOperationsOverWebsocket(arg_0));
        quarkusConfig.websocketInitializationTimeout.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setWebsocketInitializationTimeout(arg_0));
        quarkusConfig.allowUnexpectedResponseFields.ifPresent(arg_0 -> ((GraphQLClientConfiguration)transformed).setAllowUnexpectedResponseFields(arg_0));
        transformed.setDynamicHeaders(new HashMap());
        return transformed;
    }

    private String getTestingServerUrl() {
        Config config = ConfigProvider.getConfig();
        return "http://localhost:" + config.getOptionalValue("quarkus.http.test-port", Integer.TYPE).orElse(8081) + "/graphql";
    }

    public RuntimeValue<ClientModels> getRuntimeClientModel(ClientModels clientModel) {
        return new RuntimeValue((Object)clientModel);
    }
}

