/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.deployment;

import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeReference;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.graphql.deployment.SmallRyeGraphQLBuildItem;
import io.quarkus.smallrye.graphql.deployment.SmallRyeGraphQLConfig;
import io.quarkus.smallrye.graphql.deployment.SmallRyeGraphQLInitializedBuildItem;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLRecorder;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLRuntimeConfig;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.smallrye.graphql.cdi.config.GraphQLConfig;
import io.smallrye.graphql.cdi.producer.GraphQLProducer;
import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilder;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Group;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.InterfaceType;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.spi.EventingService;
import io.smallrye.graphql.spi.LookupService;
import io.vertx.core.Handler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class SmallRyeGraphQLProcessor {
    private static final Logger LOG = Logger.getLogger(SmallRyeGraphQLProcessor.class);
    private static final String SCHEMA_PATH = "schema.graphql";
    private static final String SERVICE_NOT_AVAILABLE_WARNING = "The %s property is true, but the %s extension is not present. SmallRye GraphQL %s will be disabled.";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String GRAPHQL_UI_WEBJAR_GROUP_ID = "io.smallrye";
    private static final String GRAPHQL_UI_WEBJAR_ARTIFACT_ID = "smallrye-graphql-ui-graphiql";
    private static final String GRAPHQL_UI_WEBJAR_PREFIX = "META-INF/resources/graphql-ui/";
    private static final String GRAPHQL_UI_FINAL_DESTINATION = "META-INF/graphql-ui-files";
    private static final String FILE_TO_UPDATE = "render.js";
    private static final String LINE_TO_UPDATE = "const api = '";
    private static final String LINE_FORMAT = "const api = '%s';";
    private static final String UI_LINE_TO_UPDATE = "const ui = '";
    private static final String UI_LINE_FORMAT = "const ui = '%s';";
    private static final String BRANDING_DIR = "META-INF/branding/";
    private static final String BRANDING_LOGO_GENERAL = "META-INF/branding/logo.png";
    private static final String BRANDING_LOGO_MODULE = "META-INF/branding/smallrye-graphql-ui-graphiql.png";
    private static final String BRANDING_STYLE_GENERAL = "META-INF/branding/style.css";
    private static final String BRANDING_STYLE_MODULE = "META-INF/branding/smallrye-graphql-ui-graphiql.css";
    private static final String BRANDING_FAVICON_GENERAL = "META-INF/branding/favicon.ico";
    private static final String BRANDING_FAVICON_MODULE = "META-INF/branding/smallrye-graphql-ui-graphiql.ico";

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> featureProducer) {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_GRAPHQL));
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> brandingFiles() {
        return Stream.of(BRANDING_LOGO_GENERAL, BRANDING_STYLE_GENERAL, BRANDING_FAVICON_GENERAL, BRANDING_LOGO_MODULE, BRANDING_STYLE_MODULE, BRANDING_FAVICON_MODULE).map(HotDeploymentWatchedFileBuildItem::new).collect(Collectors.toList());
    }

    @BuildStep
    void additionalBeanDefiningAnnotation(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotationProducer) {
        beanDefiningAnnotationProducer.produce((BuildItem)new BeanDefiningAnnotationBuildItem(Annotations.GRAPHQL_API));
    }

    @BuildStep
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(GraphQLConfig.class).addBeanClass(GraphQLProducer.class).setUnremovable().build());
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.graphql-java", "graphql-java"));
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<ServiceProviderBuildItem> serviceProvider) throws IOException {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)LookupService.class.getName()));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)EventingService.class.getName()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void buildExecutionService(BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyProducer, BuildProducer<SmallRyeGraphQLInitializedBuildItem> graphQLInitializedProducer, SmallRyeGraphQLRecorder recorder, BeanContainerBuildItem beanContainer, CombinedIndexBuildItem combinedIndex, SmallRyeGraphQLConfig graphQLConfig) {
        IndexView index = combinedIndex.getIndex();
        Schema schema = SchemaBuilder.build((IndexView)index, (TypeAutoNameStrategy)graphQLConfig.autoNameStrategy);
        RuntimeValue initialized = recorder.createExecutionService(beanContainer.getValue(), schema);
        graphQLInitializedProducer.produce((BuildItem)new SmallRyeGraphQLInitializedBuildItem((RuntimeValue<Boolean>)initialized));
        reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, this.getSchemaJavaClasses(schema)));
        reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, this.getGraphQLJavaClasses()));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void buildSchemaEndpoint(BuildProducer<RouteBuildItem> routeProducer, HttpRootPathBuildItem httpRootPathBuildItem, SmallRyeGraphQLInitializedBuildItem graphQLInitializedBuildItem, SmallRyeGraphQLRecorder recorder, SmallRyeGraphQLConfig graphQLConfig) {
        Handler schemaHandler = recorder.schemaHandler(graphQLInitializedBuildItem.getInitialized());
        routeProducer.produce((BuildItem)httpRootPathBuildItem.routeBuilder().nestedRoute(graphQLConfig.rootPath, SCHEMA_PATH).handler(schemaHandler).displayOnNotFoundPage("MicroProfile GraphQL Schema").blockingRoute().build());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    @Consume(value=BeanContainerBuildItem.class)
    void buildExecutionEndpoint(BuildProducer<RouteBuildItem> routeProducer, HttpRootPathBuildItem httpRootPathBuildItem, SmallRyeGraphQLInitializedBuildItem graphQLInitializedBuildItem, SmallRyeGraphQLRecorder recorder, ShutdownContextBuildItem shutdownContext, LaunchModeBuildItem launchMode, BodyHandlerBuildItem bodyHandlerBuildItem, SmallRyeGraphQLConfig graphQLConfig) {
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            recorder.setupClDevMode((ShutdownContext)shutdownContext);
        }
        Boolean allowGet = ConfigProvider.getConfig().getOptionalValue("smallrye.graphql.allowGet", Boolean.TYPE).orElse(false);
        Handler executionHandler = recorder.executionHandler(graphQLInitializedBuildItem.getInitialized(), allowGet.booleanValue());
        routeProducer.produce((BuildItem)httpRootPathBuildItem.routeBuilder().routeFunction(graphQLConfig.rootPath, recorder.routeFunction(bodyHandlerBuildItem.getHandler())).handler(executionHandler).routeConfigKey("quarkus.smallrye-graphql.root-path").displayOnNotFoundPage("MicroProfile GraphQL Endpoint").blockingRoute().build());
    }

    private String[] getSchemaJavaClasses(Schema schema) {
        HashSet<String> classes = new HashSet<String>();
        classes.addAll(this.getOperationClassNames(schema.getQueries()));
        classes.addAll(this.getOperationClassNames(schema.getGroupedQueries()));
        classes.addAll(this.getOperationClassNames(schema.getMutations()));
        classes.addAll(this.getOperationClassNames(schema.getGroupedMutations()));
        classes.addAll(this.getTypeClassNames(schema.getTypes().values()));
        classes.addAll(this.getInputClassNames(schema.getInputs().values()));
        classes.addAll(this.getInterfaceClassNames(schema.getInterfaces().values()));
        return classes.toArray(new String[0]);
    }

    private Class[] getGraphQLJavaClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(FieldCoordinates.class);
        classes.add(GraphQLArgument.class);
        classes.add(GraphQLCodeRegistry.class);
        classes.add(GraphQLEnumType.class);
        classes.add(GraphQLFieldDefinition.class);
        classes.add(GraphQLInputObjectField.class);
        classes.add(GraphQLInputObjectType.class);
        classes.add(GraphQLInputType.class);
        classes.add(GraphQLInterfaceType.class);
        classes.add(GraphQLList.class);
        classes.add(GraphQLNonNull.class);
        classes.add(GraphQLObjectType.class);
        classes.add(GraphQLOutputType.class);
        classes.add(GraphQLScalarType.class);
        classes.add(GraphQLSchema.class);
        classes.add(GraphQLTypeReference.class);
        classes.add(List.class);
        classes.add(Collection.class);
        return classes.toArray(new Class[0]);
    }

    private Set<String> getOperationClassNames(Set<Operation> operations) {
        HashSet<String> classes = new HashSet<String>();
        for (Operation operation : operations) {
            classes.add(operation.getClassName());
            for (Argument argument : operation.getArguments()) {
                classes.addAll(this.getAllReferenceClasses(argument.getReference()));
            }
            classes.addAll(this.getAllReferenceClasses(operation.getReference()));
        }
        return classes;
    }

    private Set<String> getOperationClassNames(Map<Group, Set<Operation>> groupedOperations) {
        HashSet<String> classes = new HashSet<String>();
        Collection<Set<Operation>> operations = groupedOperations.values();
        for (Set<Operation> operationSet : operations) {
            classes.addAll(this.getOperationClassNames(operationSet));
        }
        return classes;
    }

    private Set<String> getTypeClassNames(Collection<Type> complexGraphQLTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (Type complexGraphQLType : complexGraphQLTypes) {
            classes.add(complexGraphQLType.getClassName());
            classes.addAll(this.getFieldClassNames(complexGraphQLType.getFields()));
        }
        return classes;
    }

    private Set<String> getInputClassNames(Collection<InputType> complexGraphQLTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (InputType complexGraphQLType : complexGraphQLTypes) {
            classes.add(complexGraphQLType.getClassName());
            classes.addAll(this.getFieldClassNames(complexGraphQLType.getFields()));
        }
        return classes;
    }

    private Set<String> getInterfaceClassNames(Collection<InterfaceType> complexGraphQLTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (InterfaceType complexGraphQLType : complexGraphQLTypes) {
            classes.add(complexGraphQLType.getClassName());
            classes.addAll(this.getFieldClassNames(complexGraphQLType.getFields()));
        }
        return classes;
    }

    private Set<String> getFieldClassNames(Map<String, Field> fields) {
        HashSet<String> classes = new HashSet<String>();
        for (Field field : fields.values()) {
            classes.addAll(this.getAllReferenceClasses(field.getReference()));
        }
        return classes;
    }

    private Set<String> getAllReferenceClasses(Reference reference) {
        HashSet<String> classes = new HashSet<String>();
        classes.add(reference.getClassName());
        if (reference.getParametrizedTypeArguments() != null && !reference.getParametrizedTypeArguments().isEmpty()) {
            Collection parametrized = reference.getParametrizedTypeArguments().values();
            for (Reference r : parametrized) {
                classes.addAll(this.getAllReferenceClasses(r));
            }
        }
        return classes;
    }

    @BuildStep
    void activateMetrics(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability, SmallRyeGraphQLConfig graphQLConfig, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        boolean activate = this.shouldActivateService(capabilities, graphQLConfig.metricsEnabled, metricsCapability.isPresent(), "quarkus-smallrye-metrics", "metrics", "quarkus.smallrye-graphql.metrics.enabled");
        if (activate) {
            if (metricsCapability.isPresent() && metricsCapability.get().metricsSupported("smallrye-metrics")) {
                unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{"io.smallrye.metrics.MetricRegistries"}));
            }
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.metrics.enabled", TRUE));
        } else {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.metrics.enabled", FALSE));
        }
    }

    @BuildStep
    void activateTracing(Capabilities capabilities, SmallRyeGraphQLConfig graphQLConfig, BuildProducer<SystemPropertyBuildItem> systemProperties) {
        boolean activate = this.shouldActivateService(capabilities, graphQLConfig.tracingEnabled, "quarkus-smallrye-opentracing", Capability.OPENTRACING, "quarkus.smallrye-graphql.tracing.enabled");
        if (activate) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.tracing.enabled", TRUE));
        } else {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.tracing.enabled", FALSE));
        }
    }

    @BuildStep
    void activateValidation(Capabilities capabilities, SmallRyeGraphQLConfig graphQLConfig, BuildProducer<SystemPropertyBuildItem> systemProperties) {
        boolean activate = this.shouldActivateService(capabilities, graphQLConfig.validationEnabled, "quarkus-hibernate-validator", Capability.HIBERNATE_VALIDATOR, "quarkus.smallrye-graphql.validation.enabled");
        if (activate) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.validation.enabled", TRUE));
        } else {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.validation.enabled", FALSE));
        }
    }

    @BuildStep
    void activateEventing(SmallRyeGraphQLConfig graphQLConfig, BuildProducer<SystemPropertyBuildItem> systemProperties) {
        if (graphQLConfig.eventsEnabled) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.events.enabled", TRUE));
        } else {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.events.enabled", FALSE));
        }
    }

    private boolean shouldActivateService(Capabilities capabilities, Optional<Boolean> serviceEnabled, String linkedExtensionName, Capability linkedCapability, String configKey) {
        return this.shouldActivateService(capabilities, serviceEnabled, capabilities.isPresent(linkedCapability), linkedExtensionName, linkedCapability.getName(), configKey);
    }

    private boolean shouldActivateService(Capabilities capabilities, Optional<Boolean> serviceEnabled, boolean linkedCapabilityIsPresent, String linkedExtensionName, String linkedCapabilityName, String configKey) {
        if (serviceEnabled.isPresent()) {
            boolean isEnabled = serviceEnabled.get();
            if (isEnabled && !linkedCapabilityIsPresent) {
                LOG.warnf(SERVICE_NOT_AVAILABLE_WARNING, (Object)configKey, (Object)linkedExtensionName, (Object)linkedCapabilityName);
            }
            return isEnabled && linkedCapabilityIsPresent;
        }
        return linkedCapabilityIsPresent;
    }

    @BuildStep
    void getGraphqlUiFinalDestination(BuildProducer<GeneratedResourceBuildItem> generatedResourceProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageDisplayableEndpointProducer, BuildProducer<SmallRyeGraphQLBuildItem> smallRyeGraphQLBuildProducer, HttpRootPathBuildItem httpRootPath, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, SmallRyeGraphQLConfig graphQLConfig, LiveReloadBuildItem liveReloadBuildItem) throws Exception {
        if (SmallRyeGraphQLProcessor.shouldInclude(launchMode, graphQLConfig)) {
            if ("/".equals(graphQLConfig.ui.rootPath)) {
                throw new ConfigurationError("quarkus.smallrye-graphql.root-path-ui was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
            }
            String graphQLPath = httpRootPath.resolvePath(graphQLConfig.rootPath);
            String graphQLUiPath = nonApplicationRootPathBuildItem.resolvePath(graphQLConfig.ui.rootPath);
            AppArtifact artifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)GRAPHQL_UI_WEBJAR_GROUP_ID, (String)GRAPHQL_UI_WEBJAR_ARTIFACT_ID);
            if (launchMode.getLaunchMode().isDevOrTest()) {
                Path tempPath = WebJarUtil.copyResourcesForDevOrTest((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)launchMode, (AppArtifact)artifact, (String)GRAPHQL_UI_WEBJAR_PREFIX);
                WebJarUtil.updateUrl((Path)tempPath.resolve(FILE_TO_UPDATE), (String)graphQLPath, (String)LINE_TO_UPDATE, (String)LINE_FORMAT);
                WebJarUtil.updateUrl((Path)tempPath.resolve(FILE_TO_UPDATE), (String)graphQLUiPath, (String)UI_LINE_TO_UPDATE, (String)UI_LINE_FORMAT);
                smallRyeGraphQLBuildProducer.produce((BuildItem)new SmallRyeGraphQLBuildItem(tempPath.toAbsolutePath().toString(), graphQLUiPath));
                if (liveReloadBuildItem.isLiveReload() && !liveReloadBuildItem.getChangedResources().isEmpty()) {
                    WebJarUtil.hotReloadBrandingChanges((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)launchMode, (AppArtifact)artifact, (Set)liveReloadBuildItem.getChangedResources());
                }
            } else {
                Map files = WebJarUtil.copyResourcesForProduction((CurateOutcomeBuildItem)curateOutcomeBuildItem, (AppArtifact)artifact, (String)GRAPHQL_UI_WEBJAR_PREFIX);
                for (Map.Entry file : files.entrySet()) {
                    String fileName = (String)file.getKey();
                    byte[] content = (byte[])file.getValue();
                    if (fileName.endsWith(FILE_TO_UPDATE)) {
                        content = WebJarUtil.updateUrl((String)new String(content, StandardCharsets.UTF_8), (String)graphQLPath, (String)LINE_TO_UPDATE, (String)LINE_FORMAT).getBytes(StandardCharsets.UTF_8);
                        content = WebJarUtil.updateUrl((String)new String(content, StandardCharsets.UTF_8), (String)graphQLUiPath, (String)UI_LINE_TO_UPDATE, (String)UI_LINE_FORMAT).getBytes(StandardCharsets.UTF_8);
                    }
                    fileName = "META-INF/graphql-ui-files/" + fileName;
                    generatedResourceProducer.produce((BuildItem)new GeneratedResourceBuildItem(fileName, content));
                    nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
                }
                smallRyeGraphQLBuildProducer.produce((BuildItem)new SmallRyeGraphQLBuildItem(GRAPHQL_UI_FINAL_DESTINATION, graphQLUiPath));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerGraphQLUiHandler(BuildProducer<RouteBuildItem> routeProducer, SmallRyeGraphQLRecorder recorder, SmallRyeGraphQLRuntimeConfig runtimeConfig, SmallRyeGraphQLBuildItem smallRyeGraphQLBuildItem, LaunchModeBuildItem launchMode, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeGraphQLConfig graphQLConfig) throws Exception {
        if (SmallRyeGraphQLProcessor.shouldInclude(launchMode, graphQLConfig)) {
            Handler handler = recorder.uiHandler(smallRyeGraphQLBuildItem.getGraphqlUiFinalDestination(), smallRyeGraphQLBuildItem.getGraphqlUiPath(), runtimeConfig);
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(graphQLConfig.ui.rootPath).routeConfigKey("quarkus.smallrye-graphql.ui.root-path").displayOnNotFoundPage("MicroProfile GraphQL UI").handler(handler).requiresLegacyRedirect().build());
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(graphQLConfig.ui.rootPath + "/*").handler(handler).requiresLegacyRedirect().build());
        }
    }

    private static boolean shouldInclude(LaunchModeBuildItem launchMode, SmallRyeGraphQLConfig graphQLConfig) {
        return launchMode.getLaunchMode().isDevOrTest() || graphQLConfig.ui.alwaysInclude;
    }
}

