/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.deployment;

import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeReference;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.graphql.deployment.SmallRyeGraphQLConfig;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLRecorder;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RequireBodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.smallrye.graphql.cdi.config.GraphQLConfig;
import io.smallrye.graphql.cdi.producer.GraphQLProducer;
import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilder;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.InterfaceType;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.spi.LookupService;
import io.smallrye.graphql.spi.SchemaBuildingExtensionService;
import io.vertx.core.Handler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeGraphQLProcessor {
    private static final Logger LOG = Logger.getLogger(SmallRyeGraphQLProcessor.class);
    private static final String SCHEMA_PATH = "/schema.graphql";
    private static final String SPI_PATH = "META-INF/services/";
    private static final String GRAPHQL_UI_WEBJAR_GROUP_ID = "io.smallrye";
    private static final String GRAPHQL_UI_WEBJAR_ARTIFACT_ID = "smallrye-graphql-ui-graphiql";
    private static final String GRAPHQL_UI_WEBJAR_PREFIX = "META-INF/resources/graphql-ui";
    private static final String OWN_MEDIA_FOLDER = "META-INF/resources/";
    private static final String GRAPHQL_UI_FINAL_DESTINATION = "META-INF/graphql-ui-files";
    private static final String TEMP_DIR_PREFIX = "quarkus-graphql-ui_" + System.nanoTime();
    private static final List<String> IGNORE_LIST = Arrays.asList("logo.png", "favicon.ico");
    private static final String FILE_TO_UPDATE = "render.js";
    SmallRyeGraphQLConfig quarkusConfig;

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> featureProducer) {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_GRAPHQL));
    }

    @BuildStep
    void additionalBeanDefiningAnnotation(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotationProducer) {
        beanDefiningAnnotationProducer.produce((BuildItem)new BeanDefiningAnnotationBuildItem(Annotations.GRAPHQL_API));
    }

    @BuildStep
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(GraphQLConfig.class).addBeanClass(GraphQLProducer.class).setUnremovable().build());
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.graphql-java", "graphql-java"));
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<ServiceProviderBuildItem> serviceProvider) throws IOException {
        String lookupService = SPI_PATH + LookupService.class.getName();
        Set lookupImplementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)lookupService);
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(LookupService.class.getName(), lookupImplementations.toArray(new String[0])));
        String schemaExtensionService = SPI_PATH + SchemaBuildingExtensionService.class.getName();
        Set schemaExtensionImplementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)schemaExtensionService);
        serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SchemaBuildingExtensionService.class.getName(), schemaExtensionImplementations.toArray(new String[0])));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void buildExecutionService(BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyProducer, SmallRyeGraphQLRecorder recorder, BeanContainerBuildItem beanContainer, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        Schema schema = SchemaBuilder.build((IndexView)index);
        recorder.createExecutionService(beanContainer.getValue(), schema);
        for (String c : this.getClassesToRegisterForReflection(schema)) {
            DotName name = DotName.createSimple((String)c);
            org.jboss.jandex.Type type = org.jboss.jandex.Type.create((DotName)name, (Type.Kind)Type.Kind.CLASS);
            reflectiveHierarchyProducer.produce((BuildItem)new ReflectiveHierarchyBuildItem(type, index));
        }
        reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, this.getGraphQLJavaClasses()));
    }

    @BuildStep
    void activateMetrics(Capabilities capabilities, SmallRyeGraphQLConfig smallRyeGraphQLConfig, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<SystemPropertyBuildItem> systemProperties) {
        if (smallRyeGraphQLConfig.metricsEnabled) {
            if (capabilities.isPresent(Capability.METRICS)) {
                unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion("io.smallrye.metrics.MetricsRegistryImpl")));
                unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion("io.smallrye.metrics.MetricRegistries")));
                systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.metrics.enabled", "true"));
            } else {
                LOG.warn((Object)"The quarkus.smallrye-graphql.metrics.enabled property is true, but the quarkus-smallrye-metrics dependency is not present.");
                systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.metrics.enabled", "false"));
            }
        } else {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.metrics.enabled", "false"));
        }
    }

    @BuildStep
    void requireBody(BuildProducer<RequireBodyHandlerBuildItem> requireBodyHandlerProducer) {
        requireBodyHandlerProducer.produce((BuildItem)new RequireBodyHandlerBuildItem());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void buildEndpoints(BuildProducer<RouteBuildItem> routeProducer, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageDisplayableEndpointProducer, LaunchModeBuildItem launchMode, SmallRyeGraphQLRecorder recorder, ShutdownContextBuildItem shutdownContext, BeanContainerBuildItem beanContainerBuildItem) {
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            recorder.setupClDevMode((ShutdownContext)shutdownContext);
        }
        if (launchMode.getLaunchMode().isDevOrTest()) {
            notFoundPageDisplayableEndpointProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.quarkusConfig.rootPath));
            notFoundPageDisplayableEndpointProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.quarkusConfig.rootPath + SCHEMA_PATH));
        }
        Boolean allowGet = ConfigProvider.getConfig().getOptionalValue("smallrye.graphql.allowGet", Boolean.TYPE).orElse(false);
        Handler executionHandler = recorder.executionHandler(allowGet.booleanValue());
        routeProducer.produce((BuildItem)new RouteBuildItem(this.quarkusConfig.rootPath, executionHandler, HandlerType.BLOCKING));
        Handler schemaHandler = recorder.schemaHandler();
        routeProducer.produce((BuildItem)new RouteBuildItem(this.quarkusConfig.rootPath + SCHEMA_PATH, schemaHandler, HandlerType.BLOCKING));
    }

    @BuildStep
    void openTracingIntegration(Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> properties) {
        if (capabilities.isPresent(Capability.OPENTRACING)) {
            properties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.tracing.enabled", "true"));
        } else {
            properties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.tracing.enabled", "false"));
        }
    }

    private Set<String> getClassesToRegisterForReflection(Schema schema) {
        HashSet<String> classes = new HashSet<String>();
        classes.addAll(this.getOperationClassNames(schema.getQueries()));
        classes.addAll(this.getOperationClassNames(schema.getMutations()));
        classes.addAll(this.getTypeClassNames(schema.getTypes().values()));
        classes.addAll(this.getInputClassNames(schema.getInputs().values()));
        classes.addAll(this.getInterfaceClassNames(schema.getInterfaces().values()));
        return classes;
    }

    private Class[] getGraphQLJavaClasses() {
        HashSet<Class<List>> classes = new HashSet<Class<List>>();
        classes.add(FieldCoordinates.class);
        classes.add(GraphQLArgument.class);
        classes.add(GraphQLCodeRegistry.class);
        classes.add(GraphQLEnumType.class);
        classes.add(GraphQLFieldDefinition.class);
        classes.add(GraphQLInputObjectField.class);
        classes.add(GraphQLInputObjectType.class);
        classes.add(GraphQLInputType.class);
        classes.add(GraphQLInterfaceType.class);
        classes.add(GraphQLList.class);
        classes.add(GraphQLNonNull.class);
        classes.add(GraphQLObjectType.class);
        classes.add(GraphQLOutputType.class);
        classes.add(GraphQLScalarType.class);
        classes.add(GraphQLSchema.class);
        classes.add(GraphQLTypeReference.class);
        classes.add(List.class);
        return classes.toArray(new Class[0]);
    }

    private Set<String> getOperationClassNames(Set<Operation> operations) {
        HashSet<String> classes = new HashSet<String>();
        for (Operation operation : operations) {
            classes.add(operation.getClassName());
            for (Argument argument : operation.getArguments()) {
                classes.add(argument.getReference().getClassName());
            }
            classes.add(operation.getReference().getClassName());
        }
        return classes;
    }

    private Set<String> getTypeClassNames(Collection<Type> complexGraphQLTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (Type complexGraphQLType : complexGraphQLTypes) {
            classes.add(complexGraphQLType.getClassName());
            classes.addAll(this.getFieldClassNames(complexGraphQLType.getFields()));
        }
        return classes;
    }

    private Set<String> getInputClassNames(Collection<InputType> complexGraphQLTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (InputType complexGraphQLType : complexGraphQLTypes) {
            classes.add(complexGraphQLType.getClassName());
            classes.addAll(this.getFieldClassNames(complexGraphQLType.getFields()));
        }
        return classes;
    }

    private Set<String> getInterfaceClassNames(Collection<InterfaceType> complexGraphQLTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (InterfaceType complexGraphQLType : complexGraphQLTypes) {
            classes.add(complexGraphQLType.getClassName());
            classes.addAll(this.getFieldClassNames(complexGraphQLType.getFields()));
        }
        return classes;
    }

    private Set<String> getFieldClassNames(Map<String, Field> fields) {
        HashSet<String> classes = new HashSet<String>();
        for (Field field : fields.values()) {
            classes.add(field.getReference().getClassName());
        }
        return classes;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerGraphQLUiServletExtension(BuildProducer<RouteBuildItem> routeProducer, BuildProducer<GeneratedResourceBuildItem> generatedResourceProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageDisplayableEndpointProducer, SmallRyeGraphQLRecorder recorder, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload, HttpRootPathBuildItem httpRootPath, CurateOutcomeBuildItem curateOutcomeBuildItem) throws Exception {
        if (!this.quarkusConfig.ui.enable) {
            return;
        }
        if ("/".equals(this.quarkusConfig.ui.rootPath)) {
            throw new ConfigurationError("quarkus.smallrye-graphql.root-path-ui was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        String graphQLPath = httpRootPath.adjustPath(this.quarkusConfig.rootPath);
        if (launchMode.getLaunchMode().isDevOrTest()) {
            boolean extractionNeeded;
            CachedGraphQLUI cached = (CachedGraphQLUI)liveReload.getContextObject(CachedGraphQLUI.class);
            boolean bl = extractionNeeded = cached == null;
            if (cached != null && !cached.cachedGraphQLPath.equals(graphQLPath)) {
                try {
                    FileUtil.deleteDirectory((Path)Paths.get(cached.cachedDirectory, new String[0]));
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to clean GraphQL UI temp directory on restart", (Throwable)e);
                }
                extractionNeeded = true;
            }
            if (extractionNeeded) {
                if (cached == null) {
                    cached = new CachedGraphQLUI();
                    liveReload.setContextObject(CachedGraphQLUI.class, (Object)cached);
                    Runtime.getRuntime().addShutdownHook(new Thread((Runnable)cached, "GraphQL UI Shutdown Hook"));
                }
                try {
                    AppArtifact artifact = this.getGraphQLUiArtifact(curateOutcomeBuildItem);
                    Path tempDir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]).toRealPath(new LinkOption[0]);
                    this.extractGraphQLUi(artifact, tempDir);
                    this.updateApiUrl(tempDir.resolve(FILE_TO_UPDATE), graphQLPath);
                    cached.cachedDirectory = tempDir.toAbsolutePath().toString();
                    cached.cachedGraphQLPath = graphQLPath;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Handler handler = recorder.uiHandler(cached.cachedDirectory, httpRootPath.adjustPath(this.quarkusConfig.ui.rootPath));
            routeProducer.produce((BuildItem)new RouteBuildItem(this.quarkusConfig.ui.rootPath, handler));
            routeProducer.produce((BuildItem)new RouteBuildItem(this.quarkusConfig.ui.rootPath + "/*", handler));
            notFoundPageDisplayableEndpointProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.quarkusConfig.ui.rootPath + "/"));
        } else if (this.quarkusConfig.ui.alwaysInclude) {
            AppArtifact artifact = this.getGraphQLUiArtifact(curateOutcomeBuildItem);
            for (Path p : artifact.getPaths()) {
                File artifactFile = p.toFile();
                JarFile jarFile = new JarFile(artifactFile);
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(GRAPHQL_UI_WEBJAR_PREFIX) || entry.isDirectory()) continue;
                        InputStream inputStream = jarFile.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            String filename = entry.getName().replace("META-INF/resources/graphql-ui/", "");
                            byte[] content = FileUtil.readFileContents((InputStream)inputStream);
                            if (entry.getName().endsWith(FILE_TO_UPDATE)) {
                                content = this.updateApiUrl(new String(content, StandardCharsets.UTF_8), graphQLPath).getBytes(StandardCharsets.UTF_8);
                            }
                            if (IGNORE_LIST.contains(filename)) {
                                ClassLoader classLoader = SmallRyeGraphQLProcessor.class.getClassLoader();
                                try (InputStream resourceAsStream = classLoader.getResourceAsStream(OWN_MEDIA_FOLDER + filename);){
                                    content = IoUtil.readBytes((InputStream)resourceAsStream);
                                }
                            }
                            String fileName = "META-INF/graphql-ui-files/" + filename;
                            generatedResourceProducer.produce((BuildItem)new GeneratedResourceBuildItem(fileName, content));
                            nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            Handler handler = recorder.uiHandler(GRAPHQL_UI_FINAL_DESTINATION, httpRootPath.adjustPath(this.quarkusConfig.ui.rootPath));
            routeProducer.produce((BuildItem)new RouteBuildItem(this.quarkusConfig.ui.rootPath, handler));
            routeProducer.produce((BuildItem)new RouteBuildItem(this.quarkusConfig.ui.rootPath + "/*", handler));
        }
    }

    private AppArtifact getGraphQLUiArtifact(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        for (AppDependency dep : curateOutcomeBuildItem.getEffectiveModel().getFullDeploymentDeps()) {
            if (!dep.getArtifact().getArtifactId().equals(GRAPHQL_UI_WEBJAR_ARTIFACT_ID) || !dep.getArtifact().getGroupId().equals(GRAPHQL_UI_WEBJAR_GROUP_ID)) continue;
            return dep.getArtifact();
        }
        throw new RuntimeException("Could not find artifact io.smallrye:smallrye-graphql-ui-graphiql among the application dependencies");
    }

    private void extractGraphQLUi(AppArtifact artifact, Path resourceDir) throws IOException {
        for (Path p : artifact.getPaths()) {
            File artifactFile = p.toFile();
            JarFile jarFile = new JarFile(artifactFile);
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(GRAPHQL_UI_WEBJAR_PREFIX) || entry.isDirectory()) continue;
                    InputStream inputStream = jarFile.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        String filename = entry.getName().replace("META-INF/resources/graphql-ui/", "");
                        if (IGNORE_LIST.contains(filename)) continue;
                        Files.copy(inputStream, resourceDir.resolve(filename), new CopyOption[0]);
                    }
                    catch (Throwable filename) {
                        throwable2 = filename;
                        throw filename;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable filename) {
                                throwable2.addSuppressed(filename);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                ClassLoader classLoader = SmallRyeGraphQLProcessor.class.getClassLoader();
                for (String ownMedia : IGNORE_LIST) {
                    InputStream logo = classLoader.getResourceAsStream(OWN_MEDIA_FOLDER + ownMedia);
                    Throwable throwable3 = null;
                    try {
                        Files.copy(logo, resourceDir.resolve(ownMedia), new CopyOption[0]);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (logo == null) continue;
                        if (throwable3 != null) {
                            try {
                                logo.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        logo.close();
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
    }

    private void updateApiUrl(Path renderJs, String graphqlPath) throws IOException {
        String content = new String(Files.readAllBytes(renderJs), StandardCharsets.UTF_8);
        String result = this.updateApiUrl(content, graphqlPath);
        if (result != null) {
            Files.write(renderJs, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public String updateApiUrl(String original, String graphqlPath) {
        return original.replace("const api = '/graphql';", "const api = '" + graphqlPath + "';");
    }

    private static final class CachedGraphQLUI
    implements Runnable {
        String cachedGraphQLPath;
        String cachedDirectory;

        private CachedGraphQLUI() {
        }

        @Override
        public void run() {
            try {
                FileUtil.deleteDirectory((Path)Paths.get(this.cachedDirectory, new String[0]));
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to clean GraphQL UI temp directory on shutdown", (Throwable)e);
            }
        }
    }
}

