/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.deployment;

import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassConditionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.smallrye.graphql.deployment.OverridableIndex;
import io.quarkus.smallrye.graphql.deployment.SmallRyeGraphQLBuildItem;
import io.quarkus.smallrye.graphql.deployment.SmallRyeGraphQLFinalIndexBuildItem;
import io.quarkus.smallrye.graphql.deployment.SmallRyeGraphQLInitializedBuildItem;
import io.quarkus.smallrye.graphql.deployment.SmallRyeGraphQLModifiedClasesBuildItem;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLConfig;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLConfigMapping;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLLocaleResolver;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLRecorder;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLRuntimeConfig;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.WebsocketSubProtocolsBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarResourcesFilter;
import io.quarkus.vertx.http.deployment.webjar.WebJarResultsBuildItem;
import io.smallrye.graphql.api.AdaptWith;
import io.smallrye.graphql.api.Deprecated;
import io.smallrye.graphql.api.Entry;
import io.smallrye.graphql.api.ErrorExtensionProvider;
import io.smallrye.graphql.api.federation.ComposeDirective;
import io.smallrye.graphql.api.federation.Extends;
import io.smallrye.graphql.api.federation.External;
import io.smallrye.graphql.api.federation.Inaccessible;
import io.smallrye.graphql.api.federation.InterfaceObject;
import io.smallrye.graphql.api.federation.Key;
import io.smallrye.graphql.api.federation.Override;
import io.smallrye.graphql.api.federation.Provides;
import io.smallrye.graphql.api.federation.Requires;
import io.smallrye.graphql.api.federation.Shareable;
import io.smallrye.graphql.api.federation.Tag;
import io.smallrye.graphql.cdi.config.MicroProfileConfig;
import io.smallrye.graphql.cdi.producer.GraphQLProducer;
import io.smallrye.graphql.cdi.tracing.TracingService;
import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilder;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.DirectiveType;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Group;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.schema.model.UnionType;
import io.smallrye.graphql.spi.EventingService;
import io.smallrye.graphql.spi.LookupService;
import io.smallrye.graphql.spi.config.Config;
import io.vertx.core.Handler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class SmallRyeGraphQLProcessor {
    private static final Logger LOG = Logger.getLogger(SmallRyeGraphQLProcessor.class);
    private static final String SCHEMA_PATH = "schema.graphql";
    private static final String SERVICE_NOT_AVAILABLE_WARNING = "The %s property is true, but the %s extension is not present. SmallRye GraphQL %s will be disabled.";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final GACT GRAPHQL_UI_WEBJAR_ARTIFACT_KEY = new GACT("io.smallrye", "smallrye-graphql-ui-graphiql", null, "jar");
    private static final String GRAPHQL_UI_WEBJAR_STATIC_RESOURCES_PATH = "META-INF/resources/graphql-ui/";
    private static final String FILE_TO_UPDATE = "render.js";
    private static final String LINE_TO_UPDATE = "const api = '";
    private static final String LINE_FORMAT = "const api = '%s';";
    private static final String UI_LINE_TO_UPDATE = "const ui = '";
    private static final String UI_LINE_FORMAT = "const ui = '%s';";
    private static final String LOGO_LINE_TO_UPDATE = "const logo = '";
    private static final String LOGO_LINE_FORMAT = "const logo = '%s';";
    private static final String BRANDING_DIR = "META-INF/branding/";
    private static final String BRANDING_LOGO_GENERAL = "META-INF/branding/logo.png";
    private static final String BRANDING_LOGO_MODULE = "META-INF/branding/smallrye-graphql-ui-graphiql.png";
    private static final String BRANDING_STYLE_GENERAL = "META-INF/branding/style.css";
    private static final String BRANDING_STYLE_MODULE = "META-INF/branding/smallrye-graphql-ui-graphiql.css";
    private static final String BRANDING_FAVICON_GENERAL = "META-INF/branding/favicon.ico";
    private static final String BRANDING_FAVICON_MODULE = "META-INF/branding/smallrye-graphql-ui-graphiql.ico";
    private static final String SUBPROTOCOL_GRAPHQL_WS = "graphql-ws";
    private static final String SUBPROTOCOL_GRAPHQL_TRANSPORT_WS = "graphql-transport-ws";
    private static final List<String> SUPPORTED_WEBSOCKET_SUBPROTOCOLS = List.of("graphql-ws", "graphql-transport-ws");
    private static final int GRAPHQL_WEBSOCKET_HANDLER_ORDER = -10000;

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> featureProducer) {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_GRAPHQL));
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> brandingFiles() {
        return Stream.of(BRANDING_LOGO_GENERAL, BRANDING_STYLE_GENERAL, BRANDING_FAVICON_GENERAL, BRANDING_LOGO_MODULE, BRANDING_STYLE_MODULE, BRANDING_FAVICON_MODULE).map(HotDeploymentWatchedFileBuildItem::new).collect(Collectors.toList());
    }

    @BuildStep
    void additionalBeanDefiningAnnotation(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotationProducer) {
        beanDefiningAnnotationProducer.produce((BuildItem)new BeanDefiningAnnotationBuildItem(Annotations.GRAPHQL_API, BuiltinScope.SINGLETON.getName()));
    }

    @BuildStep
    void additionalBean(Capabilities capabilities, CombinedIndexBuildItem combinedIndex, BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(GraphQLProducer.class).setUnremovable().build());
        if (capabilities.isPresent("io.quarkus.hibernate.validator")) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(SmallRyeGraphQLLocaleResolver.class).setUnremovable().build());
        }
        Set<String> adapterClasses = this.getAllAdapterClasses(combinedIndex.getIndex());
        for (String adapterClass : adapterClasses) {
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(adapterClass).setUnremovable().build());
        }
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.graphql-java", "graphql-java"));
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<ReflectiveClassConditionBuildItem> reflectiveClassCondition) throws IOException {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)LookupService.class.getName()));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)EventingService.class.getName()));
        reflectiveClassCondition.produce((BuildItem)new ReflectiveClassConditionBuildItem(TracingService.class, "io.opentelemetry.api.trace.Tracer"));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)MicroProfileConfig.class.getName()));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)SmallRyeGraphQLConfigMapping.class.getName()));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ErrorExtensionProvider.class.getName()));
    }

    @BuildStep
    void registerNativeResourceBundle(BuildProducer<NativeImageResourceBundleBuildItem> nativeResourceBundleProvider) throws IOException {
        nativeResourceBundleProvider.produce((BuildItem)new NativeImageResourceBundleBuildItem("i18n.Validation"));
        nativeResourceBundleProvider.produce((BuildItem)new NativeImageResourceBundleBuildItem("i18n.Parsing"));
    }

    @BuildStep
    SmallRyeGraphQLModifiedClasesBuildItem createIndex(TransformedClassesBuildItem transformedClassesBuildItem) {
        HashMap<String, byte[]> modifiedClasses = new HashMap<String, byte[]>();
        Map transformedClassesByJar = transformedClassesBuildItem.getTransformedClassesByJar();
        for (Map.Entry transformedClassesByJarEntrySet : transformedClassesByJar.entrySet()) {
            Set transformedClasses = (Set)transformedClassesByJarEntrySet.getValue();
            for (TransformedClassesBuildItem.TransformedClass transformedClass : transformedClasses) {
                modifiedClasses.put(transformedClass.getClassName(), transformedClass.getData());
            }
        }
        return new SmallRyeGraphQLModifiedClasesBuildItem(modifiedClasses);
    }

    @BuildStep
    void buildFinalIndex(BuildProducer<SmallRyeGraphQLFinalIndexBuildItem> smallRyeGraphQLFinalIndexProducer, CombinedIndexBuildItem combinedIndex, SmallRyeGraphQLModifiedClasesBuildItem graphQLIndexBuildItem) {
        Indexer indexer = new Indexer();
        Map<String, byte[]> modifiedClases = graphQLIndexBuildItem.getModifiedClases();
        for (Map.Entry<String, byte[]> kv : modifiedClases.entrySet()) {
            if (kv.getKey() == null || kv.getValue() == null) continue;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(kv.getValue());){
                indexer.index((InputStream)bais);
            }
            catch (IOException ex) {
                LOG.warn((Object)("Could not index [" + kv.getKey() + "] - " + ex.getMessage()));
            }
        }
        try {
            indexer.indexClass(Map.class);
            indexer.indexClass(Entry.class);
            indexer.indexClass(Extends.class);
            indexer.indexClass(External.class);
            indexer.indexClass(Key.class);
            indexer.indexClass(Provides.class);
            indexer.indexClass(Requires.class);
            indexer.indexClass(Deprecated.class);
            indexer.indexClass(Shareable.class);
            indexer.indexClass(ComposeDirective.class);
            indexer.indexClass(InterfaceObject.class);
            indexer.indexClass(Inaccessible.class);
            indexer.indexClass(Override.class);
            indexer.indexClass(Tag.class);
        }
        catch (IOException ex) {
            LOG.warn((Object)"Failure while creating index", (Throwable)ex);
        }
        OverridableIndex overridableIndex = OverridableIndex.create(combinedIndex.getIndex(), (IndexView)indexer.complete());
        smallRyeGraphQLFinalIndexProducer.produce((BuildItem)new SmallRyeGraphQLFinalIndexBuildItem(overridableIndex));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void buildExecutionService(BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyProducer, BuildProducer<SmallRyeGraphQLInitializedBuildItem> graphQLInitializedProducer, SmallRyeGraphQLRecorder recorder, SmallRyeGraphQLFinalIndexBuildItem graphQLFinalIndexBuildItem, BeanContainerBuildItem beanContainer, BuildProducer<SystemPropertyBuildItem> systemPropertyProducer, SmallRyeGraphQLConfig graphQLConfig) {
        this.activateFederation(graphQLConfig, systemPropertyProducer, graphQLFinalIndexBuildItem);
        Schema schema = SchemaBuilder.build((IndexView)graphQLFinalIndexBuildItem.getFinalIndex(), (TypeAutoNameStrategy)graphQLConfig.autoNameStrategy);
        RuntimeValue initialized = recorder.createExecutionService(beanContainer.getValue(), schema);
        graphQLInitializedProducer.produce((BuildItem)new SmallRyeGraphQLInitializedBuildItem((RuntimeValue<Boolean>)initialized));
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])this.getSchemaJavaClasses(schema)).methods().fields().build());
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])this.getGraphQLJavaClasses()).methods().fields().build());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void buildSchemaEndpoint(BuildProducer<RouteBuildItem> routeProducer, HttpRootPathBuildItem httpRootPathBuildItem, SmallRyeGraphQLInitializedBuildItem graphQLInitializedBuildItem, SmallRyeGraphQLRecorder recorder, SmallRyeGraphQLConfig graphQLConfig) {
        Handler schemaHandler = recorder.schemaHandler(graphQLInitializedBuildItem.getInitialized(), graphQLConfig.schemaAvailable);
        routeProducer.produce((BuildItem)httpRootPathBuildItem.routeBuilder().nestedRoute(graphQLConfig.rootPath, SCHEMA_PATH).handler(schemaHandler).displayOnNotFoundPage("MicroProfile GraphQL Schema").build());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    @Consume(value=BeanContainerBuildItem.class)
    void buildExecutionEndpoint(BuildProducer<RouteBuildItem> routeProducer, HttpRootPathBuildItem httpRootPathBuildItem, SmallRyeGraphQLInitializedBuildItem graphQLInitializedBuildItem, SmallRyeGraphQLRecorder recorder, ShutdownContextBuildItem shutdownContext, LaunchModeBuildItem launchMode, BodyHandlerBuildItem bodyHandlerBuildItem, SmallRyeGraphQLConfig graphQLConfig, BeanContainerBuildItem beanContainer, BuildProducer<WebsocketSubProtocolsBuildItem> webSocketSubProtocols) {
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            recorder.setupClDevMode((ShutdownContext)shutdownContext);
        }
        boolean runBlocking = this.shouldRunBlockingRoute(graphQLConfig);
        Handler graphqlOverWebsocketHandler = recorder.graphqlOverWebsocketHandler(beanContainer.getValue(), graphQLInitializedBuildItem.getInitialized(), runBlocking);
        HttpRootPathBuildItem.Builder subscriptionsBuilder = httpRootPathBuildItem.routeBuilder().orderedRoute(graphQLConfig.rootPath, Integer.valueOf(-10000)).handler(graphqlOverWebsocketHandler);
        routeProducer.produce((BuildItem)subscriptionsBuilder.build());
        graphQLConfig.websocketSubprotocols.ifPresentOrElse(subprotocols -> {
            for (String subprotocol : subprotocols) {
                if (!SUPPORTED_WEBSOCKET_SUBPROTOCOLS.contains(subprotocol)) {
                    throw new IllegalArgumentException("Unknown websocket subprotocol: " + subprotocol);
                }
                webSocketSubProtocols.produce((BuildItem)new WebsocketSubProtocolsBuildItem(subprotocol));
            }
        }, () -> {
            for (String subprotocol : SUPPORTED_WEBSOCKET_SUBPROTOCOLS) {
                webSocketSubProtocols.produce((BuildItem)new WebsocketSubProtocolsBuildItem(subprotocol));
            }
        });
        boolean allowGet = this.getBooleanConfigValue("smallrye.graphql.allowGet", false);
        boolean allowQueryParametersOnPost = this.getBooleanConfigValue("smallrye.graphql.allowPostWithQueryParameters", false);
        Handler executionHandler = recorder.executionHandler(graphQLInitializedBuildItem.getInitialized(), allowGet, allowQueryParametersOnPost, runBlocking);
        HttpRootPathBuildItem.Builder requestBuilder = httpRootPathBuildItem.routeBuilder().routeFunction(graphQLConfig.rootPath, recorder.routeFunction(bodyHandlerBuildItem.getHandler())).handler(executionHandler).routeConfigKey("quarkus.smallrye-graphql.root-path").displayOnNotFoundPage("MicroProfile GraphQL Endpoint");
        if (runBlocking) {
            requestBuilder = requestBuilder.blockingRoute();
        }
        routeProducer.produce((BuildItem)requestBuilder.build());
    }

    private Set<String> getAllAdapterClasses(IndexView index) {
        HashSet<String> adapterClasses = new HashSet<String>();
        adapterClasses.addAll(this.getAdapterClasses(index, DotName.createSimple((String)AdaptWith.class.getName())));
        adapterClasses.addAll(this.getAdapterClasses(index, DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbTypeAdapter")));
        adapterClasses.addAll(this.getAdapterClasses(index, DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbTypeAdapter")));
        return adapterClasses;
    }

    private Set<String> getAdapterClasses(IndexView index, DotName adapterClass) {
        HashSet<String> adapterClasses = new HashSet<String>();
        Collection adaptWithAnnotations = index.getAnnotations(adapterClass);
        for (AnnotationInstance adaptWithAnnotation : adaptWithAnnotations) {
            AnnotationValue annotationValue = adaptWithAnnotation.value();
            if (annotationValue == null) continue;
            org.jboss.jandex.Type classType = annotationValue.asClass();
            adapterClasses.add(classType.name().toString());
        }
        return adapterClasses;
    }

    private boolean shouldRunBlockingRoute(SmallRyeGraphQLConfig graphQLConfig) {
        if (graphQLConfig.nonBlockingEnabled.isPresent()) {
            return (Boolean)graphQLConfig.nonBlockingEnabled.get() == false;
        }
        return false;
    }

    private boolean getBooleanConfigValue(String smallryeKey, boolean defaultValue) {
        return ConfigProvider.getConfig().getOptionalValue(smallryeKey, Boolean.TYPE).orElse(defaultValue);
    }

    private String[] getSchemaJavaClasses(Schema schema) {
        HashSet<String> classes = new HashSet<String>();
        classes.addAll(this.getOperationClassNames(schema.getQueries()));
        classes.addAll(this.getOperationClassNames(schema.getGroupedQueries()));
        classes.addAll(this.getOperationClassNames(schema.getMutations()));
        classes.addAll(this.getOperationClassNames(schema.getGroupedMutations()));
        classes.addAll(this.getTypeClassNames(schema.getTypes().values()));
        classes.addAll(this.getInputClassNames(schema.getInputs().values()));
        classes.addAll(this.getInterfaceClassNames(schema.getInterfaces().values()));
        classes.addAll(this.getUnionClassNames(schema.getUnions().values()));
        classes.addAll(this.getDirectiveTypeClassNames(schema.getDirectiveTypes()));
        return (String[])classes.toArray(String[]::new);
    }

    private Class[] getGraphQLJavaClasses() {
        HashSet<Class<Collection>> classes = new HashSet<Class<Collection>>();
        classes.add(FieldCoordinates.class);
        classes.add(GraphQLArgument.class);
        classes.add(GraphQLCodeRegistry.class);
        classes.add(GraphQLEnumType.class);
        classes.add(GraphQLFieldDefinition.class);
        classes.add(GraphQLInputObjectField.class);
        classes.add(GraphQLInputObjectType.class);
        classes.add(GraphQLInputType.class);
        classes.add(GraphQLInterfaceType.class);
        classes.add(GraphQLUnionType.class);
        classes.add(GraphQLList.class);
        classes.add(GraphQLNonNull.class);
        classes.add(GraphQLObjectType.class);
        classes.add(GraphQLOutputType.class);
        classes.add(GraphQLScalarType.class);
        classes.add(GraphQLSchema.class);
        classes.add(GraphQLTypeReference.class);
        classes.add(List.class);
        classes.add(Collection.class);
        return (Class[])classes.toArray(Class[]::new);
    }

    private Set<String> getOperationClassNames(Set<Operation> operations) {
        HashSet<String> classes = new HashSet<String>();
        for (Operation operation : operations) {
            classes.add(operation.getClassName());
            for (Argument argument : operation.getArguments()) {
                classes.addAll(this.getAllReferenceClasses(argument.getReference()));
            }
            classes.addAll(this.getAllReferenceClasses(operation.getReference()));
        }
        return classes;
    }

    private Set<String> getOperationClassNames(Map<Group, Set<Operation>> groupedOperations) {
        HashSet<String> classes = new HashSet<String>();
        Collection<Set<Operation>> operations = groupedOperations.values();
        for (Set<Operation> operationSet : operations) {
            classes.addAll(this.getOperationClassNames(operationSet));
        }
        return classes;
    }

    private Set<String> getTypeClassNames(Collection<Type> complexGraphQLTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (Type complexGraphQLType : complexGraphQLTypes) {
            classes.add(complexGraphQLType.getClassName());
            classes.addAll(this.getFieldClassNames(complexGraphQLType.getFields()));
        }
        return classes;
    }

    private Set<String> getDirectiveTypeClassNames(Collection<DirectiveType> complexGraphQLDirectiveTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (DirectiveType complexGraphQLDirectiveType : complexGraphQLDirectiveTypes) {
            if (complexGraphQLDirectiveType.getClassName() == null) continue;
            classes.add(complexGraphQLDirectiveType.getClassName());
        }
        return classes;
    }

    private Set<String> getInputClassNames(Collection<InputType> complexGraphQLTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (InputType complexGraphQLType : complexGraphQLTypes) {
            classes.add(complexGraphQLType.getClassName());
            classes.addAll(this.getFieldClassNames(complexGraphQLType.getFields()));
        }
        return classes;
    }

    private Set<String> getInterfaceClassNames(Collection<Type> complexGraphQLTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (Type complexGraphQLType : complexGraphQLTypes) {
            classes.add(complexGraphQLType.getClassName());
            classes.addAll(this.getFieldClassNames(complexGraphQLType.getFields()));
        }
        return classes;
    }

    private Set<String> getUnionClassNames(Collection<UnionType> unionTypes) {
        HashSet<String> classes = new HashSet<String>();
        for (UnionType unionType : unionTypes) {
            classes.add(unionType.getClassName());
        }
        return classes;
    }

    private Set<String> getFieldClassNames(Map<String, Field> fields) {
        HashSet<String> classes = new HashSet<String>();
        for (Field field : fields.values()) {
            classes.addAll(this.getAllReferenceClasses(field.getReference()));
        }
        return classes;
    }

    private Set<String> getAllReferenceClasses(Reference reference) {
        HashSet<String> classes = new HashSet<String>();
        classes.add(reference.getClassName());
        if (reference.getClassParametrizedTypes() != null && !reference.getClassParametrizedTypes().isEmpty()) {
            Collection parametrized = reference.getClassParametrizedTypes().values();
            for (Reference r : parametrized) {
                classes.addAll(this.getAllReferenceClasses(r));
            }
        }
        return classes;
    }

    @BuildStep
    void printDataFetcherExceptionInDevMode(SmallRyeGraphQLConfig graphQLConfig, LaunchModeBuildItem launchMode, BuildProducer<SystemPropertyBuildItem> systemProperties) {
        if (!graphQLConfig.printDataFetcherException.isPresent()) {
            if (launchMode.getLaunchMode().isDevOrTest()) {
                systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.printDataFetcherException", TRUE));
            }
        } else {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.printDataFetcherException", String.valueOf(graphQLConfig.printDataFetcherException.get())));
        }
    }

    @BuildStep
    void activateMetrics(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability, SmallRyeGraphQLConfig graphQLConfig, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        if (graphQLConfig.metricsEnabled.orElse(false).booleanValue() || ((Boolean)Config.get().getConfigValue("smallrye.graphql.metrics.enabled", Boolean.TYPE, (Object)false)).booleanValue()) {
            metricsCapability.ifPresentOrElse(capability -> {
                if (capability.metricsSupported("micrometer")) {
                    serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.smallrye.graphql.spi.MetricsService", new String[]{"io.smallrye.graphql.cdi.metrics.MicrometerMetricsService"}));
                }
                if (capability.metricsSupported("smallrye-metrics")) {
                    serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.smallrye.graphql.spi.MetricsService", new String[]{"io.smallrye.graphql.cdi.metrics.MPMetricsService"}));
                }
            }, () -> LOG.warn((Object)"GraphQL metrics are enabled but no supported metrics implementation is available on the classpath"));
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.metrics.enabled", TRUE));
        } else {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.metrics.enabled", FALSE));
        }
    }

    @BuildStep
    void activateTracing(Capabilities capabilities, SmallRyeGraphQLConfig graphQLConfig, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        boolean activate = this.shouldActivateService(graphQLConfig.tracingEnabled, capabilities.isPresent("io.quarkus.opentelemetry.tracer"), "quarkus-opentelemetry", "io.quarkus.opentelemetry.tracer", "quarkus.smallrye-graphql.tracing.enabled", true);
        if (activate) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.tracing.enabled", TRUE));
        } else {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.tracing.enabled", FALSE));
        }
    }

    @BuildStep
    void activateEventing(SmallRyeGraphQLConfig graphQLConfig, BuildProducer<SystemPropertyBuildItem> systemProperties) {
        if (graphQLConfig.eventsEnabled) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.events.enabled", TRUE));
        } else {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.events.enabled", FALSE));
        }
    }

    void activateFederation(SmallRyeGraphQLConfig config, BuildProducer<SystemPropertyBuildItem> systemProperties, SmallRyeGraphQLFinalIndexBuildItem index) {
        if (config.federationEnabled.isPresent()) {
            String value = ((Boolean)config.federationEnabled.get()).toString();
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.federation.enabled", value));
            System.setProperty("smallrye.graphql.federation.enabled", value);
        } else {
            boolean foundAnyFederationAnnotation = false;
            for (ClassInfo federationAnnotationType : index.getFinalIndex().getClassesInPackage("io.smallrye.graphql.api.federation")) {
                if (!federationAnnotationType.isAnnotation() || index.getFinalIndex().getAnnotations(federationAnnotationType.name()).isEmpty()) continue;
                foundAnyFederationAnnotation = true;
            }
            String value = Boolean.toString(foundAnyFederationAnnotation);
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("smallrye.graphql.federation.enabled", value));
            System.setProperty("smallrye.graphql.federation.enabled", value);
        }
    }

    private boolean shouldActivateService(Optional<Boolean> serviceEnabled, boolean linkedCapabilityIsPresent, String linkedExtensionName, String linkedCapabilityName, String configKey, boolean activateByDefaultIfCapabilityIsPresent) {
        if (serviceEnabled.isPresent()) {
            boolean isEnabled = serviceEnabled.get();
            if (isEnabled && !linkedCapabilityIsPresent) {
                LOG.warnf(SERVICE_NOT_AVAILABLE_WARNING, (Object)configKey, (Object)linkedExtensionName, (Object)linkedCapabilityName);
            }
            return isEnabled && linkedCapabilityIsPresent;
        }
        return linkedCapabilityIsPresent && activateByDefaultIfCapabilityIsPresent;
    }

    @BuildStep
    void getGraphqlUiFinalDestination(HttpRootPathBuildItem httpRootPath, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, final LaunchModeBuildItem launchMode, SmallRyeGraphQLConfig graphQLConfig, BuildProducer<WebJarBuildItem> webJarBuildProducer) {
        if (SmallRyeGraphQLProcessor.shouldInclude(launchMode, graphQLConfig)) {
            if ("/".equals(graphQLConfig.ui.rootPath)) {
                throw new ConfigurationException("quarkus.smallrye-graphql.root-path-ui was set to \"/\", this is not allowed as it blocks the application from serving anything else.", Collections.singleton("quarkus.smallrye-graphql.root-path-ui"));
            }
            final String graphQLPath = httpRootPath.resolvePath(graphQLConfig.rootPath);
            final String graphQLUiPath = nonApplicationRootPathBuildItem.resolvePath(graphQLConfig.ui.rootPath);
            final String devUiPath = nonApplicationRootPathBuildItem.resolvePath("dev");
            webJarBuildProducer.produce((BuildItem)WebJarBuildItem.builder().artifactKey(GRAPHQL_UI_WEBJAR_ARTIFACT_KEY).root(GRAPHQL_UI_WEBJAR_STATIC_RESOURCES_PATH).filter(new WebJarResourcesFilter(){

                public WebJarResourcesFilter.FilterResult apply(String fileName, InputStream file) throws IOException {
                    if (fileName.endsWith(SmallRyeGraphQLProcessor.FILE_TO_UPDATE)) {
                        String content = new String(file.readAllBytes(), StandardCharsets.UTF_8);
                        content = SmallRyeGraphQLProcessor.this.updateUrl(content, graphQLPath, SmallRyeGraphQLProcessor.LINE_TO_UPDATE, SmallRyeGraphQLProcessor.LINE_FORMAT);
                        content = SmallRyeGraphQLProcessor.this.updateUrl(content, graphQLUiPath, SmallRyeGraphQLProcessor.UI_LINE_TO_UPDATE, SmallRyeGraphQLProcessor.UI_LINE_FORMAT);
                        content = SmallRyeGraphQLProcessor.this.updateUrl(content, SmallRyeGraphQLProcessor.this.getLogoUrl(launchMode, devUiPath, graphQLUiPath), SmallRyeGraphQLProcessor.LOGO_LINE_TO_UPDATE, SmallRyeGraphQLProcessor.LOGO_LINE_FORMAT);
                        return new WebJarResourcesFilter.FilterResult((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), true);
                    }
                    return new WebJarResourcesFilter.FilterResult(file, false);
                }
            }).build());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerGraphQLUiHandler(BuildProducer<RouteBuildItem> routeProducer, SmallRyeGraphQLRecorder recorder, SmallRyeGraphQLRuntimeConfig runtimeConfig, LaunchModeBuildItem launchMode, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeGraphQLConfig graphQLConfig, WebJarResultsBuildItem webJarResultsBuildItem, BuildProducer<SmallRyeGraphQLBuildItem> smallRyeGraphQLBuildProducer, ShutdownContextBuildItem shutdownContext) {
        WebJarResultsBuildItem.WebJarResult result = webJarResultsBuildItem.byArtifactKey(GRAPHQL_UI_WEBJAR_ARTIFACT_KEY);
        if (result == null) {
            return;
        }
        if (SmallRyeGraphQLProcessor.shouldInclude(launchMode, graphQLConfig)) {
            String graphQLUiPath = nonApplicationRootPathBuildItem.resolvePath(graphQLConfig.ui.rootPath);
            smallRyeGraphQLBuildProducer.produce((BuildItem)new SmallRyeGraphQLBuildItem(result.getFinalDestination(), graphQLUiPath));
            Handler handler = recorder.uiHandler(result.getFinalDestination(), graphQLUiPath, result.getWebRootConfigurations(), runtimeConfig, (ShutdownContext)shutdownContext);
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(graphQLConfig.ui.rootPath).displayOnNotFoundPage("GraphQL UI").routeConfigKey("quarkus.smallrye-graphql.ui.root-path").handler(handler).build());
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(graphQLConfig.ui.rootPath + "*").handler(handler).build());
        }
    }

    private String getLogoUrl(LaunchModeBuildItem launchMode, String devUIValue, String defaultValue) {
        if (launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT)) {
            return devUIValue;
        }
        return defaultValue;
    }

    private static boolean shouldInclude(LaunchModeBuildItem launchMode, SmallRyeGraphQLConfig graphQLConfig) {
        return launchMode.getLaunchMode().isDevOrTest() || graphQLConfig.ui.alwaysInclude;
    }

    private String updateUrl(String original, String path, String lineStartsWith, String format) {
        try (Scanner scanner = new Scanner(original);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.trim().startsWith(lineStartsWith)) continue;
                String newLine = String.format(format, path);
                String string = original.replace(line.trim(), newLine);
                return string;
            }
        }
        return original;
    }
}

