/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLAbstractHandler;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;

public class SmallRyeGraphQLExecutionHandler
extends SmallRyeGraphQLAbstractHandler {
    private boolean allowGet = false;
    private boolean allowPostWithQueryParameters = false;
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String EXTENSIONS = "extensions";
    private static final String APPLICATION_GRAPHQL = "application/graphql";
    private static final String OK = "OK";
    private static final JsonBuilderFactory jsonObjectFactory = Json.createBuilderFactory(null);
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);

    public SmallRyeGraphQLExecutionHandler(boolean allowGet, boolean allowPostWithQueryParameters, CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest) {
        super(currentIdentityAssociation, currentVertxRequest);
        this.allowGet = allowGet;
        this.allowPostWithQueryParameters = allowPostWithQueryParameters;
    }

    @Override
    protected void doHandle(RoutingContext ctx) {
        HttpServerRequest request = ctx.request();
        HttpServerResponse response = ctx.response();
        response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
        switch (request.method().name()) {
            case "OPTIONS": {
                this.handleOptions(response);
                break;
            }
            case "POST": {
                this.handlePost(response, ctx);
                break;
            }
            case "GET": {
                this.handleGet(response, ctx);
                break;
            }
            default: {
                ctx.next();
            }
        }
    }

    private void handleOptions(HttpServerResponse response) {
        response.headers().set(HttpHeaders.ALLOW, (CharSequence)this.getAllowedMethods());
        response.setStatusCode(200).setStatusMessage(OK).end();
    }

    private void handlePost(HttpServerResponse response, RoutingContext ctx) {
        try {
            String postResponse;
            JsonObject jsonObjectFromBody = this.getJsonObjectFromBody(ctx);
            if (this.hasQueryParameters(ctx) && this.allowPostWithQueryParameters) {
                JsonObject jsonObjectFromQueryParameters = this.getJsonObjectFromQueryParameters(ctx);
                JsonObject mergedJsonObject = Json.createMergePatch((JsonValue)jsonObjectFromQueryParameters).apply((JsonValue)jsonObjectFromBody).asJsonObject();
                postResponse = this.doRequest(mergedJsonObject);
            } else {
                postResponse = this.doRequest(jsonObjectFromBody);
            }
            response.setStatusCode(200).setStatusMessage(OK).end(Buffer.buffer((String)postResponse));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void handleGet(HttpServerResponse response, RoutingContext ctx) {
        if (this.allowGet) {
            try {
                JsonObject input = this.getJsonObjectFromQueryParameters(ctx);
                if (input.containsKey((Object)QUERY)) {
                    String getResponse = this.doRequest(input);
                    response.setStatusCode(200).setStatusMessage(OK).end(Buffer.buffer((String)getResponse));
                }
                response.setStatusCode(204).end();
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        } else {
            response.setStatusCode(405).end();
        }
    }

    private JsonObject getJsonObjectFromQueryParameters(RoutingContext ctx) throws UnsupportedEncodingException {
        String extensions;
        String variables;
        String operationName;
        JsonObjectBuilder input = Json.createObjectBuilder();
        String query = this.stripNewlinesAndTabs(this.readQueryParameter(ctx, QUERY));
        if (query != null && !query.isEmpty()) {
            input.add(QUERY, URLDecoder.decode(query, "UTF8"));
        }
        if ((operationName = this.readQueryParameter(ctx, OPERATION_NAME)) != null && !operationName.isEmpty()) {
            input.add(OPERATION_NAME, URLDecoder.decode(query, "UTF8"));
        }
        if ((variables = this.stripNewlinesAndTabs(this.readQueryParameter(ctx, VARIABLES))) != null && !variables.isEmpty()) {
            JsonObject jsonObject = SmallRyeGraphQLExecutionHandler.toJsonObject(URLDecoder.decode(variables, "UTF8"));
            input.add(VARIABLES, (JsonValue)jsonObject);
        }
        if ((extensions = this.stripNewlinesAndTabs(this.readQueryParameter(ctx, EXTENSIONS))) != null && !extensions.isEmpty()) {
            JsonObject jsonObject = SmallRyeGraphQLExecutionHandler.toJsonObject(URLDecoder.decode(extensions, "UTF8"));
            input.add(EXTENSIONS, (JsonValue)jsonObject);
        }
        return input.build();
    }

    private JsonObject getJsonObjectFromBody(RoutingContext ctx) throws IOException {
        String contentType = this.readContentType(ctx);
        String body = this.stripNewlinesAndTabs(this.readBody(ctx));
        if (contentType != null && contentType.startsWith(APPLICATION_GRAPHQL)) {
            JsonObjectBuilder input = Json.createObjectBuilder();
            input.add(QUERY, body);
            return input.build();
        }
        try (StringReader bodyReader = new StringReader(body);){
            JsonObject jsonObject;
            block12: {
                JsonReader jsonReader = jsonReaderFactory.createReader((Reader)bodyReader);
                try {
                    jsonObject = jsonReader.readObject();
                    if (jsonReader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return jsonObject;
        }
    }

    private String readBody(RoutingContext ctx) {
        if (ctx.getBody() != null) {
            byte[] bytes = ctx.getBody().getBytes();
            return new String(bytes);
        }
        return null;
    }

    private String readContentType(RoutingContext ctx) {
        String contentType = ctx.request().getHeader("Content-Type");
        if (contentType != null && !contentType.isEmpty()) {
            return contentType;
        }
        return null;
    }

    private String readQueryParameter(RoutingContext ctx, String parameterName) {
        List all = ctx.queryParam(parameterName);
        if (all != null && !all.isEmpty()) {
            return (String)all.get(0);
        }
        return null;
    }

    private String stripNewlinesAndTabs(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.replaceAll("\\n", " ").replaceAll("\\t", " ");
    }

    private boolean hasQueryParameters(RoutingContext ctx) {
        return this.hasQueryParameter(ctx, QUERY) || this.hasQueryParameter(ctx, OPERATION_NAME) || this.hasQueryParameter(ctx, VARIABLES) || this.hasQueryParameter(ctx, EXTENSIONS);
    }

    private boolean hasQueryParameter(RoutingContext ctx, String parameterName) {
        List all = ctx.queryParam(parameterName);
        return all != null && !all.isEmpty();
    }

    private String getAllowedMethods() {
        if (this.allowGet) {
            return "GET, POST, OPTIONS";
        }
        return "POST, OPTIONS";
    }

    private String doRequest(JsonObject jsonInput) {
        ExecutionResponse executionResponse = this.getExecutionService().execute(jsonInput);
        if (executionResponse != null) {
            return executionResponse.getExecutionResultAsString();
        }
        return null;
    }

    private static JsonObject toJsonObject(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        try (JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }
}

