/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SmallRyeGraphQLConfigMapping
extends RelocateConfigSourceInterceptor {
    private static final Map<String, String> RELOCATIONS = SmallRyeGraphQLConfigMapping.relocations();

    public SmallRyeGraphQLConfigMapping() {
        super(RELOCATIONS);
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = (String)namesIterator.next();
            names.add(name);
            String mappedName = RELOCATIONS.get(name);
            if (mappedName == null) continue;
            names.add(mappedName);
        }
        return names.iterator();
    }

    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        return context.iterateValues();
    }

    private static Map<String, String> relocations() {
        HashMap<String, String> relocations = new HashMap<String, String>();
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.errorExtensionFields", "quarkus.smallrye-graphql.error-extension-fields");
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "mp.graphql.defaultErrorMessage", "quarkus.smallrye-graphql.default-error-message");
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "mp.graphql.showErrorMessage", "quarkus.smallrye-graphql.show-runtime-exception-message");
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "mp.graphql.hideErrorMessage", "quarkus.smallrye-graphql.hide-checked-exception-message");
        return Collections.unmodifiableMap(relocations);
    }

    private static void mapKey(Map<String, String> map, String quarkusKey, String otherKey) {
        map.put(quarkusKey, otherKey);
        map.put(otherKey, quarkusKey);
    }
}

