/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLAbstractHandler;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class SmallRyeGraphQLExecutionHandler
extends SmallRyeGraphQLAbstractHandler {
    private boolean allowGet = false;
    private boolean allowPostWithQueryParameters = false;
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String EXTENSIONS = "extensions";
    private static final String APPLICATION_GRAPHQL = "application/graphql";
    private static final String OK = "OK";
    private static final String DEFAULT_RESPONSE_CONTENT_TYPE = "application/graphql+json; charset=" + StandardCharsets.UTF_8.name();
    private static final String DEFAULT_REQUEST_CONTENT_TYPE = "application/json; charset=" + StandardCharsets.UTF_8.name();
    private static final Pattern PATTERN_NEWLINE_OR_TAB = Pattern.compile("\\n|\\t");

    public SmallRyeGraphQLExecutionHandler(boolean allowGet, boolean allowPostWithQueryParameters, CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest) {
        super(currentIdentityAssociation, currentVertxRequest);
        this.allowGet = allowGet;
        this.allowPostWithQueryParameters = allowPostWithQueryParameters;
    }

    @Override
    protected void doHandle(RoutingContext ctx) {
        HttpServerRequest request = ctx.request();
        HttpServerResponse response = ctx.response();
        String accept = this.getRequestAccept(ctx);
        String requestedCharset = this.getCharset(accept);
        boolean isValid = this.isValidAcceptRequest(accept);
        if (!isValid) {
            this.handleInvalidAcceptRequest(response);
        } else {
            response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)accept);
            switch (request.method().name()) {
                case "OPTIONS": {
                    this.handleOptions(response);
                    break;
                }
                case "POST": {
                    this.handlePost(response, ctx, requestedCharset);
                    break;
                }
                case "GET": {
                    this.handleGet(response, ctx, requestedCharset);
                    break;
                }
                default: {
                    ctx.next();
                }
            }
        }
    }

    private void handleOptions(HttpServerResponse response) {
        response.headers().set(HttpHeaders.ALLOW, (CharSequence)this.getAllowedMethods());
        response.setStatusCode(200).setStatusMessage(OK).end();
    }

    private void handlePost(HttpServerResponse response, RoutingContext ctx, String requestedCharset) {
        try {
            String postResponse;
            JsonObject jsonObjectFromBody = this.getJsonObjectFromBody(ctx);
            if (this.hasQueryParameters(ctx) && this.allowPostWithQueryParameters) {
                JsonObject jsonObjectFromQueryParameters = this.getJsonObjectFromQueryParameters(ctx);
                JsonObject mergedJsonObject = Json.createMergePatch((JsonValue)jsonObjectFromQueryParameters).apply((JsonValue)jsonObjectFromBody).asJsonObject();
                postResponse = this.doRequest(mergedJsonObject);
            } else {
                postResponse = this.doRequest(jsonObjectFromBody);
            }
            response.setStatusCode(200).setStatusMessage(OK).end(Buffer.buffer((String)postResponse, (String)requestedCharset));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void handleGet(HttpServerResponse response, RoutingContext ctx, String requestedCharset) {
        if (this.allowGet) {
            try {
                JsonObject input = this.getJsonObjectFromQueryParameters(ctx);
                if (input.containsKey((Object)QUERY)) {
                    String getResponse = this.doRequest(input);
                    response.setStatusCode(200).setStatusMessage(OK).end(Buffer.buffer((String)getResponse, (String)requestedCharset));
                }
                response.setStatusCode(204).end();
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        } else {
            response.setStatusCode(405).end();
        }
    }

    private void handleInvalidAcceptRequest(HttpServerResponse response) {
        response.setStatusCode(406).end();
    }

    private JsonObject getJsonObjectFromQueryParameters(RoutingContext ctx) throws UnsupportedEncodingException {
        String extensions;
        String variables;
        String operationName;
        JsonObjectBuilder input = Json.createObjectBuilder();
        String query = SmallRyeGraphQLExecutionHandler.stripNewlinesAndTabs(this.readQueryParameter(ctx, QUERY));
        if (query != null && !query.isEmpty()) {
            input.add(QUERY, URLDecoder.decode(query, StandardCharsets.UTF_8.name()));
        }
        if ((operationName = this.readQueryParameter(ctx, OPERATION_NAME)) != null && !operationName.isEmpty()) {
            input.add(OPERATION_NAME, URLDecoder.decode(query, StandardCharsets.UTF_8.name()));
        }
        if ((variables = SmallRyeGraphQLExecutionHandler.stripNewlinesAndTabs(this.readQueryParameter(ctx, VARIABLES))) != null && !variables.isEmpty()) {
            JsonObject jsonObject = SmallRyeGraphQLExecutionHandler.toJsonObject(URLDecoder.decode(variables, StandardCharsets.UTF_8.name()));
            input.add(VARIABLES, (JsonValue)jsonObject);
        }
        if ((extensions = SmallRyeGraphQLExecutionHandler.stripNewlinesAndTabs(this.readQueryParameter(ctx, EXTENSIONS))) != null && !extensions.isEmpty()) {
            JsonObject jsonObject = SmallRyeGraphQLExecutionHandler.toJsonObject(URLDecoder.decode(extensions, StandardCharsets.UTF_8.name()));
            input.add(EXTENSIONS, (JsonValue)jsonObject);
        }
        return input.build();
    }

    private JsonObject getJsonObjectFromBody(RoutingContext ctx) throws IOException {
        String contentType = this.getRequestContentType(ctx);
        String body = SmallRyeGraphQLExecutionHandler.stripNewlinesAndTabs(this.readBody(ctx));
        if (contentType != null && contentType.startsWith(APPLICATION_GRAPHQL)) {
            JsonObjectBuilder input = Json.createObjectBuilder();
            input.add(QUERY, body);
            return input.build();
        }
        try (StringReader bodyReader = new StringReader(body);){
            JsonObject jsonObject;
            block12: {
                JsonReader jsonReader = jsonReaderFactory.createReader((Reader)bodyReader);
                try {
                    jsonObject = jsonReader.readObject();
                    if (jsonReader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return jsonObject;
        }
    }

    private String readBody(RoutingContext ctx) {
        if (ctx.getBody() != null) {
            return ctx.getBodyAsString();
        }
        return null;
    }

    private String getRequestContentType(RoutingContext ctx) {
        String contentType = ctx.request().getHeader("Content-Type");
        if (contentType != null && !contentType.isEmpty() && !contentType.startsWith("*/*")) {
            return contentType;
        }
        return DEFAULT_REQUEST_CONTENT_TYPE;
    }

    private String getRequestAccept(RoutingContext ctx) {
        String accept = ctx.request().getHeader("Accept");
        if (accept != null && !accept.isEmpty() && !accept.startsWith("*/*")) {
            return accept;
        }
        return DEFAULT_RESPONSE_CONTENT_TYPE;
    }

    private String getCharset(String mimeType) {
        if (mimeType != null && mimeType.contains(";")) {
            String[] parts;
            for (String part : parts = mimeType.split(";")) {
                if (!part.trim().startsWith("charset")) continue;
                return part.split("=")[1];
            }
        }
        return StandardCharsets.UTF_8.name();
    }

    private boolean isValidAcceptRequest(String mimeType) {
        return mimeType.startsWith("application/json") || mimeType.startsWith("application/graphql+json");
    }

    private String readQueryParameter(RoutingContext ctx, String parameterName) {
        List all = ctx.queryParam(parameterName);
        if (all != null && !all.isEmpty()) {
            return (String)all.get(0);
        }
        return null;
    }

    private static String stripNewlinesAndTabs(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return PATTERN_NEWLINE_OR_TAB.matcher(input).replaceAll(" ");
    }

    private boolean hasQueryParameters(RoutingContext ctx) {
        return this.hasQueryParameter(ctx, QUERY) || this.hasQueryParameter(ctx, OPERATION_NAME) || this.hasQueryParameter(ctx, VARIABLES) || this.hasQueryParameter(ctx, EXTENSIONS);
    }

    private boolean hasQueryParameter(RoutingContext ctx, String parameterName) {
        List all = ctx.queryParam(parameterName);
        return all != null && !all.isEmpty();
    }

    private String getAllowedMethods() {
        if (this.allowGet) {
            return "GET, POST, OPTIONS";
        }
        return "POST, OPTIONS";
    }

    private String doRequest(JsonObject jsonInput) {
        ExecutionResponse executionResponse = this.getExecutionService().execute(jsonInput);
        if (executionResponse != null) {
            return executionResponse.getExecutionResultAsString();
        }
        return null;
    }

    private static JsonObject toJsonObject(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        try (JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }
}

