/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime.spi.datafetcher;

import graphql.GraphQLError;
import graphql.execution.AbortExecutionException;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.quarkus.arc.Arc;
import io.quarkus.smallrye.graphql.runtime.spi.datafetcher.BlockingHelper;
import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.graphql.execution.datafetcher.DefaultDataFetcher;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.vertx.core.Context;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.graphql.GraphQLException;

public class QuarkusDefaultDataFetcher<K, T>
extends DefaultDataFetcher<K, T> {
    public QuarkusDefaultDataFetcher(Operation operation, Type type) {
        super(operation, type);
    }

    public <T> T invokeAndTransform(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws Exception {
        Context vc = Vertx.currentContext();
        if (this.runBlocking(dfe) || BlockingHelper.blockingShouldExecuteNonBlocking(this.operation, vc)) {
            return (T)super.invokeAndTransform(dfe, resultBuilder, transformedArguments);
        }
        return this.invokeAndTransformBlocking(dfe, resultBuilder, transformedArguments, vc);
    }

    public CompletionStage<List<T>> invokeBatch(DataFetchingEnvironment dfe, Object[] arguments) {
        Context vc = Vertx.currentContext();
        if (this.runBlocking(dfe) || BlockingHelper.blockingShouldExecuteNonBlocking(this.operation, vc)) {
            return super.invokeBatch(dfe, arguments);
        }
        return this.invokeBatchBlocking(arguments, vc);
    }

    private <T> T invokeAndTransformBlocking(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments, Context vc) throws Exception {
        SmallRyeThreadContext threadContext = (SmallRyeThreadContext)Arc.container().select(SmallRyeThreadContext.class, new Annotation[0]).get();
        Promise result = Promise.promise();
        Callable contextualCallable = threadContext.contextualCallable(() -> {
            try {
                Object resultFromMethodCall = this.operationInvoker.invoke(transformedArguments);
                Object resultFromTransform = this.fieldHelper.transformOrAdaptResponse(resultFromMethodCall, dfe);
                resultBuilder.data(resultFromTransform);
                return resultBuilder.build();
            }
            catch (AbstractDataFetcherException te) {
                te.appendDataFetcherResult(resultBuilder, dfe);
                return resultBuilder.build();
            }
            catch (GraphQLException graphQLException) {
                this.errorResultHelper.appendPartialResult(resultBuilder, dfe, graphQLException);
                return resultBuilder.build();
            }
            catch (Error e) {
                resultBuilder.clearErrors().data(null).error((GraphQLError)new AbortExecutionException((Throwable)e));
                return resultBuilder.build();
            }
        });
        BlockingHelper.runBlocking(vc, contextualCallable, result);
        return (T)result.future().toCompletionStage();
    }

    private CompletionStage<List<T>> invokeBatchBlocking(Object[] arguments, Context vc) {
        SmallRyeThreadContext threadContext = (SmallRyeThreadContext)Arc.container().select(SmallRyeThreadContext.class, new Annotation[0]).get();
        Promise result = Promise.promise();
        Callable contextualCallable = threadContext.contextualCallable(() -> (List)this.operationInvoker.invokePrivileged(arguments));
        BlockingHelper.runBlocking(vc, contextualCallable, result);
        return result.future().toCompletionStage();
    }

    private boolean runBlocking(DataFetchingEnvironment dfe) {
        return (Boolean)dfe.getGraphQlContext().get((Object)"runBlocking");
    }
}

