/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.graphql.execution.ExecutionService;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;

public abstract class SmallRyeGraphQLAbstractHandler
implements Handler<RoutingContext> {
    private final CurrentIdentityAssociation currentIdentityAssociation;
    private final CurrentVertxRequest currentVertxRequest;
    private final ManagedContext currentManagedContext;
    private final boolean runBlocking;
    private volatile ExecutionService executionService;
    protected static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);

    public SmallRyeGraphQLAbstractHandler(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest, boolean runBlocking) {
        this.currentIdentityAssociation = currentIdentityAssociation;
        this.currentVertxRequest = currentVertxRequest;
        this.currentManagedContext = Arc.container().requestContext();
        this.runBlocking = runBlocking;
    }

    public void handle(RoutingContext ctx) {
        if (this.currentManagedContext.isActive()) {
            this.handleWithIdentity(ctx);
        } else {
            this.currentManagedContext.activate();
            this.handleWithIdentity(ctx);
            ctx.response().bodyEndHandler(e -> this.currentManagedContext.terminate());
        }
    }

    private Void handleWithIdentity(RoutingContext ctx) {
        if (this.currentIdentityAssociation != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)ctx.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.currentIdentityAssociation.setIdentity(identity);
            } else {
                this.currentIdentityAssociation.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)ctx, null));
            }
        }
        this.currentVertxRequest.setCurrent(ctx);
        this.doHandle(ctx);
        return null;
    }

    protected abstract void doHandle(RoutingContext var1);

    protected JsonObject inputToJsonObject(String input) {
        try (JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(input));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }

    protected ExecutionService getExecutionService() {
        if (this.executionService == null) {
            this.executionService = (ExecutionService)Arc.container().instance(ExecutionService.class, new Annotation[0]).get();
        }
        return this.executionService;
    }

    protected Map<String, Object> getMetaData(RoutingContext ctx) {
        ConcurrentHashMap<String, Object> metaData = new ConcurrentHashMap<String, Object>();
        metaData.put("runBlocking", this.runBlocking);
        metaData.put("httpHeaders", this.getHeaders(ctx));
        return metaData;
    }

    private Map<String, List<String>> getHeaders(RoutingContext ctx) {
        HashMap<String, List<String>> h = new HashMap<String, List<String>>();
        MultiMap headers = ctx.request().headers();
        for (String header : headers.names()) {
            h.put(header, headers.getAll(header));
        }
        return h;
    }
}

