/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLAbstractHandler;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.graphql.websocket.GraphQLWebsocketHandler;
import io.smallrye.graphql.websocket.graphqltransportws.GraphQLTransportWSSubprotocolHandler;
import io.smallrye.graphql.websocket.graphqlws.GraphQLWSSubprotocolHandler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import org.jboss.logging.Logger;

public class SmallRyeGraphQLOverWebSocketHandler
extends SmallRyeGraphQLAbstractHandler {
    private static final Logger log = Logger.getLogger(SmallRyeGraphQLOverWebSocketHandler.class);

    public SmallRyeGraphQLOverWebSocketHandler(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest, boolean runBlocking) {
        super(currentIdentityAssociation, currentVertxRequest, runBlocking);
    }

    @Override
    protected void doHandle(RoutingContext ctx) {
        if (ctx.request().headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true) && !ctx.request().isEnded()) {
            ctx.request().toWebSocket(event -> {
                if (event.succeeded()) {
                    ServerWebSocket serverWebSocket = (ServerWebSocket)event.result();
                    String subprotocol = serverWebSocket.subProtocol();
                    GraphQLTransportWSSubprotocolHandler handler = null;
                    switch (subprotocol) {
                        case "graphql-transport-ws": {
                            handler = new GraphQLTransportWSSubprotocolHandler((GraphQLWebSocketSession)new QuarkusVertxWebSocketSession(serverWebSocket), this.getMetaData(ctx));
                            break;
                        }
                        case "graphql-ws": {
                            handler = new GraphQLWSSubprotocolHandler((GraphQLWebSocketSession)new QuarkusVertxWebSocketSession(serverWebSocket), this.getMetaData(ctx));
                            break;
                        }
                        default: {
                            log.warn((Object)("Unknown graphql-over-websocket protocol: " + subprotocol));
                            serverWebSocket.close();
                            return;
                        }
                    }
                    log.debug((Object)("Starting websocket with subprotocol = " + subprotocol));
                    GraphQLTransportWSSubprotocolHandler finalHandler = handler;
                    serverWebSocket.closeHandler(arg_0 -> SmallRyeGraphQLOverWebSocketHandler.lambda$doHandle$0((GraphQLWebsocketHandler)finalHandler, arg_0));
                    serverWebSocket.endHandler(arg_0 -> SmallRyeGraphQLOverWebSocketHandler.lambda$doHandle$1((GraphQLWebsocketHandler)finalHandler, arg_0));
                    serverWebSocket.exceptionHandler(arg_0 -> SmallRyeGraphQLOverWebSocketHandler.lambda$doHandle$2((GraphQLWebsocketHandler)finalHandler, arg_0));
                    serverWebSocket.textMessageHandler(arg_0 -> SmallRyeGraphQLOverWebSocketHandler.lambda$doHandle$3((GraphQLWebsocketHandler)finalHandler, arg_0));
                } else {
                    log.warn((Object)"WebSocket failed", event.cause());
                }
            });
        } else {
            ctx.next();
        }
    }

    private static /* synthetic */ void lambda$doHandle$3(GraphQLWebsocketHandler finalHandler, String m) {
        finalHandler.onMessage(m);
    }

    private static /* synthetic */ void lambda$doHandle$2(GraphQLWebsocketHandler finalHandler, Throwable t) {
        finalHandler.onThrowable(t);
    }

    private static /* synthetic */ void lambda$doHandle$1(GraphQLWebsocketHandler finalHandler, Void v) {
        finalHandler.onEnd();
    }

    private static /* synthetic */ void lambda$doHandle$0(GraphQLWebsocketHandler finalHandler, Void v) {
        finalHandler.onClose();
    }

    private static class QuarkusVertxWebSocketSession
    implements GraphQLWebSocketSession {
        private final ServerWebSocket webSocket;
        private final String peer;

        QuarkusVertxWebSocketSession(ServerWebSocket webSocket) {
            this.webSocket = webSocket;
            this.peer = webSocket.remoteAddress() != null ? webSocket.remoteAddress().host() + ":" + webSocket.remoteAddress().port() : "unknown";
        }

        public void sendMessage(String message) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(">>> " + message));
            }
            this.webSocket.writeTextMessage(message);
        }

        public void close(short statusCode, String reason) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing graphql websocket connection with code=" + statusCode + " and reason " + reason));
            }
            this.webSocket.close(statusCode, reason);
        }

        public boolean isClosed() {
            return this.webSocket.isClosed();
        }

        public String toString() {
            return "{peer=" + this.peer + "}";
        }
    }
}

