/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolverContext;

@Singleton
public class SmallRyeGraphQLLocaleResolver
implements LocaleResolver {
    private static final String ACCEPT_HEADER = "Accept-Language";

    public Locale resolve(LocaleResolverContext context) {
        Optional<List<Locale.LanguageRange>> localePriorities = this.getAcceptableLanguages();
        if (!localePriorities.isPresent()) {
            return null;
        }
        List<Locale> resolvedLocales = Locale.filter(localePriorities.get(), context.getSupportedLocales());
        if (!resolvedLocales.isEmpty()) {
            return resolvedLocales.get(0);
        }
        return null;
    }

    private Optional<List<Locale.LanguageRange>> getAcceptableLanguages() {
        List<String> acceptLanguageList;
        Map<String, List<String>> httpHeaders = this.getHeaders();
        if (httpHeaders != null && (acceptLanguageList = httpHeaders.get(ACCEPT_HEADER)) != null && !acceptLanguageList.isEmpty()) {
            return Optional.of(Locale.LanguageRange.parse(acceptLanguageList.get(0)));
        }
        return Optional.empty();
    }

    private Map<String, List<String>> getHeaders() {
        SmallRyeContext smallRyeContext = SmallRyeContextManager.getCurrentSmallRyeContext();
        if (smallRyeContext != null) {
            DataFetchingEnvironment dfe = (DataFetchingEnvironment)smallRyeContext.unwrap(DataFetchingEnvironment.class);
            return (Map)dfe.getGraphQlContext().get((Object)"httpHeaders");
        }
        return null;
    }
}

