/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import graphql.ExecutionResult;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLAbstractHandler;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.JsonObject;
import org.jboss.logging.Logger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SmallRyeGraphQLSubscriptionHandler
extends SmallRyeGraphQLAbstractHandler {
    private static final Logger log = Logger.getLogger(SmallRyeGraphQLSubscriptionHandler.class);
    private final ConcurrentHashMap<String, AtomicReference<Subscription>> subscriptionRefs = new ConcurrentHashMap();

    public SmallRyeGraphQLSubscriptionHandler(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest) {
        super(currentIdentityAssociation, currentVertxRequest);
    }

    @Override
    protected void doHandle(RoutingContext ctx) {
        if (ctx.request().headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true) && !ctx.request().isEnded()) {
            ctx.request().toWebSocket((Handler)new SmallRyeWebSocketHandler());
        } else {
            ctx.next();
        }
    }

    public void unsubscribe(String textHandlerId) {
        AtomicReference<Subscription> subscription = this.subscriptionRefs.get(textHandlerId);
        this.subscriptionRefs.remove(textHandlerId);
        if (subscription != null && subscription.get() != null) {
            Subscriptions.cancel(subscription);
            subscription.set(null);
        }
    }

    private class SmallRyeGraphQLSubscriptionSubscriber
    implements Subscriber<ExecutionResult> {
        private final ServerWebSocket serverWebSocket;
        private final String textHandlerId;

        public SmallRyeGraphQLSubscriptionSubscriber(ServerWebSocket serverWebSocket) {
            this.serverWebSocket = serverWebSocket;
            this.textHandlerId = serverWebSocket.textHandlerID();
        }

        public void onSubscribe(Subscription s) {
            AtomicReference<Subscription> subRef = SmallRyeGraphQLSubscriptionHandler.this.subscriptionRefs.get(this.serverWebSocket.textHandlerID());
            if (subRef == null) {
                subRef = new AtomicReference<Subscription>(s);
                SmallRyeGraphQLSubscriptionHandler.this.subscriptionRefs.put(this.textHandlerId, subRef);
                s.request(1L);
                return;
            }
            if (subRef.compareAndSet(null, s)) {
                s.request(1L);
            } else {
                s.cancel();
            }
        }

        public void onNext(ExecutionResult executionResult) {
            if (this.serverWebSocket != null && !this.serverWebSocket.isClosed()) {
                ExecutionResponse executionResponse = new ExecutionResponse(executionResult);
                this.serverWebSocket.writeTextMessage(executionResponse.getExecutionResultAsString());
                Subscription s = SmallRyeGraphQLSubscriptionHandler.this.subscriptionRefs.get(this.textHandlerId).get();
                s.request(1L);
            } else {
                SmallRyeGraphQLSubscriptionHandler.this.unsubscribe(this.textHandlerId);
            }
        }

        public void onError(Throwable thrwbl) {
            log.error((Object)"Error in GraphQL Subscription Websocket", thrwbl);
            SmallRyeGraphQLSubscriptionHandler.this.unsubscribe(this.serverWebSocket.textHandlerID());
            this.closeWebSocket();
        }

        public void onComplete() {
            SmallRyeGraphQLSubscriptionHandler.this.unsubscribe(this.serverWebSocket.textHandlerID());
            this.closeWebSocket();
        }

        public void closeWebSocket() {
            if (!this.serverWebSocket.isClosed()) {
                this.serverWebSocket.close();
            }
        }
    }

    private class TextMessageHandler
    implements Handler<String> {
        private final SmallRyeGraphQLSubscriptionSubscriber smallRyeGraphQLSubscriptionSubscriber;

        TextMessageHandler(ServerWebSocket serverWebSocket) {
            this.smallRyeGraphQLSubscriptionSubscriber = new SmallRyeGraphQLSubscriptionSubscriber(serverWebSocket);
        }

        public void handle(String message) {
            JsonObject jsonInput = SmallRyeGraphQLSubscriptionHandler.this.inputToJsonObject(message);
            ExecutionResponse executionResponse = SmallRyeGraphQLSubscriptionHandler.this.getExecutionService().execute(jsonInput);
            ExecutionResult executionResult = executionResponse.getExecutionResult();
            if (executionResult != null) {
                if (executionResult.getErrors() != null && !executionResult.getErrors().isEmpty()) {
                    this.smallRyeGraphQLSubscriptionSubscriber.onNext(executionResult);
                    this.smallRyeGraphQLSubscriptionSubscriber.closeWebSocket();
                } else {
                    Publisher stream = (Publisher)executionResponse.getExecutionResult().getData();
                    if (stream != null) {
                        stream.subscribe((Subscriber)this.smallRyeGraphQLSubscriptionSubscriber);
                    }
                }
            }
        }
    }

    private class ExceptionHandler
    implements Handler<Throwable> {
        String socketId;

        public ExceptionHandler(String socketId) {
            this.socketId = socketId;
        }

        public void handle(Throwable e) {
            log.error((Object)e.getMessage());
            SmallRyeGraphQLSubscriptionHandler.this.unsubscribe(this.socketId);
        }
    }

    private class EndHandler
    implements Handler<Void> {
        String socketId;

        public EndHandler(String socketId) {
            this.socketId = socketId;
        }

        public void handle(Void e) {
            SmallRyeGraphQLSubscriptionHandler.this.unsubscribe(this.socketId);
        }
    }

    private class CloseHandler
    implements Handler<Void> {
        String socketId;

        public CloseHandler(String socketId) {
            this.socketId = socketId;
        }

        public void handle(Void e) {
            SmallRyeGraphQLSubscriptionHandler.this.unsubscribe(this.socketId);
        }
    }

    private class SmallRyeWebSocketHandler
    implements Handler<AsyncResult<ServerWebSocket>> {
        private SmallRyeWebSocketHandler() {
        }

        public void handle(AsyncResult<ServerWebSocket> event) {
            if (event.succeeded()) {
                ServerWebSocket serverWebSocket = (ServerWebSocket)event.result();
                serverWebSocket.closeHandler((Handler)new CloseHandler(((ServerWebSocket)event.result()).textHandlerID()));
                serverWebSocket.endHandler((Handler)new EndHandler(((ServerWebSocket)event.result()).textHandlerID()));
                serverWebSocket.exceptionHandler((Handler)new ExceptionHandler(((ServerWebSocket)event.result()).textHandlerID()));
                serverWebSocket.textMessageHandler((Handler)new TextMessageHandler(serverWebSocket));
            }
        }
    }
}

