/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SmallRyeGraphQLConfigMapping
extends RelocateConfigSourceInterceptor {
    private static final Map<String, String> RELOCATIONS = SmallRyeGraphQLConfigMapping.relocations();
    private static final String SHOW_ERROR_MESSAGE = "mp.graphql.showErrorMessage";
    private static final String HIDE_ERROR_MESSAGE = "mp.graphql.hideErrorMessage";
    private static final String QUARKUS_ERROR_EXTENSION_FIELDS = "quarkus.smallrye-graphql.error-extension-fields";
    private static final String QUARKUS_DEFAULT_ERROR_MESSAGE = "quarkus.smallrye-graphql.default-error-message";
    private static final String QUARKUS_SHOW_ERROR_MESSAGE = "quarkus.smallrye-graphql.show-runtime-exception-message";
    private static final String QUARKUS_HIDE_ERROR_MESSAGE = "quarkus.smallrye-graphql.hide-checked-exception-message";
    private static final String QUARKUS_HTTP_GET_ENABLED = "quarkus.smallrye-graphql.http.get.enabled";
    private static final String QUARKUS_HTTP_POST_QUERYPARAMETERS_ENABLED = "quarkus.smallrye-graphql.http.post.queryparameters.enabled";
    private static final String QUARKUS_PRINT_DATAFETCHER_EXCEPTION = "quarkus.smallrye-graphql.print-data-fetcher-exception";
    private static final String QUARKUS_SCHEMA_INCLUDE_SCALARS = "quarkus.smallrye-graphql.schema-include-scalars";
    private static final String QUARKUS_SCHEMA_INCLUDE_DEFINITION = "quarkus.smallrye-graphql.schema-include-schema-definition";
    private static final String QUARKUS_SCHEMA_INCLUDE_DIRECTIVES = "quarkus.smallrye-graphql.schema-include-directives";
    private static final String QUARKUS_SCHEMA_INCLUDE_INTROSPECTION_TYPES = "quarkus.smallrye-graphql.schema-include-introspection-types";
    private static final String QUARKUS_LOG_PAYLOAD = "quarkus.smallrye-graphql.log-payload";
    private static final String QUARKUS_FIELD_VISIBILITY = "quarkus.smallrye-graphql.field-visibility";
    private static final String QUARKUS_UNWRAP_EXCEPTIONS = "quarkus.smallrye-graphql.unwrap-exceptions";

    public SmallRyeGraphQLConfigMapping() {
        super(RELOCATIONS);
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = (String)namesIterator.next();
            names.add(name);
            String mappedName = RELOCATIONS.get(name);
            if (mappedName == null) continue;
            names.add(mappedName);
        }
        return names.iterator();
    }

    private static Map<String, String> relocations() {
        HashMap<String, String> relocations = new HashMap<String, String>();
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.allowGet", QUARKUS_HTTP_GET_ENABLED);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.allowPostWithQueryParameters", QUARKUS_HTTP_POST_QUERYPARAMETERS_ENABLED);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.errorExtensionFields", QUARKUS_ERROR_EXTENSION_FIELDS);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "mp.graphql.defaultErrorMessage", QUARKUS_DEFAULT_ERROR_MESSAGE);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.schema.includeScalars", QUARKUS_SCHEMA_INCLUDE_SCALARS);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.schema.includeSchemaDefinition", QUARKUS_SCHEMA_INCLUDE_DEFINITION);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.schema.includeDirectives", QUARKUS_SCHEMA_INCLUDE_DIRECTIVES);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.schema.includeIntrospectionTypes", QUARKUS_SCHEMA_INCLUDE_INTROSPECTION_TYPES);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.logPayload", QUARKUS_LOG_PAYLOAD);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.fieldVisibility", QUARKUS_FIELD_VISIBILITY);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, "smallrye.graphql.unwrapExceptions", QUARKUS_UNWRAP_EXCEPTIONS);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, SHOW_ERROR_MESSAGE, QUARKUS_SHOW_ERROR_MESSAGE);
        SmallRyeGraphQLConfigMapping.mapKey(relocations, HIDE_ERROR_MESSAGE, QUARKUS_HIDE_ERROR_MESSAGE);
        return Collections.unmodifiableMap(relocations);
    }

    private static void mapKey(Map<String, String> map, String quarkusKey, String otherKey) {
        map.put(quarkusKey, otherKey);
        map.put(otherKey, quarkusKey);
    }
}

