/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.graphql.execution.ExecutionService;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;

public abstract class SmallRyeGraphQLAbstractHandler
implements Handler<RoutingContext> {
    private final CurrentIdentityAssociation currentIdentityAssociation;
    private final CurrentVertxRequest currentVertxRequest;
    private volatile ExecutionService executionService;
    protected static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);

    public SmallRyeGraphQLAbstractHandler(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest) {
        this.currentIdentityAssociation = currentIdentityAssociation;
        this.currentVertxRequest = currentVertxRequest;
    }

    public void handle(RoutingContext ctx) {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            this.handleWithIdentity(ctx);
        } else {
            try {
                requestContext.activate();
                this.handleWithIdentity(ctx);
            }
            finally {
                requestContext.terminate();
            }
        }
    }

    private void handleWithIdentity(RoutingContext ctx) {
        if (this.currentIdentityAssociation != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)ctx.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.currentIdentityAssociation.setIdentity(identity);
            } else {
                this.currentIdentityAssociation.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)ctx, null));
            }
        }
        this.currentVertxRequest.setCurrent(ctx);
        this.doHandle(ctx);
    }

    protected abstract void doHandle(RoutingContext var1);

    protected JsonObject inputToJsonObject(String input) {
        try (JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(input));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }

    protected ExecutionService getExecutionService() {
        if (this.executionService == null) {
            this.executionService = (ExecutionService)Arc.container().instance(ExecutionService.class, new Annotation[0]).get();
        }
        return this.executionService;
    }
}

