/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import graphql.schema.GraphQLSchema;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLExecutionHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLNoEndpointHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLOverWebSocketHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLRuntimeConfig;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLSchemaHandler;
import io.quarkus.smallrye.graphql.runtime.spi.QuarkusClassloadingService;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarNotFoundHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarStaticHandler;
import io.smallrye.graphql.cdi.producer.GraphQLProducer;
import io.smallrye.graphql.schema.model.Schema;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;

@Recorder
public class SmallRyeGraphQLRecorder {
    public RuntimeValue<Boolean> createExecutionService(BeanContainer beanContainer, Schema schema) {
        GraphQLProducer graphQLProducer = (GraphQLProducer)beanContainer.instance(GraphQLProducer.class, new Annotation[0]);
        GraphQLSchema graphQLSchema = graphQLProducer.initialize(schema);
        return new RuntimeValue((Object)(graphQLSchema != null ? 1 : 0));
    }

    public Handler<RoutingContext> executionHandler(RuntimeValue<Boolean> initialized, boolean allowGet, boolean allowPostWithQueryParameters) {
        if (((Boolean)initialized.getValue()).booleanValue()) {
            return new SmallRyeGraphQLExecutionHandler(allowGet, allowPostWithQueryParameters, this.getCurrentIdentityAssociation(), (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get());
        }
        return new SmallRyeGraphQLNoEndpointHandler();
    }

    public Handler<RoutingContext> graphqlOverWebsocketHandler(BeanContainer beanContainer, RuntimeValue<Boolean> initialized) {
        return new SmallRyeGraphQLOverWebSocketHandler(this.getCurrentIdentityAssociation(), (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get());
    }

    public Handler<RoutingContext> schemaHandler(RuntimeValue<Boolean> initialized, boolean schemaAvailable) {
        if (((Boolean)initialized.getValue()).booleanValue() && schemaAvailable) {
            return new SmallRyeGraphQLSchemaHandler();
        }
        return new SmallRyeGraphQLNoEndpointHandler();
    }

    public Handler<RoutingContext> uiHandler(String graphqlUiFinalDestination, String graphqlUiPath, List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations, SmallRyeGraphQLRuntimeConfig runtimeConfig, ShutdownContext shutdownContext) {
        if (runtimeConfig.enable) {
            WebJarStaticHandler handler = new WebJarStaticHandler(graphqlUiFinalDestination, graphqlUiPath, webRootConfigurations);
            shutdownContext.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable((Closeable)handler));
            return handler;
        }
        return new WebJarNotFoundHandler();
    }

    public void setupClDevMode(ShutdownContext shutdownContext) {
        QuarkusClassloadingService.setClassLoader(Thread.currentThread().getContextClassLoader());
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusClassloadingService.setClassLoader(null);
            }
        });
    }

    public Consumer<Route> routeFunction(final Handler<RoutingContext> bodyHandler) {
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.handler(bodyHandler);
            }
        };
    }

    private CurrentIdentityAssociation getCurrentIdentityAssociation() {
        Instance identityAssociations = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        if (identityAssociations.isResolvable()) {
            return (CurrentIdentityAssociation)identityAssociations.get();
        }
        return null;
    }
}

