/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.smallrye.graphql.runtime.SmallRyeAuthGraphQLWSHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLAbstractHandler;
import io.quarkus.smallrye.graphql.runtime.exception.SmallRyeAuthSecurityIdentityAlreadyAssignedException;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.graphql.websocket.graphqlws.GraphQLWSSubprotocolHandler;
import io.vertx.ext.web.RoutingContext;
import jakarta.json.JsonObject;
import java.util.Map;
import java.util.Optional;

public class SmallRyeAuthGraphQLWSSubprotocolHandler
extends GraphQLWSSubprotocolHandler {
    private final SmallRyeAuthGraphQLWSHandler authHander;

    public SmallRyeAuthGraphQLWSSubprotocolHandler(GraphQLWebSocketSession session, Map<String, Object> context, RoutingContext ctx, SmallRyeGraphQLAbstractHandler handler, Optional<String> authorizationClientInitPayloadName) {
        super(session, context);
        this.authHander = new SmallRyeAuthGraphQLWSHandler(session, ctx, handler, authorizationClientInitPayloadName);
    }

    protected void onMessage(JsonObject message) {
        if (message != null && message.getString("type").equals("connection_init")) {
            Map payload = (Map)message.get((Object)"payload");
            this.authHander.handlePayload(payload, () -> super.onMessage(message), failure -> {
                if (!this.session.isClosed()) {
                    if (failure instanceof SmallRyeAuthSecurityIdentityAlreadyAssignedException) {
                        this.session.close((short)4400, "Authorization specified in multiple locations");
                    } else {
                        this.session.close((short)4403, "Forbidden");
                    }
                }
            });
        } else {
            super.onMessage(message);
        }
    }

    public void onClose() {
        super.onClose();
        this.authHander.cancelAuthExpiry();
    }
}

