/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime.spi.datafetcher;

import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.smallrye.graphql.schema.model.Execute;
import io.smallrye.graphql.schema.model.Operation;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public final class BlockingHelper {
    private BlockingHelper() {
    }

    public static boolean blockingShouldExecuteNonBlocking(Operation operation, Context vc) {
        return operation.getExecute().equals((Object)Execute.NON_BLOCKING);
    }

    public static boolean nonBlockingShouldExecuteBlocking(Operation operation, Context vc) {
        return operation.getExecute().equals((Object)Execute.BLOCKING) && vc.isEventLoopContext();
    }

    public static boolean shouldUseVirtualThread(Operation operation, Context vc) {
        return operation.getExecute().equals((Object)Execute.RUN_ON_VIRTUAL_THREAD);
    }

    public static void runBlocking(Context vc, Callable<Object> contextualCallable, Promise result, Operation operation) {
        if (BlockingHelper.shouldUseVirtualThread(operation, vc)) {
            ExecutorService virtualThreadsExecutor = VirtualThreadsRecorder.getCurrent();
            virtualThreadsExecutor.submit(() -> {
                try {
                    Object value = contextualCallable.call();
                    result.complete(value);
                }
                catch (Throwable t) {
                    result.fail(t);
                }
            });
        } else {
            vc.executeBlocking(contextualCallable).onComplete((Handler)result);
        }
    }
}

