/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.jsonp.JsonProviderHolder;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SmallRyeGraphQLAbstractHandler
implements Handler<RoutingContext> {
    private final CurrentIdentityAssociation currentIdentityAssociation;
    private final CurrentVertxRequest currentVertxRequest;
    private final ManagedContext currentManagedContext;
    private final Handler<Void> currentManagedContextTerminationHandler;
    private final Handler<Throwable> currentManagedContextExceptionHandler;
    private final boolean runBlocking;
    private volatile ExecutionService executionService;
    protected static final JsonReaderFactory jsonReaderFactory = JsonProviderHolder.jsonProvider().createReaderFactory(null);

    public SmallRyeGraphQLAbstractHandler(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest, boolean runBlocking) {
        this.currentIdentityAssociation = currentIdentityAssociation;
        this.currentVertxRequest = currentVertxRequest;
        this.currentManagedContext = Arc.container().requestContext();
        this.runBlocking = runBlocking;
        this.currentManagedContextTerminationHandler = this.createCurrentManagedContextTerminationHandler();
        this.currentManagedContextExceptionHandler = this.createCurrentManagedContextTerminationHandler();
    }

    private <T> Handler<T> createCurrentManagedContextTerminationHandler() {
        return new Handler<T>(){

            public void handle(Object e) {
                SmallRyeGraphQLAbstractHandler.this.terminate();
            }
        };
    }

    public void handle(RoutingContext ctx) {
        ctx.response().endHandler(this.currentManagedContextTerminationHandler).exceptionHandler(this.currentManagedContextExceptionHandler).closeHandler(this.currentManagedContextTerminationHandler);
        if (!this.currentManagedContext.isActive()) {
            this.currentManagedContext.activate();
        }
        try {
            this.handleWithIdentity(ctx);
            this.deactivate();
        }
        catch (Throwable t) {
            this.terminate();
            throw t;
        }
    }

    private void handleWithIdentity(RoutingContext ctx) {
        this.withIdentity(ctx);
        this.doHandle(ctx);
    }

    void withIdentity(RoutingContext ctx) {
        if (this.currentIdentityAssociation != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)ctx.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.currentIdentityAssociation.setIdentity(identity);
            } else {
                this.currentIdentityAssociation.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)ctx, null));
            }
        }
        this.currentVertxRequest.setCurrent(ctx);
    }

    protected abstract void doHandle(RoutingContext var1);

    protected JsonObject inputToJsonObject(String input) {
        try (JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(input));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }

    protected ExecutionService getExecutionService() {
        if (this.executionService == null) {
            this.executionService = (ExecutionService)Arc.container().instance(ExecutionService.class, new Annotation[0]).get();
        }
        return this.executionService;
    }

    protected Map<String, Object> getMetaData(RoutingContext ctx) {
        ConcurrentHashMap<String, Object> metaData = new ConcurrentHashMap<String, Object>();
        metaData.put("runBlocking", this.runBlocking);
        metaData.put("httpHeaders", this.getHeaders(ctx));
        InjectableContext.ContextState state = this.currentManagedContext.getState();
        metaData.put("state", state);
        return metaData;
    }

    private Map<String, List<String>> getHeaders(RoutingContext ctx) {
        HashMap<String, List<String>> h = new HashMap<String, List<String>>();
        MultiMap headers = ctx.request().headers();
        for (String header : headers.names()) {
            h.put(header, headers.getAll(header));
        }
        return h;
    }

    private void deactivate() {
        SmallRyeContextManager.clearCurrentSmallRyeContext();
        this.currentManagedContext.deactivate();
    }

    private void terminate() {
        SmallRyeContextManager.clearCurrentSmallRyeContext();
        this.currentManagedContext.terminate();
    }
}

