/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime.spi.datafetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.smallrye.graphql.runtime.spi.datafetcher.RequestContextHelper;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.graphql.validation.BeanValidationUtil;
import io.smallrye.mutiny.Uni;
import jakarta.validation.ConstraintViolationException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.graphql.GraphQLException;

public abstract class AbstractAsyncDataFetcher<K, T>
extends AbstractDataFetcher<K, T> {
    public AbstractAsyncDataFetcher(Operation operation, Type type) {
        super(operation, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <O> O invokeAndTransform(Context c, DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws Exception {
        ManagedContext requestContext = Arc.container().requestContext();
        try {
            this.measurementIds.add(this.metricsEmitter.start(c));
            RequestContextHelper.reactivate(requestContext, dfe);
            Uni<?> uni = this.handleUserMethodCall(dfe, transformedArguments);
            CompletableFuture completableFuture = uni.onItemOrFailure().transformToUni((result, throwable, emitter) -> {
                emitter.onTermination(() -> this.deactivate(requestContext));
                if (throwable != null) {
                    this.eventEmitter.fireOnDataFetchError(c, throwable);
                    if (throwable instanceof GraphQLException) {
                        GraphQLException graphQLException = (GraphQLException)((Object)throwable);
                        this.errorResultHelper.appendPartialResult(resultBuilder, dfe, graphQLException);
                    } else if (throwable instanceof ConstraintViolationException) {
                        BeanValidationUtil.addConstraintViolationsToDataFetcherResult((Set)((ConstraintViolationException)((Object)throwable)).getConstraintViolations(), (Method)this.operationInvoker.getMethod(), (DataFetcherResult.Builder)resultBuilder, (DataFetchingEnvironment)dfe);
                    } else {
                        if (throwable instanceof Exception) {
                            emitter.fail((Throwable)SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, throwable));
                            return;
                        }
                        if (throwable instanceof Error) {
                            emitter.fail(throwable);
                            return;
                        }
                    }
                } else {
                    try {
                        resultBuilder.data(this.fieldHelper.transformOrAdaptResponse(result, dfe));
                    }
                    catch (AbstractDataFetcherException te) {
                        te.appendDataFetcherResult(resultBuilder, dfe);
                    }
                    finally {
                        this.eventEmitter.fireAfterDataFetch(c);
                        this.metricsEmitter.end((Long)this.measurementIds.remove());
                    }
                }
                emitter.complete((Object)resultBuilder.build());
            }).onCancellation().invoke(() -> this.deactivate(requestContext)).onTermination().invoke(() -> this.deactivate(requestContext)).subscribe().asCompletionStage();
            return (O)completableFuture;
        }
        finally {
            this.deactivate(requestContext);
        }
    }

    private void deactivate(ManagedContext requestContext) {
        SmallRyeContextManager.clearCurrentSmallRyeContext();
        requestContext.deactivate();
    }

    protected abstract Uni<?> handleUserMethodCall(DataFetchingEnvironment var1, Object[] var2) throws Exception;

    protected <O> O invokeFailure(DataFetcherResult.Builder<Object> resultBuilder) {
        return (O)Uni.createFrom().item(() -> resultBuilder.build()).subscribe().asCompletionStage();
    }

    protected CompletionStage<List<T>> invokeBatch(DataFetchingEnvironment dfe, Object[] arguments) {
        ManagedContext requestContext = Arc.container().requestContext();
        try {
            RequestContextHelper.reactivate(requestContext, dfe);
            CompletableFuture completableFuture = this.handleUserBatchLoad(dfe, arguments).subscribe().asCompletionStage();
            return completableFuture;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            requestContext.deactivate();
        }
    }

    protected abstract Uni<List<T>> handleUserBatchLoad(DataFetchingEnvironment var1, Object[] var2) throws Exception;
}

