/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRecorder;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthServlet;
import io.quarkus.smallrye.health.runtime.SmallRyeLivenessServlet;
import io.quarkus.smallrye.health.runtime.SmallRyeReadinessServlet;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.smallrye.health.SmallRyeHealthReporter;
import java.io.IOException;
import java.util.Set;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;
import org.jboss.jandex.DotName;

class SmallRyeHealthProcessor {
    private static final DotName HEALTH = DotName.createSimple((String)Health.class.getName());
    private static final DotName LIVENESS = DotName.createSimple((String)Liveness.class.getName());
    private static final DotName READINESS = DotName.createSimple((String)Readiness.class.getName());
    SmallRyeHealthConfig health;

    SmallRyeHealthProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(SmallRyeHealthRecorder recorder, RecorderContext recorderContext, BuildProducer<FeatureBuildItem> feature, BuildProducer<ServletBuildItem> servlet, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotation) throws IOException {
        feature.produce((BuildItem)new FeatureBuildItem("smallrye-health"));
        ServletBuildItem servletBuildItem = ServletBuildItem.builder((String)"health", (String)SmallRyeHealthServlet.class.getName()).addMapping(this.health.rootPath).build();
        servlet.produce((BuildItem)servletBuildItem);
        ServletBuildItem liveServletBuildItem = ServletBuildItem.builder((String)"liveness", (String)SmallRyeLivenessServlet.class.getName()).addMapping(this.health.rootPath + this.health.livenessPath).build();
        servlet.produce((BuildItem)liveServletBuildItem);
        ServletBuildItem readyServletBuildItem = ServletBuildItem.builder((String)"readiness", (String)SmallRyeReadinessServlet.class.getName()).addMapping(this.health.rootPath + this.health.readinessPath).build();
        servlet.produce((BuildItem)readyServletBuildItem);
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(LIVENESS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(READINESS));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SmallRyeHealthReporter.class, SmallRyeHealthServlet.class, SmallRyeLivenessServlet.class, SmallRyeReadinessServlet.class}));
        Set providers = ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + HealthCheckResponseProvider.class.getName()));
        if (providers.isEmpty()) {
            throw new IllegalStateException("No HealthCheckResponseProvider implementation found.");
        }
        if (providers.size() > 1) {
            throw new IllegalStateException(String.format("Multiple HealthCheckResponseProvider implementations found: %s", providers));
        }
        recorder.registerHealthCheckResponseProvider(recorderContext.classProxy((String)providers.iterator().next()));
    }

    @BuildStep
    public void kubernetes(BuildProducer<KubernetesHealthLivenessPathBuildItem> livenessPathItemProducer, BuildProducer<KubernetesHealthReadinessPathBuildItem> readinessPathItemProducer) {
        livenessPathItemProducer.produce((BuildItem)new KubernetesHealthLivenessPathBuildItem(this.health.rootPath + this.health.livenessPath));
        readinessPathItemProducer.produce((BuildItem)new KubernetesHealthReadinessPathBuildItem(this.health.rootPath + this.health.readinessPath));
    }

    @ConfigRoot(name="smallrye-health")
    static final class SmallRyeHealthConfig {
        @ConfigItem(defaultValue="/health")
        String rootPath;
        @ConfigItem(defaultValue="/live")
        String livenessPath;
        @ConfigItem(defaultValue="/ready")
        String readinessPath;

        SmallRyeHealthConfig() {
        }
    }
}

