/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.deployment;

import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.models.responses.APIResponsesImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class HealthOpenAPIFilter
implements OASFilter {
    private static final List<String> MICROPROFILE_HEALTH_TAG = Collections.singletonList("MicroProfile Health");
    private final String rootPath;
    private final String livenessPath;
    private final String readinessPath;

    public HealthOpenAPIFilter(String rootPath, String livenessPath, String readinessPath) {
        this.rootPath = rootPath;
        this.livenessPath = livenessPath;
        this.readinessPath = readinessPath;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        if (openAPI.getComponents() == null) {
            openAPI.setComponents((Components)new ComponentsImpl());
        }
        openAPI.getComponents().addSchema("HealthCheckResponse", this.createHealthCheckResponse());
        openAPI.getComponents().addSchema("State", this.createState());
        if (openAPI.getPaths() == null) {
            openAPI.setPaths((Paths)new PathsImpl());
        }
        Paths paths = openAPI.getPaths();
        paths.addPathItem(this.rootPath, this.createHealthPathItem());
        paths.addPathItem(this.livenessPath, this.createLivenessPathItem());
        paths.addPathItem(this.readinessPath, this.createReadinessPathItem());
    }

    private PathItem createHealthPathItem() {
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setDescription("MicroProfile Health Endpoint");
        pathItem.setSummary("MicroProfile Health provides a way for your application to distribute information about its healthiness state to state whether or not it is able to function properly");
        pathItem.setGET(this.createHealthOperation());
        return pathItem;
    }

    private PathItem createLivenessPathItem() {
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setDescription("MicroProfile Health - Liveness Endpoint");
        pathItem.setSummary("Liveness checks are utilized to tell whether the application should be restarted");
        pathItem.setGET(this.createLivenessOperation());
        return pathItem;
    }

    private PathItem createReadinessPathItem() {
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setDescription("MicroProfile Health - Readiness Endpoint");
        pathItem.setSummary("Readiness checks are used to tell whether the application is able to process requests");
        pathItem.setGET(this.createReadinessOperation());
        return pathItem;
    }

    private Operation createHealthOperation() {
        OperationImpl operation = new OperationImpl();
        operation.setDescription("Check the health of the application");
        operation.setOperationId("microprofile_health_root");
        operation.setTags(MICROPROFILE_HEALTH_TAG);
        operation.setSummary("An aggregated view of the Liveness and Readiness of this application");
        operation.setResponses(this.createAPIResponses());
        return operation;
    }

    private Operation createLivenessOperation() {
        OperationImpl operation = new OperationImpl();
        operation.setDescription("Check the liveness of the application");
        operation.setOperationId("microprofile_health_liveness");
        operation.setTags(MICROPROFILE_HEALTH_TAG);
        operation.setSummary("The Liveness check of this application");
        operation.setResponses(this.createAPIResponses());
        return operation;
    }

    private Operation createReadinessOperation() {
        OperationImpl operation = new OperationImpl();
        operation.setDescription("Check the readiness of the application");
        operation.setOperationId("microprofile_health_readiness");
        operation.setTags(MICROPROFILE_HEALTH_TAG);
        operation.setSummary("The Readiness check of this application");
        operation.setResponses(this.createAPIResponses());
        return operation;
    }

    private APIResponses createAPIResponses() {
        APIResponsesImpl responses = new APIResponsesImpl();
        responses.addAPIResponse("200", this.createAPIResponse());
        responses.addAPIResponse("503", this.createAPIResponse());
        responses.addAPIResponse("500", this.createAPIResponse());
        return responses;
    }

    private APIResponse createAPIResponse() {
        APIResponseImpl response = new APIResponseImpl();
        response.setContent(this.createContent());
        return response;
    }

    private Content createContent() {
        ContentImpl content = new ContentImpl();
        content.addMediaType("application/json", this.createMediaType());
        return content;
    }

    private MediaType createMediaType() {
        MediaTypeImpl mediaType = new MediaTypeImpl();
        mediaType.setSchema((Schema)new SchemaImpl().ref("#/components/schemas/HealthCheckResponse"));
        return mediaType;
    }

    private Schema createHealthCheckResponse() {
        SchemaImpl schema = new SchemaImpl("HealthCheckResponse");
        schema.setType(Schema.SchemaType.OBJECT);
        schema.setProperties(this.createProperties());
        return schema;
    }

    private Map<String, Schema> createProperties() {
        HashMap<String, Schema> map = new HashMap<String, Schema>();
        map.put("data", this.createData());
        map.put("name", this.createName());
        map.put("state", (Schema)new SchemaImpl().ref("#/components/schemas/State"));
        return map;
    }

    private Schema createData() {
        SchemaImpl schema = new SchemaImpl("data");
        schema.setType(Schema.SchemaType.OBJECT);
        schema.setNullable(Boolean.TRUE);
        return schema;
    }

    private Schema createName() {
        SchemaImpl schema = new SchemaImpl("name");
        schema.setType(Schema.SchemaType.STRING);
        return schema;
    }

    private Schema createState() {
        SchemaImpl schema = new SchemaImpl("State");
        schema.setEnumeration(this.createStateEnumValues());
        schema.setType(Schema.SchemaType.STRING);
        return schema;
    }

    private List<Object> createStateEnumValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("DOWN");
        values.add("UP");
        return values;
    }
}

