/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownListenerBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.runtime.shutdown.ShutdownListener;
import io.quarkus.smallrye.health.deployment.HealthBuildTimeConfig;
import io.quarkus.smallrye.health.deployment.HealthOpenAPIFilter;
import io.quarkus.smallrye.health.deployment.SmallRyeHealthConfig;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.smallrye.health.runtime.ShutdownReadinessListener;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthGroupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRecorder;
import io.quarkus.smallrye.health.runtime.SmallRyeIndividualHealthGroupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeLivenessHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeReadinessHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeWellnessHandler;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.smallrye.health.SmallRyeHealthReporter;
import io.smallrye.health.api.HealthGroup;
import io.smallrye.health.api.HealthGroups;
import io.smallrye.health.api.Wellness;
import io.vertx.core.Handler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class SmallRyeHealthProcessor {
    private static final Logger LOG = Logger.getLogger(SmallRyeHealthProcessor.class);
    private static final DotName HEALTH = DotName.createSimple((String)Health.class.getName());
    private static final DotName LIVENESS = DotName.createSimple((String)Liveness.class.getName());
    private static final DotName READINESS = DotName.createSimple((String)Readiness.class.getName());
    private static final DotName HEALTH_GROUP = DotName.createSimple((String)HealthGroup.class.getName());
    private static final DotName HEALTH_GROUPS = DotName.createSimple((String)HealthGroups.class.getName());
    private static final DotName WELLNESS = DotName.createSimple((String)Wellness.class.getName());
    private static final DotName JAX_RS_PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    private static final String HEALTH_UI_WEBJAR_GROUP_ID = "io.smallrye";
    private static final String HEALTH_UI_WEBJAR_ARTIFACT_ID = "smallrye-health-ui";
    private static final String HEALTH_UI_WEBJAR_PREFIX = "META-INF/resources/health-ui";
    private static final String OWN_MEDIA_FOLDER = "META-INF/resources/";
    private static final String HEALTH_UI_FINAL_DESTINATION = "META-INF/health-ui-files";
    private static final String TEMP_DIR_PREFIX = "quarkus-health-ui_" + System.nanoTime();
    private static final List<String> IGNORE_LIST = Arrays.asList("logo.png", "favicon.ico");
    private static final String FILE_TO_UPDATE = "healthui.js";
    SmallRyeHealthConfig health;
    HealthBuildTimeConfig config;

    SmallRyeHealthProcessor() {
    }

    @BuildStep
    void healthCheck(BuildProducer<AdditionalBeanBuildItem> buildItemBuildProducer, List<HealthBuildItem> healthBuildItems) {
        boolean extensionsEnabled;
        boolean bl = extensionsEnabled = this.config.extensionsEnabled && ConfigProvider.getConfig().getOptionalValue("mp.health.disable-default-procedures", Boolean.TYPE).orElse(false) == false;
        if (extensionsEnabled) {
            for (HealthBuildItem buildItem : healthBuildItems) {
                if (!buildItem.isEnabled()) continue;
                buildItemBuildProducer.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{buildItem.getHealthCheckClass()}));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(SmallRyeHealthRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotation, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, LaunchModeBuildItem launchModeBuildItem) throws IOException, ClassNotFoundException {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_HEALTH));
        if (launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.health.rootPath));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.health.rootPath + this.health.livenessPath));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.health.rootPath + this.health.readinessPath));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.health.rootPath + this.health.groupPath));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.health.rootPath + this.health.wellnessPath));
        }
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(LIVENESS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(READINESS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH_GROUP));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH_GROUPS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(WELLNESS));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SmallRyeHealthReporter.class}));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{HealthGroup.class}));
        Set providers = ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + HealthCheckResponseProvider.class.getName()));
        if (providers.isEmpty()) {
            throw new IllegalStateException("No HealthCheckResponseProvider implementation found.");
        }
        if (providers.size() > 1) {
            throw new IllegalStateException(String.format("Multiple HealthCheckResponseProvider implementations found: %s", providers));
        }
        String provider = (String)providers.iterator().next();
        Class<?> responseProvider = Class.forName(provider, true, Thread.currentThread().getContextClassLoader());
        recorder.registerHealthCheckResponseProvider(responseProvider);
    }

    @BuildStep
    public void defineHealthRoutes(BuildProducer<RouteBuildItem> routes, BeanArchiveIndexBuildItem beanArchiveIndex) {
        IndexView index = beanArchiveIndex.getIndex();
        this.warnIfJaxRsPathUsed(index, LIVENESS);
        this.warnIfJaxRsPathUsed(index, READINESS);
        this.warnIfJaxRsPathUsed(index, HEALTH);
        this.warnIfJaxRsPathUsed(index, WELLNESS);
        routes.produce((BuildItem)new RouteBuildItem(this.health.rootPath, (Handler)new SmallRyeHealthHandler(), HandlerType.BLOCKING));
        routes.produce((BuildItem)new RouteBuildItem(this.health.rootPath + this.health.livenessPath, (Handler)new SmallRyeLivenessHandler(), HandlerType.BLOCKING));
        routes.produce((BuildItem)new RouteBuildItem(this.health.rootPath + this.health.readinessPath, (Handler)new SmallRyeReadinessHandler(), HandlerType.BLOCKING));
        HashSet<String> healthGroups = new HashSet<String>();
        for (AnnotationInstance healthGroupAnnotation : index.getAnnotations(HEALTH_GROUP)) {
            healthGroups.add(healthGroupAnnotation.value().asString());
        }
        for (AnnotationInstance healthGroupsAnnotation : index.getAnnotations(HEALTH_GROUPS)) {
            for (AnnotationInstance healthGroupAnnotation : healthGroupsAnnotation.value().asNestedArray()) {
                healthGroups.add(healthGroupAnnotation.value().asString());
            }
        }
        routes.produce((BuildItem)new RouteBuildItem(this.health.rootPath + this.health.groupPath, (Handler)new SmallRyeHealthGroupHandler(), HandlerType.BLOCKING));
        SmallRyeIndividualHealthGroupHandler handler = new SmallRyeIndividualHealthGroupHandler();
        for (String healthGroup : healthGroups) {
            routes.produce((BuildItem)new RouteBuildItem(this.health.rootPath + this.health.groupPath + "/" + healthGroup, (Handler)handler, HandlerType.BLOCKING));
        }
        routes.produce((BuildItem)new RouteBuildItem(this.health.rootPath + this.health.wellnessPath, (Handler)new SmallRyeWellnessHandler(), HandlerType.BLOCKING));
    }

    @BuildStep(onlyIf={OpenAPIIncluded.class})
    public void includeInOpenAPIEndpoint(BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer, Capabilities capabilities) {
        if (capabilities.isPresent(Capability.SMALLRYE_OPENAPI)) {
            HealthOpenAPIFilter filter = new HealthOpenAPIFilter(this.health.rootPath, this.health.rootPath + this.health.livenessPath, this.health.rootPath + this.health.readinessPath);
            openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)filter));
        }
    }

    private void warnIfJaxRsPathUsed(IndexView index, DotName healthAnnotation) {
        Collection instances = index.getAnnotations(healthAnnotation);
        for (AnnotationInstance instance : instances) {
            boolean containsPath = false;
            AnnotationTarget target = instance.target();
            if (target.kind() == AnnotationTarget.Kind.CLASS) {
                if (target.asClass().classAnnotation(JAX_RS_PATH) != null) {
                    containsPath = true;
                }
            } else if (target.kind() == AnnotationTarget.Kind.METHOD && target.asMethod().hasAnnotation(JAX_RS_PATH)) {
                containsPath = true;
            }
            if (!containsPath) continue;
            LOG.warnv("The use of @Path has no effect when @{0} is used and should therefore be removed. Offending target is {1}: {2}", (Object)healthAnnotation.withoutPackagePrefix(), (Object)target.kind(), (Object)target);
        }
    }

    @BuildStep
    public void kubernetes(HttpBuildTimeConfig httpConfig, BuildProducer<KubernetesHealthLivenessPathBuildItem> livenessPathItemProducer, BuildProducer<KubernetesHealthReadinessPathBuildItem> readinessPathItemProducer) {
        if (httpConfig.rootPath == null) {
            livenessPathItemProducer.produce((BuildItem)new KubernetesHealthLivenessPathBuildItem(this.health.rootPath + this.health.livenessPath));
            readinessPathItemProducer.produce((BuildItem)new KubernetesHealthReadinessPathBuildItem(this.health.rootPath + this.health.readinessPath));
        } else {
            String basePath = httpConfig.rootPath.replaceAll("/$", "") + this.health.rootPath;
            livenessPathItemProducer.produce((BuildItem)new KubernetesHealthLivenessPathBuildItem(basePath + this.health.livenessPath));
            readinessPathItemProducer.produce((BuildItem)new KubernetesHealthReadinessPathBuildItem(basePath + this.health.readinessPath));
        }
    }

    @BuildStep
    ShutdownListenerBuildItem shutdownListener() {
        return new ShutdownListenerBuildItem((ShutdownListener)new ShutdownReadinessListener());
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer(BeanArchiveIndexBuildItem beanArchiveIndex, final CustomScopeAnnotationsBuildItem scopes) {
        final Set stereotypes = beanArchiveIndex.getIndex().getAnnotations(DotNames.STEREOTYPE).stream().map(AnnotationInstance::name).collect(Collectors.toSet());
        final ArrayList<DotName> healthAnnotations = new ArrayList<DotName>(5);
        healthAnnotations.add(HEALTH);
        healthAnnotations.add(LIVENESS);
        healthAnnotations.add(READINESS);
        healthAnnotations.add(HEALTH_GROUP);
        healthAnnotations.add(HEALTH_GROUPS);
        healthAnnotations.add(WELLNESS);
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS || kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                Collection annotations;
                if (ctx.getAnnotations().isEmpty()) {
                    return;
                }
                if (ctx.isClass()) {
                    annotations = ctx.getAnnotations();
                    if (Annotations.containsAny((Collection)annotations, (Iterable)stereotypes)) {
                        return;
                    }
                } else {
                    annotations = Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD, (Collection)ctx.getAnnotations());
                }
                if (scopes.isScopeIn(annotations)) {
                    return;
                }
                if (Annotations.containsAny((Collection)annotations, (Iterable)healthAnnotations)) {
                    ((Transformation)ctx.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerUiExtension(BuildProducer<RouteBuildItem> routeProducer, BuildProducer<GeneratedResourceBuildItem> generatedResourceProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageDisplayableEndpointProducer, SmallRyeHealthRecorder recorder, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload, HttpRootPathBuildItem httpRootPath, CurateOutcomeBuildItem curateOutcomeBuildItem) throws Exception {
        if (!this.health.ui.enable) {
            return;
        }
        if ("/".equals(this.health.ui.rootPath)) {
            throw new ConfigurationError("quarkus.smallrye-health.root-path-ui was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        String healthPath = httpRootPath.adjustPath(this.health.rootPath);
        if (launchMode.getLaunchMode().isDevOrTest()) {
            boolean extractionNeeded;
            CachedHealthUI cached = (CachedHealthUI)liveReload.getContextObject(CachedHealthUI.class);
            boolean bl = extractionNeeded = cached == null;
            if (cached != null && !cached.cachedHealthPath.equals(healthPath)) {
                try {
                    FileUtil.deleteDirectory((Path)Paths.get(cached.cachedDirectory, new String[0]));
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to clean Health UI temp directory on restart", (Throwable)e);
                }
                extractionNeeded = true;
            }
            if (extractionNeeded) {
                if (cached == null) {
                    cached = new CachedHealthUI();
                    liveReload.setContextObject(CachedHealthUI.class, (Object)cached);
                    Runtime.getRuntime().addShutdownHook(new Thread((Runnable)cached, "Health UI Shutdown Hook"));
                }
                try {
                    AppArtifact artifact = this.getHealthUiArtifact(curateOutcomeBuildItem);
                    Path tempDir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]).toRealPath(new LinkOption[0]);
                    this.extractHealthUi(artifact, tempDir);
                    this.updateApiUrl(tempDir.resolve(FILE_TO_UPDATE), healthPath);
                    cached.cachedDirectory = tempDir.toAbsolutePath().toString();
                    cached.cachedHealthPath = healthPath;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Handler handler = recorder.uiHandler(cached.cachedDirectory, httpRootPath.adjustPath(this.health.ui.rootPath));
            routeProducer.produce((BuildItem)new RouteBuildItem(this.health.ui.rootPath, handler));
            routeProducer.produce((BuildItem)new RouteBuildItem(this.health.ui.rootPath + "/*", handler));
            notFoundPageDisplayableEndpointProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.health.ui.rootPath + "/"));
        } else if (this.health.ui.alwaysInclude) {
            AppArtifact artifact = this.getHealthUiArtifact(curateOutcomeBuildItem);
            for (Path p : artifact.getPaths()) {
                File artifactFile = p.toFile();
                JarFile jarFile = new JarFile(artifactFile);
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(HEALTH_UI_WEBJAR_PREFIX) || entry.isDirectory()) continue;
                        InputStream inputStream = jarFile.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            String filename = entry.getName().replace("META-INF/resources/health-ui/", "");
                            byte[] content = FileUtil.readFileContents((InputStream)inputStream);
                            if (entry.getName().endsWith(FILE_TO_UPDATE)) {
                                content = this.updateApiUrl(new String(content, StandardCharsets.UTF_8), healthPath).getBytes(StandardCharsets.UTF_8);
                            }
                            if (IGNORE_LIST.contains(filename)) {
                                ClassLoader classLoader = SmallRyeHealthProcessor.class.getClassLoader();
                                try (InputStream resourceAsStream = classLoader.getResourceAsStream(OWN_MEDIA_FOLDER + filename);){
                                    content = IoUtil.readBytes((InputStream)resourceAsStream);
                                }
                            }
                            String fileName = "META-INF/health-ui-files/" + filename;
                            generatedResourceProducer.produce((BuildItem)new GeneratedResourceBuildItem(fileName, content));
                            nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            Handler handler = recorder.uiHandler(HEALTH_UI_FINAL_DESTINATION, httpRootPath.adjustPath(this.health.ui.rootPath));
            routeProducer.produce((BuildItem)new RouteBuildItem(this.health.ui.rootPath, handler));
            routeProducer.produce((BuildItem)new RouteBuildItem(this.health.ui.rootPath + "/*", handler));
        }
    }

    private AppArtifact getHealthUiArtifact(CurateOutcomeBuildItem curateOutcomeBuildItem) {
        for (AppDependency dep : curateOutcomeBuildItem.getEffectiveModel().getFullDeploymentDeps()) {
            if (!dep.getArtifact().getArtifactId().equals(HEALTH_UI_WEBJAR_ARTIFACT_ID) || !dep.getArtifact().getGroupId().equals(HEALTH_UI_WEBJAR_GROUP_ID)) continue;
            return dep.getArtifact();
        }
        throw new RuntimeException("Could not find artifact io.smallrye:smallrye-health-ui among the application dependencies");
    }

    private void extractHealthUi(AppArtifact artifact, Path resourceDir) throws IOException {
        for (Path p : artifact.getPaths()) {
            File artifactFile = p.toFile();
            JarFile jarFile = new JarFile(artifactFile);
            Throwable throwable = null;
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(HEALTH_UI_WEBJAR_PREFIX) || entry.isDirectory()) continue;
                    InputStream inputStream = jarFile.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        String filename = entry.getName().replace("META-INF/resources/health-ui/", "");
                        if (IGNORE_LIST.contains(filename)) continue;
                        Files.copy(inputStream, resourceDir.resolve(filename), new CopyOption[0]);
                    }
                    catch (Throwable filename) {
                        throwable2 = filename;
                        throw filename;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable filename) {
                                throwable2.addSuppressed(filename);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                ClassLoader classLoader = SmallRyeHealthProcessor.class.getClassLoader();
                for (String ownMedia : IGNORE_LIST) {
                    InputStream logo = classLoader.getResourceAsStream(OWN_MEDIA_FOLDER + ownMedia);
                    Throwable throwable3 = null;
                    try {
                        Files.copy(logo, resourceDir.resolve(ownMedia), new CopyOption[0]);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (logo == null) continue;
                        if (throwable3 != null) {
                            try {
                                logo.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        logo.close();
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (jarFile == null) continue;
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    continue;
                }
                jarFile.close();
            }
        }
    }

    private void updateApiUrl(Path healthUiJs, String healthPath) throws IOException {
        String content = new String(Files.readAllBytes(healthUiJs), StandardCharsets.UTF_8);
        String result = this.updateApiUrl(content, healthPath);
        if (result != null) {
            Files.write(healthUiJs, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public String updateApiUrl(String original, String healthPath) {
        return original.replace("url = \"/health\";", "url = \"" + healthPath + "\";");
    }

    private static final class CachedHealthUI
    implements Runnable {
        String cachedHealthPath;
        String cachedDirectory;

        private CachedHealthUI() {
        }

        @Override
        public void run() {
            try {
                FileUtil.deleteDirectory((Path)Paths.get(this.cachedDirectory, new String[0]));
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to clean Health UI temp directory on shutdown", (Throwable)e);
            }
        }
    }

    static class OpenAPIIncluded
    implements BooleanSupplier {
        HealthBuildTimeConfig config;

        OpenAPIIncluded() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.openapiIncluded;
        }
    }
}

