/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.ShutdownListenerBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthStartupPathBuildItem;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.shutdown.ShutdownListener;
import io.quarkus.smallrye.health.deployment.HealthBuildTimeConfig;
import io.quarkus.smallrye.health.deployment.HealthOpenAPIFilter;
import io.quarkus.smallrye.health.deployment.SmallRyeHealthBuildItem;
import io.quarkus.smallrye.health.deployment.SmallRyeHealthConfig;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.smallrye.health.runtime.QuarkusAsyncHealthCheckFactory;
import io.quarkus.smallrye.health.runtime.ShutdownReadinessListener;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthGroupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRecorder;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRuntimeConfig;
import io.quarkus.smallrye.health.runtime.SmallRyeIndividualHealthGroupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeLivenessHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeReadinessHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeStartupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeWellnessHandler;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarResourcesFilter;
import io.quarkus.vertx.http.deployment.webjar.WebJarResultsBuildItem;
import io.smallrye.health.SmallRyeHealthReporter;
import io.smallrye.health.api.HealthGroup;
import io.smallrye.health.api.HealthGroups;
import io.smallrye.health.api.Wellness;
import io.vertx.core.Handler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class SmallRyeHealthProcessor {
    private static final Logger LOG = Logger.getLogger(SmallRyeHealthProcessor.class);
    private static final DotName LIVENESS = DotName.createSimple((String)Liveness.class.getName());
    private static final DotName READINESS = DotName.createSimple((String)Readiness.class.getName());
    private static final DotName STARTUP = DotName.createSimple((String)Startup.class.getName());
    private static final DotName HEALTH_GROUP = DotName.createSimple((String)HealthGroup.class.getName());
    private static final DotName HEALTH_GROUPS = DotName.createSimple((String)HealthGroups.class.getName());
    private static final DotName WELLNESS = DotName.createSimple((String)Wellness.class.getName());
    private static final DotName JAX_RS_PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    private static final GACT HEALTH_UI_WEBJAR_ARTIFACT_KEY = new GACT("io.smallrye", "smallrye-health-ui", null, "jar");
    private static final String HEALTH_UI_WEBJAR_STATIC_RESOURCES_PATH = "META-INF/resources/health-ui/";
    private static final String JS_FILE_TO_UPDATE = "healthui.js";
    private static final String INDEX_FILE_TO_UPDATE = "index.html";
    private static final String BRANDING_DIR = "META-INF/branding/";
    private static final String BRANDING_LOGO_GENERAL = "META-INF/branding/logo.png";
    private static final String BRANDING_LOGO_MODULE = "META-INF/branding/smallrye-health-ui.png";
    private static final String BRANDING_STYLE_GENERAL = "META-INF/branding/style.css";
    private static final String BRANDING_STYLE_MODULE = "META-INF/branding/smallrye-health-ui.css";
    private static final String BRANDING_FAVICON_GENERAL = "META-INF/branding/favicon.ico";
    private static final String BRANDING_FAVICON_MODULE = "META-INF/branding/smallrye-health-ui.ico";
    HealthBuildTimeConfig config;

    SmallRyeHealthProcessor() {
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> brandingFiles() {
        return Stream.of(BRANDING_LOGO_GENERAL, BRANDING_STYLE_GENERAL, BRANDING_FAVICON_GENERAL, BRANDING_LOGO_MODULE, BRANDING_STYLE_MODULE, BRANDING_FAVICON_MODULE).map(HotDeploymentWatchedFileBuildItem::new).collect(Collectors.toList());
    }

    @BuildStep
    void healthCheck(BuildProducer<AdditionalBeanBuildItem> buildItemBuildProducer, List<HealthBuildItem> healthBuildItems) {
        boolean extensionsEnabled;
        boolean bl = extensionsEnabled = this.config.extensionsEnabled && ConfigProvider.getConfig().getOptionalValue("mp.health.disable-default-procedures", Boolean.TYPE).orElse(false) == false;
        if (extensionsEnabled) {
            for (HealthBuildItem buildItem : healthBuildItems) {
                if (!buildItem.isEnabled()) continue;
                buildItemBuildProducer.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{buildItem.getHealthCheckClass()}));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(SmallRyeHealthRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotation) throws IOException, ClassNotFoundException {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_HEALTH));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(LIVENESS, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(READINESS, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(STARTUP, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH_GROUP, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH_GROUPS, BuiltinScope.SINGLETON.getName()));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(WELLNESS, BuiltinScope.SINGLETON.getName()));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{QuarkusAsyncHealthCheckFactory.class}));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SmallRyeHealthReporter.class}));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{HealthGroup.class}));
        Set providers = ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + HealthCheckResponseProvider.class.getName()));
        if (providers.isEmpty()) {
            throw new IllegalStateException("No HealthCheckResponseProvider implementation found.");
        }
        if (providers.size() > 1) {
            throw new IllegalStateException(String.format("Multiple HealthCheckResponseProvider implementations found: %s", providers));
        }
        String provider = (String)providers.iterator().next();
        Class<?> responseProvider = Class.forName(provider, true, Thread.currentThread().getContextClassLoader());
        recorder.registerHealthCheckResponseProvider(responseProvider);
    }

    @BuildStep
    public void defineHealthRoutes(BuildProducer<RouteBuildItem> routes, BeanArchiveIndexBuildItem beanArchiveIndex, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeHealthConfig healthConfig) {
        IndexView index = beanArchiveIndex.getIndex();
        this.warnIfJaxRsPathUsed(index, LIVENESS);
        this.warnIfJaxRsPathUsed(index, READINESS);
        this.warnIfJaxRsPathUsed(index, STARTUP);
        this.warnIfJaxRsPathUsed(index, WELLNESS);
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(healthConfig.rootPath).routeConfigKey("quarkus.smallrye-health.root-path").handler((Handler)new SmallRyeHealthHandler()).displayOnNotFoundPage().blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.livenessPath).handler((Handler)new SmallRyeLivenessHandler()).displayOnNotFoundPage().blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.readinessPath).handler((Handler)new SmallRyeReadinessHandler()).displayOnNotFoundPage().blockingRoute().build());
        HashSet<String> healthGroups = new HashSet<String>();
        for (AnnotationInstance healthGroupAnnotation : index.getAnnotations(HEALTH_GROUP)) {
            healthGroups.add(healthGroupAnnotation.value().asString());
        }
        for (AnnotationInstance healthGroupsAnnotation : index.getAnnotations(HEALTH_GROUPS)) {
            for (AnnotationInstance healthGroupAnnotation : healthGroupsAnnotation.value().asNestedArray()) {
                healthGroups.add(healthGroupAnnotation.value().asString());
            }
        }
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.groupPath).handler((Handler)new SmallRyeHealthGroupHandler()).displayOnNotFoundPage().blockingRoute().build());
        SmallRyeIndividualHealthGroupHandler handler = new SmallRyeIndividualHealthGroupHandler();
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.groupPath + "/*").handler((Handler)handler).displayOnNotFoundPage().blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.wellnessPath).handler((Handler)new SmallRyeWellnessHandler()).displayOnNotFoundPage().blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.startupPath).handler((Handler)new SmallRyeStartupHandler()).displayOnNotFoundPage().blockingRoute().build());
    }

    @BuildStep
    public void processSmallRyeHealthConfigValues(SmallRyeHealthConfig healthConfig, BuildProducer<RunTimeConfigurationDefaultBuildItem> config) {
        if (healthConfig.contextPropagation) {
            config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("io.smallrye.health.context.propagation", "true"));
        }
        if (healthConfig.maxGroupRegistriesCount.isPresent()) {
            config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("io.smallrye.health.maxGroupRegistriesCount", String.valueOf(healthConfig.maxGroupRegistriesCount.getAsInt())));
        }
        config.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("io.smallrye.health.delayChecksInitializations", "true"));
    }

    @BuildStep(onlyIf={OpenAPIIncluded.class})
    public void includeInOpenAPIEndpoint(BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, Capabilities capabilities, SmallRyeHealthConfig healthConfig) {
        if (capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            String healthRootPath = nonApplicationRootPathBuildItem.resolvePath(healthConfig.rootPath);
            HealthOpenAPIFilter filter = new HealthOpenAPIFilter(healthRootPath, nonApplicationRootPathBuildItem.resolveNestedPath(healthRootPath, healthConfig.livenessPath), nonApplicationRootPathBuildItem.resolveNestedPath(healthRootPath, healthConfig.readinessPath), nonApplicationRootPathBuildItem.resolveNestedPath(healthRootPath, healthConfig.startupPath));
            openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)filter));
        }
    }

    private void warnIfJaxRsPathUsed(IndexView index, DotName healthAnnotation) {
        Collection instances = index.getAnnotations(healthAnnotation);
        for (AnnotationInstance instance : instances) {
            boolean containsPath = false;
            AnnotationTarget target = instance.target();
            if (target.kind() == AnnotationTarget.Kind.CLASS) {
                if (target.asClass().classAnnotation(JAX_RS_PATH) != null) {
                    containsPath = true;
                }
            } else if (target.kind() == AnnotationTarget.Kind.METHOD && target.asMethod().hasAnnotation(JAX_RS_PATH)) {
                containsPath = true;
            }
            if (!containsPath) continue;
            LOG.warnv("The use of @Path has no effect when @{0} is used and should therefore be removed. Offending target is {1}: {2}", (Object)healthAnnotation.withoutPackagePrefix(), (Object)target.kind(), (Object)target);
        }
    }

    @BuildStep
    public void kubernetes(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeHealthConfig healthConfig, BuildProducer<KubernetesHealthLivenessPathBuildItem> livenessPathItemProducer, BuildProducer<KubernetesHealthReadinessPathBuildItem> readinessPathItemProducer, BuildProducer<KubernetesHealthStartupPathBuildItem> startupPathItemProducer) {
        livenessPathItemProducer.produce((BuildItem)new KubernetesHealthLivenessPathBuildItem(nonApplicationRootPathBuildItem.resolveNestedPath(healthConfig.rootPath, healthConfig.livenessPath)));
        readinessPathItemProducer.produce((BuildItem)new KubernetesHealthReadinessPathBuildItem(nonApplicationRootPathBuildItem.resolveNestedPath(healthConfig.rootPath, healthConfig.readinessPath)));
        startupPathItemProducer.produce((BuildItem)new KubernetesHealthStartupPathBuildItem(nonApplicationRootPathBuildItem.resolveNestedPath(healthConfig.rootPath, healthConfig.startupPath)));
    }

    @BuildStep
    ShutdownListenerBuildItem shutdownListener() {
        return new ShutdownListenerBuildItem((ShutdownListener)new ShutdownReadinessListener());
    }

    @BuildStep
    void registerUiExtension(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeHealthConfig healthConfig, LaunchModeBuildItem launchModeBuildItem, BuildProducer<WebJarBuildItem> webJarBuildProducer) {
        if (SmallRyeHealthProcessor.shouldInclude(launchModeBuildItem, healthConfig)) {
            if ("/".equals(healthConfig.ui.rootPath)) {
                throw new ConfigurationException("quarkus.smallrye-health.root-path-ui was set to \"/\", this is not allowed as it blocks the application from serving anything else.", Set.of("quarkus.smallrye-health.root-path-ui"));
            }
            final String healthPath = nonApplicationRootPathBuildItem.resolvePath(healthConfig.rootPath);
            webJarBuildProducer.produce((BuildItem)WebJarBuildItem.builder().artifactKey(HEALTH_UI_WEBJAR_ARTIFACT_KEY).root(HEALTH_UI_WEBJAR_STATIC_RESOURCES_PATH).filter(new WebJarResourcesFilter(){

                public WebJarResourcesFilter.FilterResult apply(String fileName, InputStream file) throws IOException {
                    if (fileName.endsWith(SmallRyeHealthProcessor.JS_FILE_TO_UPDATE) || fileName.endsWith(SmallRyeHealthProcessor.INDEX_FILE_TO_UPDATE)) {
                        byte[] content = SmallRyeHealthProcessor.this.updateApiUrl(new String(file.readAllBytes(), StandardCharsets.UTF_8), healthPath).getBytes(StandardCharsets.UTF_8);
                        return new WebJarResourcesFilter.FilterResult((InputStream)new ByteArrayInputStream(content), true);
                    }
                    return new WebJarResourcesFilter.FilterResult(file, false);
                }
            }).build());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerHealthUiHandler(BuildProducer<RouteBuildItem> routeProducer, SmallRyeHealthRecorder recorder, SmallRyeHealthRuntimeConfig runtimeConfig, WebJarResultsBuildItem webJarResultsBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LaunchModeBuildItem launchMode, SmallRyeHealthConfig healthConfig, BuildProducer<SmallRyeHealthBuildItem> smallryeHealthBuildProducer, ShutdownContextBuildItem shutdownContext) {
        WebJarResultsBuildItem.WebJarResult result = webJarResultsBuildItem.byArtifactKey(HEALTH_UI_WEBJAR_ARTIFACT_KEY);
        if (result == null) {
            return;
        }
        if (SmallRyeHealthProcessor.shouldInclude(launchMode, healthConfig)) {
            String healthUiPath = nonApplicationRootPathBuildItem.resolvePath(healthConfig.ui.rootPath);
            smallryeHealthBuildProducer.produce((BuildItem)new SmallRyeHealthBuildItem(result.getFinalDestination(), healthUiPath));
            Handler handler = recorder.uiHandler(result.getFinalDestination(), healthUiPath, result.getWebRootConfigurations(), runtimeConfig, (ShutdownContext)shutdownContext);
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(healthConfig.ui.rootPath).displayOnNotFoundPage("Health UI").routeConfigKey("quarkus.smallrye-health.ui.root-path").handler(handler).build());
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(healthConfig.ui.rootPath + "*").handler(handler).build());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    void processSmallRyeHealthRuntimeConfig(SmallRyeHealthRecorder recorder, SmallRyeHealthRuntimeConfig runtimeConfig) {
        recorder.processSmallRyeHealthRuntimeConfiguration(runtimeConfig);
    }

    public String updateApiUrl(String original, String healthPath) {
        return original.replace("url = \"/health\";", "url = \"" + healthPath + "\";").replace("placeholder=\"/health\"", "placeholder=\"" + healthPath + "\"");
    }

    private static boolean shouldInclude(LaunchModeBuildItem launchMode, SmallRyeHealthConfig healthConfig) {
        return launchMode.getLaunchMode().isDevOrTest() || healthConfig.ui.alwaysInclude;
    }

    static class OpenAPIIncluded
    implements BooleanSupplier {
        HealthBuildTimeConfig config;

        OpenAPIIncluded() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.openapiIncluded;
        }
    }
}

