/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.deployment;

import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.smallrye.health.deployment.SmallRyeHealthBuildTimeConfig;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRecorder;
import io.quarkus.smallrye.health.runtime.dev.ui.HealthJsonRPCService;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;

public class SmallRyeHealthDevUiProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    CardPageBuildItem create(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeHealthBuildTimeConfig config, ManagementInterfaceBuildTimeConfig managementBuildTimeConfig, LaunchModeBuildItem launchModeBuildItem, SmallRyeHealthRecorder unused) {
        CardPageBuildItem pageBuildItem = new CardPageBuildItem();
        String path = nonApplicationRootPathBuildItem.resolveManagementPath(config.rootPath(), managementBuildTimeConfig, launchModeBuildItem, config.managementEnabled());
        pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Health")).icon("font-awesome-solid:stethoscope")).componentLink("qwc-smallrye-health-ui.js").dynamicLabelJsonRPCMethodName("getStatus")).streamingLabelJsonRPCMethodName("streamStatus"));
        pageBuildItem.addPage((PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Raw").icon("font-awesome-solid:heart-circle-bolt")).url(path, path).isJsonContent());
        return pageBuildItem;
    }

    @BuildStep
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(HealthJsonRPCService.class);
    }
}

