/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthBuildFixedConfig;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthHandlerBase;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRuntimeConfig;
import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarNotFoundHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarStaticHandler;
import io.smallrye.health.SmallRyeHealthReporter;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;

@Recorder
public class SmallRyeHealthRecorder {
    public void registerHealthCheckResponseProvider(Class<? extends HealthCheckResponseProvider> providerClass) {
        try {
            HealthCheckResponse.setResponseProvider((HealthCheckResponseProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate service " + providerClass + " using the no-arg constructor.");
        }
    }

    public Handler<RoutingContext> uiHandler(String healthUiFinalDestination, String healthUiPath, List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations, SmallRyeHealthRuntimeConfig runtimeConfig, ShutdownContext shutdownContext) {
        if (runtimeConfig.enable) {
            WebJarStaticHandler handler = new WebJarStaticHandler(healthUiFinalDestination, healthUiPath, webRootConfigurations);
            shutdownContext.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable((Closeable)handler));
            return handler;
        }
        return new WebJarNotFoundHandler();
    }

    public void processSmallRyeHealthRuntimeConfiguration(SmallRyeHealthRuntimeConfig runtimeConfig, SmallRyeHealthBuildFixedConfig buildFixedConfig) {
        SmallRyeHealthReporter reporter = (SmallRyeHealthReporter)Arc.container().select(SmallRyeHealthReporter.class, new Annotation[0]).get();
        reporter.setAdditionalProperties(runtimeConfig.additionalProperties);
        reporter.setHealthChecksConfigs(runtimeConfig.check.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SmallRyeHealthRuntimeConfig.Enabled)e.getValue()).enabled)));
        SmallRyeHealthHandlerBase.problemDetails = buildFixedConfig.includeProblemDetails;
    }
}

