/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.security.deployment.JCAProviderBuildItem;
import io.quarkus.smallrye.jwt.deployment.SmallryeJWTConfig;
import io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism;
import io.quarkus.smallrye.jwt.runtime.auth.JwtPrincipalProducer;
import io.quarkus.smallrye.jwt.runtime.auth.MpJwtValidator;
import io.quarkus.smallrye.jwt.runtime.auth.RawOptionalClaimCreator;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.auth.cdi.ClaimValueProducer;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import io.smallrye.jwt.auth.cdi.JsonValueProducer;
import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import io.smallrye.jwt.config.JWTAuthContextInfoProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class SmallRyeJwtProcessor {
    private static final Logger log = Logger.getLogger((String)SmallRyeJwtProcessor.class.getName());
    private static final DotName CLAIM_NAME = DotName.createSimple((String)Claim.class.getName());
    private static final DotName CLAIMS_NAME = DotName.createSimple((String)Claims.class.getName());
    SmallryeJWTConfig config;

    SmallRyeJwtProcessor() {
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.jwt");
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        if (this.config.enabled) {
            AdditionalBeanBuildItem.Builder unremovable = AdditionalBeanBuildItem.builder().setUnremovable();
            unremovable.addBeanClass(MpJwtValidator.class);
            unremovable.addBeanClass(JWTAuthMechanism.class);
            unremovable.addBeanClass(ClaimValueProducer.class);
            additionalBeans.produce((BuildItem)unremovable.build());
        }
        AdditionalBeanBuildItem.Builder removable = AdditionalBeanBuildItem.builder();
        removable.addBeanClass(JWTAuthContextInfoProvider.class);
        removable.addBeanClass(CommonJwtProducer.class);
        removable.addBeanClass(RawClaimTypeProducer.class);
        removable.addBeanClass(JsonValueProducer.class);
        removable.addBeanClass(JwtPrincipalProducer.class);
        removable.addBeanClass(Claim.class);
        additionalBeans.produce((BuildItem)removable.build());
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{SignatureAlgorithm.class}));
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("smallrye-jwt");
    }

    @BuildStep
    NativeImageResourceBuildItem registerNativeImageResources() {
        String publicKeyLocation;
        Config config = ConfigProvider.getConfig();
        Optional publicKeyLocationOpt = config.getOptionalValue("mp.jwt.verify.publickey.location", String.class);
        if (publicKeyLocationOpt.isPresent() && ((publicKeyLocation = (String)publicKeyLocationOpt.get()).indexOf(58) < 0 || publicKeyLocation.startsWith("classpath:"))) {
            log.infof("Adding %s to native image", (Object)publicKeyLocation);
            return new NativeImageResourceBuildItem(new String[]{publicKeyLocation});
        }
        return null;
    }

    @BuildStep
    JCAProviderBuildItem registerRSASigProvider() {
        return new JCAProviderBuildItem(this.config.rsaSigProvider);
    }

    @BuildStep
    void registerOptionalClaimProducer(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beanConfigurator) {
        HashSet<Type> additionalTypes = new HashSet<Type>();
        for (InjectionPointInfo injectionPoint : (Collection)beanRegistrationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            Type actualType;
            AnnotationInstance claimQualifier;
            if (injectionPoint.hasDefaultedQualifier() || (claimQualifier = injectionPoint.getRequiredQualifier(CLAIM_NAME)) == null || !injectionPoint.getRequiredType().name().equals((Object)DotNames.PROVIDER) || !(actualType = (Type)injectionPoint.getRequiredType().asParameterizedType().arguments().get(0)).name().equals((Object)DotNames.OPTIONAL) || actualType.name().toString().startsWith("javax.json")) continue;
            additionalTypes.add(actualType);
        }
        BeanConfigurator configurator = beanRegistrationPhase.getContext().configure(Optional.class);
        for (Type type : additionalTypes) {
            configurator.addType(type);
        }
        configurator.scope(BuiltinScope.DEPENDENT.getInfo());
        configurator.qualifiers(new AnnotationInstance[]{AnnotationInstance.create((DotName)CLAIM_NAME, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)""), AnnotationValue.createEnumValue((String)"standard", (DotName)CLAIMS_NAME, (String)"UNKNOWN")})});
        configurator.creator(RawOptionalClaimCreator.class);
        beanConfigurator.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem(new BeanConfigurator[]{configurator}));
    }
}

