/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.smallrye.jwt.runtime.auth.JWTAccount;
import io.quarkus.smallrye.jwt.runtime.auth.JWTCredential;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.undertow.UndertowLogger;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Locale;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JWTAuthMechanism
implements AuthenticationMechanism {
    @Inject
    private JWTAuthContextInfo authContextInfo;
    private IdentityManager identityManager;

    public JWTAuthMechanism(JWTAuthContextInfo authContextInfo, IdentityManager identityManager) {
        this.authContextInfo = authContextInfo;
        this.identityManager = identityManager;
    }

    public JWTAuthMechanism(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null) {
            String bearerToken = null;
            for (String current : authHeaders) {
                if (!current.toLowerCase(Locale.ENGLISH).startsWith("bearer ")) continue;
                bearerToken = current.substring(7);
                if (UndertowLogger.SECURITY_LOGGER.isTraceEnabled()) {
                    UndertowLogger.SECURITY_LOGGER.tracef("Bearer token: %s", (Object)bearerToken);
                }
                try {
                    Account account;
                    JWTCredential credential = new JWTCredential(bearerToken, this.authContextInfo);
                    if (UndertowLogger.SECURITY_LOGGER.isTraceEnabled()) {
                        UndertowLogger.SECURITY_LOGGER.tracef("Bearer token: %s", (Object)bearerToken);
                    }
                    if ((account = this.identityManager.verify(credential.getName(), (Credential)credential)) != null) {
                        JsonWebToken jwtPrincipal = (JsonWebToken)account.getPrincipal();
                        JWTAccount jwtAccount = new JWTAccount(jwtPrincipal, account);
                        securityContext.authenticationComplete((Account)jwtAccount, "MP-JWT", false);
                        UndertowLogger.SECURITY_LOGGER.debugf("Authenticated caller(%s) for path(%s) with roles: %s", (Object)credential.getName(), (Object)exchange.getRequestPath(), (Object)account.getRoles());
                        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                    }
                    UndertowLogger.SECURITY_LOGGER.info((Object)"Failed to authenticate JWT bearer token");
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
                catch (Exception e) {
                    UndertowLogger.SECURITY_LOGGER.infof((Throwable)e, "Failed to validate JWT bearer token", new Object[0]);
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, "Bearer {token}");
        UndertowLogger.SECURITY_LOGGER.debugf("Sending Bearer {token} challenge for %s", (Object)exchange);
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }
}

