/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.smallrye.jwt.runtime.auth.ClaimAttributes;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.KeyLocationResolver;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.evidence.BearerTokenEvidence;

@ApplicationScoped
public class MpJwtValidator
implements TokenValidator {
    private static final String ROLE_MAPPINGS = "roleMappings";
    private static Logger log = Logger.getLogger(MpJwtValidator.class);
    @Inject
    JWTAuthContextInfo authContextInfo;

    public MpJwtValidator() {
    }

    public MpJwtValidator(JWTAuthContextInfo authContextInfo) {
        this.authContextInfo = authContextInfo;
    }

    public Attributes validate(BearerTokenEvidence evidence) throws RealmUnavailableException {
        String token = evidence.getToken();
        JwtClaims claimsSet = null;
        try {
            JwtConsumerBuilder builder = new JwtConsumerBuilder().setRequireExpirationTime().setRequireSubject().setSkipDefaultAudienceValidation().setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RS256"}));
            if (this.authContextInfo.isRequireIssuer()) {
                builder.setExpectedIssuer(true, this.authContextInfo.getIssuedBy());
            } else {
                builder.setExpectedIssuer(false, null);
            }
            if (this.authContextInfo.getSignerKey() != null) {
                builder.setVerificationKey((Key)this.authContextInfo.getSignerKey());
            } else if (this.authContextInfo.isFollowMpJwt11Rules()) {
                builder.setVerificationKeyResolver((VerificationKeyResolver)new KeyLocationResolver(this.authContextInfo.getJwksUri()));
            } else {
                List jsonWebKeys = this.authContextInfo.loadJsonWebKeys();
                builder.setVerificationKeyResolver((VerificationKeyResolver)new JwksVerificationKeyResolver(jsonWebKeys));
            }
            if (this.authContextInfo.getExpGracePeriodSecs() > 0) {
                builder.setAllowedClockSkewInSeconds(this.authContextInfo.getExpGracePeriodSecs());
            } else {
                builder.setEvaluationTime(NumericDate.fromSeconds((long)0L));
            }
            JwtConsumer jwtConsumer = builder.build();
            JwtContext jwtContext = jwtConsumer.process(token);
            String type = ((JsonWebStructure)jwtContext.getJoseObjects().get(0)).getHeader("typ");
            jwtConsumer.processContext(jwtContext);
            claimsSet = jwtContext.getJwtClaims();
            if (claimsSet.hasClaim(ROLE_MAPPINGS)) {
                try {
                    Map rolesMapping = (Map)claimsSet.getClaimValue(ROLE_MAPPINGS, Map.class);
                    List groups = claimsSet.getStringListClaimValue(Claims.groups.name());
                    ArrayList<String> allGroups = new ArrayList<String>(groups);
                    for (String key : rolesMapping.keySet()) {
                        if (!groups.contains(key)) continue;
                        String toRole = (String)rolesMapping.get(key);
                        allGroups.add(toRole);
                    }
                    claimsSet.setStringListClaim("groups", allGroups);
                    log.infof("Updated groups to: %s", allGroups);
                }
                catch (Exception e) {
                    log.warnf((Throwable)e, "Failed to access rolesMapping claim", new Object[0]);
                }
            }
            claimsSet.setClaim(Claims.raw_token.name(), (Object)token);
        }
        catch (InvalidJwtException e) {
            throw new RealmUnavailableException("Failed to verify token", (Throwable)e);
        }
        ClaimAttributes claimAttributes = new ClaimAttributes(claimsSet);
        return claimAttributes;
    }
}

