/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.SimpleAttributesEntry;

public class ClaimAttributes
implements Attributes {
    private final JwtClaims claimsSet;
    private HashMap<String, Attributes.Entry> entries = new HashMap();

    public ClaimAttributes(JwtClaims claimsSet) {
        this.claimsSet = claimsSet;
        this.populateEntries();
    }

    public Collection<Attributes.Entry> entries() {
        return this.entries.values();
    }

    public int size(String key) {
        int size = 0;
        try {
            Object objectValue = this.claimsSet.getClaimValue(key);
            size = objectValue instanceof List ? ((List)objectValue).size() : 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public Attributes.Entry get(String key) {
        return this.entries.get(key);
    }

    public String get(String key, int idx) {
        String value = null;
        try {
            if (this.claimsSet.isClaimValueStringList(key)) {
                List values = this.claimsSet.getStringListClaimValue(key);
                value = (String)values.get(idx);
            } else {
                Object objectValue;
                value = this.claimsSet.isClaimValueString(key) && idx == 0 ? (String)this.claimsSet.getClaimValue(key, String.class) : ((objectValue = this.claimsSet.getClaimValue(key)) instanceof List ? ((List)objectValue).get(idx).toString() : objectValue.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int size() {
        return this.entries.size();
    }

    public JwtClaims getClaimsSet() {
        return this.claimsSet;
    }

    private void populateEntries() {
        Map claims = this.claimsSet.flattenClaims();
        for (Map.Entry entry : claims.entrySet()) {
            String key = (String)entry.getKey();
            SimpleAttributesEntry attributesEntry = new SimpleAttributesEntry((Attributes)this, key);
            this.entries.put(key, (Attributes.Entry)attributesEntry);
        }
    }
}

