/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.smallrye.jwt.runtime.auth.ClaimAttributes;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.wildfly.security.authz.Attributes;

public class ElytronJwtCallerPrincipal
extends JWTCallerPrincipal {
    private static final String TMP = "tmp";
    private static Logger logger = Logger.getLogger(ElytronJwtCallerPrincipal.class);
    private Attributes claims;
    private JwtClaims claimsSet;
    private String customPrincipalName;

    public ElytronJwtCallerPrincipal(String customPrincipalName, Attributes claims) {
        super(ElytronJwtCallerPrincipal.getRawToken(ElytronJwtCallerPrincipal.getClaimsSet(claims)), "JWT");
        this.claims = claims;
        this.customPrincipalName = customPrincipalName;
        this.claimsSet = ElytronJwtCallerPrincipal.getClaimsSet(claims);
        this.fixJoseTypes();
    }

    public ElytronJwtCallerPrincipal(String customPrincipalName, JwtClaims claimsSet) {
        this(customPrincipalName, new ClaimAttributes(claimsSet));
    }

    public ElytronJwtCallerPrincipal(Attributes claims) {
        this(null, claims);
    }

    private static String getRawToken(JwtClaims claimsSet) {
        Object rawToken = claimsSet.getClaimValue(Claims.raw_token.name());
        return rawToken != null ? rawToken.toString() : null;
    }

    public Attributes getClaims() {
        return this.claims;
    }

    private static JwtClaims getClaimsSet(Attributes claims) {
        if (!(claims instanceof ClaimAttributes)) {
            throw new IllegalStateException("ElytronJwtCallerPrincipal requires Attributes to be a: " + ClaimAttributes.class.getName());
        }
        return ((ClaimAttributes)claims).getClaimsSet();
    }

    public String getName() {
        return this.customPrincipalName != null ? this.customPrincipalName : super.getName();
    }

    public Set<String> getAudience() {
        HashSet<String> audSet = null;
        try {
            if (this.claimsSet.hasClaim(Claims.aud.name())) {
                List audList = this.claimsSet.getStringListClaimValue("aud");
                audSet = new HashSet(audList);
            }
        }
        catch (MalformedClaimException e) {
            try {
                String aud = this.claimsSet.getStringClaimValue("aud");
                audSet = new HashSet<String>();
                audSet.add(aud);
            }
            catch (MalformedClaimException malformedClaimException) {
                // empty catch block
            }
        }
        return audSet;
    }

    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        try {
            List globalGroups = this.claimsSet.getStringListClaimValue("groups");
            if (globalGroups != null) {
                groups.addAll(globalGroups);
            }
        }
        catch (MalformedClaimException e) {
            e.printStackTrace();
        }
        return groups;
    }

    protected Collection<String> doGetClaimNames() {
        return this.claimsSet.getClaimNames();
    }

    protected Object getClaimValue(String claimName) {
        Claims claimType = Claims.UNKNOWN;
        Object claim = null;
        try {
            claimType = Claims.valueOf((String)claimName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (claimType) {
            case exp: 
            case iat: 
            case auth_time: 
            case nbf: 
            case updated_at: {
                try {
                    claim = this.claimsSet.getClaimValue(claimType.name(), Long.class);
                    if (claim != null) break;
                    claim = new Long(0L);
                }
                catch (MalformedClaimException malformedClaimException) {}
                break;
            }
            case groups: {
                claim = this.getGroups();
                break;
            }
            case aud: {
                claim = this.getAudience();
                break;
            }
            case UNKNOWN: {
                claim = this.claimsSet.getClaimValue(claimName);
                if (claim instanceof JsonStructure) break;
                claim = this.wrapClaimValue(claim);
                break;
            }
            default: {
                claim = this.claimsSet.getClaimValue(claimType.name());
            }
        }
        return claim;
    }

    private void fixJoseTypes() {
        if (this.claimsSet.hasClaim(Claims.address.name())) {
            this.replaceMap(Claims.address.name());
        }
        if (this.claimsSet.hasClaim(Claims.jwk.name())) {
            this.replaceMap(Claims.jwk.name());
        }
        if (this.claimsSet.hasClaim(Claims.sub_jwk.name())) {
            this.replaceMap(Claims.sub_jwk.name());
        }
        Set<String> customClaimNames = this.filterCustomClaimNames(this.claimsSet.getClaimNames());
        for (String name : customClaimNames) {
            Object claimValue = this.claimsSet.getClaimValue(name);
            Class<?> claimType = claimValue.getClass();
            if (claimValue instanceof List) {
                this.replaceList(name);
                continue;
            }
            if (claimValue instanceof Map) {
                this.replaceMap(name);
                continue;
            }
            if (!(claimValue instanceof Number)) continue;
            this.replaceNumber(name);
        }
    }

    private Set<String> filterCustomClaimNames(Collection<String> claimNames) {
        HashSet<String> customNames = new HashSet<String>(claimNames);
        for (Claims claim : Claims.values()) {
            customNames.remove(claim.name());
        }
        return customNames;
    }

    private void replaceMap(String name) {
        try {
            Map map = (Map)this.claimsSet.getClaimValue(name, Map.class);
            JsonObject jsonObject = this.replaceMapClaims(map);
            this.claimsSet.setClaim(name, (Object)jsonObject);
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)("replaceMap failure for: " + name), (Throwable)e);
        }
    }

    private JsonObject replaceMapClaims(Map<String, Object> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                JsonObject entryJsonObject = this.replaceMapClaims((Map)entryValue);
                builder.add(entry.getKey(), (JsonValue)entryJsonObject);
                continue;
            }
            if (entryValue instanceof List) {
                JsonArray array = (JsonArray)this.wrapClaimValue(entryValue);
                builder.add(entry.getKey(), (JsonValue)array);
                continue;
            }
            if (entryValue instanceof Long || entryValue instanceof Integer) {
                long lvalue = ((Number)entryValue).longValue();
                builder.add(entry.getKey(), lvalue);
                continue;
            }
            if (entryValue instanceof Double || entryValue instanceof Float) {
                double dvalue = ((Number)entryValue).doubleValue();
                builder.add(entry.getKey(), dvalue);
                continue;
            }
            if (entryValue instanceof Boolean) {
                boolean flag = (Boolean)entryValue;
                builder.add(entry.getKey(), flag);
                continue;
            }
            if (!(entryValue instanceof String)) continue;
            builder.add(entry.getKey(), entryValue.toString());
        }
        return builder.build();
    }

    JsonValue wrapClaimValue(Object value) {
        JsonValue jsonValue = null;
        if (value instanceof JsonValue) {
            jsonValue = (JsonValue)value;
        } else if (value instanceof String) {
            jsonValue = Json.createObjectBuilder().add(TMP, value.toString()).build().getJsonString(TMP);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            jsonValue = number instanceof Long || number instanceof Integer ? Json.createObjectBuilder().add(TMP, number.longValue()).build().getJsonNumber(TMP) : Json.createObjectBuilder().add(TMP, number.doubleValue()).build().getJsonNumber(TMP);
        } else if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            jsonValue = flag != false ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (value instanceof Collection) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            Collection list = (Collection)value;
            for (Object element : list) {
                if (element instanceof String) {
                    arrayBuilder.add(element.toString());
                    continue;
                }
                JsonValue jvalue = this.wrapClaimValue(element);
                arrayBuilder.add(jvalue);
            }
            jsonValue = arrayBuilder.build();
        } else if (value instanceof Map) {
            jsonValue = this.replaceMapClaims((Map)value);
        }
        return jsonValue;
    }

    private void replaceList(String name) {
        try {
            List list = (List)this.claimsSet.getClaimValue(name, List.class);
            JsonArray array = (JsonArray)this.wrapClaimValue(list);
            this.claimsSet.setClaim(name, (Object)array);
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)("replaceList failure for: " + name), (Throwable)e);
        }
    }

    private void replaceNumber(String name) {
        try {
            Number number = (Number)this.claimsSet.getClaimValue(name, Number.class);
            JsonNumber jsonNumber = (JsonNumber)this.wrapClaimValue(number);
            this.claimsSet.setClaim(name, (Object)jsonNumber);
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)("replaceNumber failure for: " + name), (Throwable)e);
        }
    }
}

