/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime.auth;

import io.quarkus.elytron.security.runtime.ElytronAccount;
import io.quarkus.smallrye.jwt.runtime.auth.JWTCredential;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory;
import io.smallrye.jwt.auth.principal.ParseException;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.evidence.Evidence;

public class JwtIdentityManager
implements IdentityManager {
    private static Logger log = Logger.getLogger(JwtIdentityManager.class);
    private final SecurityDomain domain;

    public JwtIdentityManager(SecurityDomain domain) {
        this.domain = domain;
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        block5: {
            log.debugf("verify, id=%s, credential=%s", (Object)id, (Object)credential);
            try {
                if (!(credential instanceof JWTCredential)) break block5;
                JWTCredential jwtCredential = (JWTCredential)credential;
                try {
                    BearerTokenEvidence evidence = new BearerTokenEvidence(jwtCredential.getBearerToken());
                    SecurityIdentity result = this.domain.authenticate((Evidence)evidence);
                    log.debugf("authenticate, id=%s, result=%s", (Object)id, (Object)result);
                    if (result != null) {
                        return new ElytronAccount(result);
                    }
                }
                catch (RealmUnavailableException e) {
                    log.debugf((Throwable)e, "failed, id=%s, credential=%s", (Object)id, (Object)credential);
                }
            }
            catch (Exception e) {
                log.warnf((Throwable)e, "Failed to verify id=%s", (Object)id);
            }
        }
        return null;
    }

    public Account verify(Credential credential) {
        return null;
    }

    protected JWTCallerPrincipal validate(JWTCredential jwtCredential) throws ParseException {
        JWTCallerPrincipalFactory factory = JWTCallerPrincipalFactory.instance();
        JWTCallerPrincipal callerPrincipal = factory.parse(jwtCredential.getBearerToken(), jwtCredential.getAuthContextInfo());
        return callerPrincipal;
    }
}

