/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ObjectSubstitutionBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.elytron.security.deployment.AuthConfigBuildItem;
import io.quarkus.elytron.security.deployment.IdentityManagerBuildItem;
import io.quarkus.elytron.security.deployment.SecurityDomainBuildItem;
import io.quarkus.elytron.security.deployment.SecurityRealmBuildItem;
import io.quarkus.elytron.security.runtime.AuthConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.smallrye.jwt.runtime.ClaimValueProducer;
import io.quarkus.smallrye.jwt.runtime.CommonJwtProducer;
import io.quarkus.smallrye.jwt.runtime.JWTAuthContextInfoGroup;
import io.quarkus.smallrye.jwt.runtime.JsonValueProducer;
import io.quarkus.smallrye.jwt.runtime.PrincipalProducer;
import io.quarkus.smallrye.jwt.runtime.RawClaimTypeProducer;
import io.quarkus.smallrye.jwt.runtime.SmallRyeJwtTemplate;
import io.quarkus.smallrye.jwt.runtime.auth.ClaimAttributes;
import io.quarkus.smallrye.jwt.runtime.auth.ElytronJwtCallerPrincipal;
import io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMethodExtension;
import io.quarkus.smallrye.jwt.runtime.auth.MpJwtValidator;
import io.quarkus.smallrye.jwt.runtime.auth.PublicKeyProxy;
import io.quarkus.smallrye.jwt.runtime.auth.PublicKeySubstitution;
import io.quarkus.undertow.deployment.ServletExtensionBuildItem;
import io.smallrye.jwt.config.JWTAuthContextInfoProvider;
import io.undertow.security.idm.IdentityManager;
import io.undertow.servlet.ServletExtension;
import java.security.interfaces.RSAPublicKey;
import org.jboss.builder.item.BuildItem;
import org.jboss.logging.Logger;

class SmallRyeJwtProcessor {
    private static final Logger log = Logger.getLogger((String)SmallRyeJwtProcessor.class.getName());
    JWTAuthContextInfoGroup config;

    SmallRyeJwtProcessor() {
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{JWTAuthContextInfoProvider.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(false, new Class[]{MpJwtValidator.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(false, new Class[]{JWTAuthMethodExtension.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{CommonJwtProducer.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{RawClaimTypeProducer.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{PrincipalProducer.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ClaimValueProducer.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{JsonValueProducer.class}));
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("smallrye-jwt");
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    AuthConfigBuildItem configureFileRealmAuthConfig(SmallRyeJwtTemplate template, BuildProducer<ObjectSubstitutionBuildItem> objectSubstitution, BuildProducer<SecurityRealmBuildItem> securityRealm, BeanContainerBuildItem container, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) throws Exception {
        if (this.config.enabled) {
            ObjectSubstitutionBuildItem.Holder pkHolder = new ObjectSubstitutionBuildItem.Holder(RSAPublicKey.class, PublicKeyProxy.class, PublicKeySubstitution.class);
            ObjectSubstitutionBuildItem pkSub = new ObjectSubstitutionBuildItem(pkHolder);
            objectSubstitution.produce((BuildItem)pkSub);
            RuntimeValue realm = template.createTokenRealm(container.getValue());
            AuthConfig authConfig = new AuthConfig();
            authConfig.setAuthMechanism(this.config.authMechanism);
            authConfig.setRealmName(this.config.realmName);
            securityRealm.produce((BuildItem)new SecurityRealmBuildItem(realm, authConfig));
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ClaimAttributes.class.getName()}));
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ElytronJwtCallerPrincipal.class.getName()}));
            return new AuthConfigBuildItem(authConfig);
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void configureIdentityManager(SmallRyeJwtTemplate template, SecurityDomainBuildItem securityDomain, BuildProducer<IdentityManagerBuildItem> identityManagerProducer) {
        IdentityManager identityManager = template.createIdentityManager(securityDomain.getSecurityDomain());
        identityManagerProducer.produce((BuildItem)new IdentityManagerBuildItem(identityManager));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    ServletExtensionBuildItem registerJwtAuthExtension(SmallRyeJwtTemplate template, BeanContainerBuildItem container) {
        log.debugf("registerJwtAuthExtension", new Object[0]);
        ServletExtension authExt = template.createAuthExtension(this.config.authMechanism, container.getValue());
        ServletExtensionBuildItem sebi = new ServletExtensionBuildItem(authExt);
        return sebi;
    }
}

