/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.jwt.runtime.auth.ElytronJwtCallerPrincipal;
import io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMethodExtension;
import io.quarkus.smallrye.jwt.runtime.auth.JwtIdentityManager;
import io.quarkus.smallrye.jwt.runtime.auth.MpJwtValidator;
import io.undertow.security.idm.IdentityManager;
import io.undertow.servlet.ServletExtension;
import java.lang.annotation.Annotation;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;

@Recorder
public class SmallRyeJwtRecorder {
    public IdentityManager createIdentityManager(RuntimeValue<SecurityDomain> securityDomain) {
        return new JwtIdentityManager((SecurityDomain)securityDomain.getValue());
    }

    public ServletExtension createAuthExtension(String authMechanism, BeanContainer container) {
        JWTAuthMethodExtension authExt = (JWTAuthMethodExtension)container.instance(JWTAuthMethodExtension.class, new Annotation[0]);
        authExt.setAuthMechanism(authMechanism);
        return authExt;
    }

    public RuntimeValue<SecurityRealm> createTokenRealm(BeanContainer container) {
        MpJwtValidator jwtValidator = (MpJwtValidator)container.instance(MpJwtValidator.class, new Annotation[0]);
        TokenSecurityRealm tokenRealm = TokenSecurityRealm.builder().claimToPrincipal(claims -> new ElytronJwtCallerPrincipal((Attributes)claims)).validator((TokenValidator)jwtValidator).build();
        return new RuntimeValue((Object)tokenRealm);
    }
}

